/*
 * Decompiled with CFR 0.152.
 */
package scratch;

public class EvolvingChains {
    private int NStates = 2;
    private int L = 50;
    private int[] chain = new int[this.L];
    private double[][] param = new double[this.NStates][this.NStates];

    private int prevState(int t) {
        if (t == 0) {
            return this.chain[this.L - 1];
        }
        return this.chain[t - 1];
    }

    private int state(int t) {
        return this.chain[t];
    }

    private void estimateParam() {
        this.param = new double[this.NStates][this.NStates];
        for (int t = 0; t < this.NStates; ++t) {
            double[] dArray = this.param[this.prevState(t)];
            int n = this.state(t);
            dArray[n] = dArray[n] + 1.0;
        }
        this.normalize();
    }

    private void normalize() {
        for (int s0 = 0; s0 < this.NStates; ++s0) {
            int s1;
            double sum = 0.0;
            for (s1 = 0; s1 < this.NStates; ++s1) {
                sum += this.param[s0][s1];
            }
            for (s1 = 0; s1 < this.NStates; ++s1) {
                this.param[s0][s1] = sum == 0.0 ? 1.0 / (double)this.NStates : this.param[s0][s1] / sum;
            }
        }
    }
}

