/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import fig.basic.IOUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.tui.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Flashcard {
    private static String installPath = "/Users/bouchard/Documents/chinese/flashCards/";
    private static String logPath = installPath + "log/";
    private static Random rand = new Random();
    public static final int HANZI = 0;
    public static final int PINYIN = 1;
    public static final int ENGLISH = 2;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("<card_file> [(<H>|<P>|<E>)]+\n \t<H> is for prompting Hanzi, <P> for Pinyin, <E>, English\n \tFlash cards loaded from : " + installPath + "<card_file>\n" + "\tLearning log stored in  : " + logPath);
            return;
        }
        Quiz quiz = new Quiz(args[0], Flashcard.parseQuizFields(Arrays.asList(args).subList(1, args.length)));
        quiz.quizLoop();
    }

    public static Set<Integer> parseQuizFields(List<String> converted) {
        HashSet<Integer> result = new HashSet<Integer>();
        if (converted.contains("H")) {
            result.add(0);
        }
        if (converted.contains("E")) {
            result.add(2);
        }
        if (converted.contains("P")) {
            result.add(1);
        }
        if (result.size() == 0) {
            result.addAll(Arrays.asList(0, 2, 1));
        }
        return result;
    }

    public static List<Question> generateQuestions(List<Card> cards, Set<Integer> fields) {
        ArrayList<Question> result = new ArrayList<Question>();
        for (Card card : cards) {
            for (int i : fields) {
                result.add(new Question(card, i));
            }
        }
        return result;
    }

    public static class FlashCardParser
    extends DefaultHandler {
        private static List<Card> cards = new ArrayList<Card>();
        private Card current = null;
        private String cTag = null;

        @Override
        public void startElement(String nsURI, String strippedName, String tagName, Attributes attributes) throws SAXException {
            this.cTag = tagName.toLowerCase();
            if (this.cTag.equals("card")) {
                this.current = new Card();
                cards.add(this.current);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String currentStr = new String(ch, start, length);
            if (currentStr == null || currentStr.matches("(\\s+|[\\n])")) {
                return;
            }
            if (this.cTag.equals("a1")) {
                this.current.id = Integer.parseInt(currentStr);
            } else if (this.cTag.equals("a2")) {
                String[] stringArray = this.current.contents;
                stringArray[0] = stringArray[0] + this.parseHanzi(currentStr);
            } else if (this.cTag.equals("a3")) {
                String[] stringArray = this.current.contents;
                stringArray[1] = stringArray[1] + currentStr;
            } else if (this.cTag.equals("a4")) {
                String[] stringArray = this.current.contents;
                stringArray[2] = stringArray[2] + currentStr;
            }
        }

        private String parseHanzi(String currentStr) {
            return currentStr.replaceAll("\\s+", "");
        }

        public List<Card> parse(String file) throws Exception {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(new FlashCardParser());
            String convert = this.fixEntities(file);
            xr.parse(new InputSource(new StringReader(convert)));
            return cards;
        }

        private String fixEntities(String file) throws IOException {
            StringBuilder result = new StringBuilder();
            Iterator<String> iterator = IO.i(file).iterator();
            while (iterator.hasNext()) {
                String line;
                String cLine = line = iterator.next();
                while (cLine.matches(".*[&][#][x][0-9A-Za-z]+[;].*")) {
                    String match = StringUtils.selectRegex("([&][#][x][0-9A-Za-z]+[;])", cLine).get(0);
                    int index = cLine.indexOf(match);
                    String converted = "" + (char)Integer.valueOf(match.substring(3, match.length() - 1), 16).intValue();
                    cLine = cLine.substring(0, index) + converted + cLine.substring(index + match.length(), cLine.length());
                }
                cLine = cLine.replaceAll("[&]", "--amp---");
                result.append(cLine);
                result.append("\n");
            }
            return result.toString();
        }
    }

    public static class Question {
        private final Card card;
        private final int field;

        public Question(Card card, int field) {
            this.card = card;
            this.field = field;
        }

        public String toString() {
            return this.card.contents[this.field];
        }
    }

    public static class Quiz {
        private List<Question> currentDeck;
        private PrintWriter logFile;

        public Quiz(String cardsFile, Set<Integer> fields) throws Exception {
            FlashCardParser fcp = new FlashCardParser();
            List<Card> cards = fcp.parse(installPath + cardsFile);
            this.logFile = IOUtils.openOut(logPath + System.currentTimeMillis());
            this.currentDeck = Flashcard.generateQuestions(cards, fields);
            this.initStats(cardsFile);
        }

        private void initStats(String file) {
            this.logCommit("QUIZ STARTED " + installPath + file);
        }

        public void quizLoop() throws IOException {
            while (this.currentDeck.size() > 0) {
                int randomIndex = rand.nextInt(this.currentDeck.size());
                Question q = this.currentDeck.get(randomIndex);
                this.logCommit("ASKING " + q);
                IO.so("Question   : " + q + "\n");
                Utils.prompt("press enter to continue ");
                System.out.println("\n\n\n");
                this.printAnswer(randomIndex);
                this.logCommit("ANSWER PRINTED");
                String cmd = Utils.prompt("[y']es/e[x]it/fail ");
                if (cmd.equals("y") || cmd.equals("'")) {
                    this.success(randomIndex);
                    continue;
                }
                if (cmd.equals("x")) {
                    this.stop();
                    return;
                }
                this.failure(randomIndex);
            }
        }

        private void stop() {
            this.logCommit("EXIT");
            this.logFile.close();
        }

        private void failure(int index) throws IOException {
            this.logCommit("FAILURE");
            IO.so("\n\n\n");
        }

        private void success(int index) throws IOException {
            this.logCommit("SUCCESS");
            IO.so("\n\n\n");
            this.currentDeck.remove(index);
            IO.so("Good job!---" + this.currentDeck.size() + " left\n");
        }

        private void printAnswer(int index) throws IOException {
            Question q = this.currentDeck.get(index);
            IO.so("Answer was: " + q.card.toString() + "\n");
        }

        private void logCommit(String line) {
            this.logFile.append("" + System.currentTimeMillis() + "\t" + line + "\n");
            this.logFile.flush();
        }
    }

    public static class Card {
        private int id = -1;
        private String[] contents = new String[3];

        public Card() {
            for (int i = 0; i < 3; ++i) {
                this.contents[i] = "";
            }
        }

        public String toString() {
            String result = "";
            for (int i = 0; i < 3; ++i) {
                result = result + this.contents[i] + "\t";
            }
            return "" + this.id + "\t" + result;
        }
    }
}

