/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import fig.basic.NumUtils;
import java.util.Arrays;
import nuts.maxent.DifferentiableFunction;
import nuts.maxent.LBFGSMinimizer;
import nuts.util.CoordinatesPacker;

public class OptimizeMCMCCriterion {
    private int nParams;
    private int nObs;
    private double[][] likelihood = new double[][]{{0.5, 0.2, 0.3}, {0.5, 0.4, 0.1}};
    private double[][] post;
    private double[] prior = new double[]{0.5, 0.5};
    private CoordinatesPacker.MSCoordinatePacker cp = null;

    private double likelihood(int param, int obs) {
        return this.likelihood[param][obs];
    }

    public OptimizeMCMCCriterion() {
        if (this.likelihood.length != this.prior.length) {
            throw new RuntimeException();
        }
        this.nParams = this.likelihood.length;
        this.nObs = this.likelihood[0].length;
        this.cp = new CoordinatesPacker.MSCoordinatePacker(new int[]{this.nObs, this.nParams});
        this.post = this.computePosterior();
    }

    public static void main(String[] args) {
        OptimizeMCMCCriterion omcmcc = new OptimizeMCMCCriterion();
        omcmcc.doIt();
    }

    public void doIt() {
        LBFGSMinimizer minimizer = new LBFGSMinimizer();
        Objective o = new Objective();
        double[] init = new double[o.dimension()];
        for (int i = 0; i < init.length; ++i) {
            init[i] = 1.0;
        }
        double[] result = minimizer.minimize(o, init, 1.0E-5);
        System.out.println(Arrays.toString(result));
    }

    public double get(double[] x, int param, int obs) {
        return x[this.cp.coord2int(obs, param)];
    }

    public double getL(double[] x, int obs) {
        return x[this.cp.size() + obs];
    }

    private double[][] computePosterior() {
        double[][] result = new double[this.nObs][this.nParams];
        for (int ob = 0; ob < this.nObs; ++ob) {
            for (int pa = 0; pa < this.nParams; ++pa) {
                result[ob][pa] = this.prior[pa] * this.likelihood[pa][ob];
            }
            NumUtils.normalize(result[ob]);
        }
        return result;
    }

    private class Objective
    implements DifferentiableFunction {
        private Objective() {
        }

        @Override
        public double[] derivativeAt(double[] x) {
            double[] result = new double[this.dimension()];
            for (int i2 = 0; i2 < OptimizeMCMCCriterion.this.nObs; ++i2) {
                int n2 = 0;
                while (n2 < OptimizeMCMCCriterion.this.nParams) {
                    double sum = 0.0;
                    for (int n = 0; n < OptimizeMCMCCriterion.this.nParams; ++n) {
                        for (int i = 0; i < OptimizeMCMCCriterion.this.nObs; ++i) {
                            for (int m = 0; m < OptimizeMCMCCriterion.this.nParams; ++m) {
                                if (n == n2 && m == n2 && i == i2 && i == 0) {
                                    sum += 2.0 * OptimizeMCMCCriterion.this.likelihood(n, i) * OptimizeMCMCCriterion.this.likelihood(m, 0) * OptimizeMCMCCriterion.this.get(x, n, 0);
                                    continue;
                                }
                                if (n == n2 && i2 == 0) {
                                    sum += OptimizeMCMCCriterion.this.likelihood(n, i) * OptimizeMCMCCriterion.this.likelihood(m, 0) * OptimizeMCMCCriterion.this.get(x, m, i);
                                    continue;
                                }
                                if (m != n2 || i != i2) continue;
                                sum += OptimizeMCMCCriterion.this.likelihood(n, i) * OptimizeMCMCCriterion.this.likelihood(m, 0) * OptimizeMCMCCriterion.this.get(x, n, 0);
                            }
                        }
                    }
                    int coord = OptimizeMCMCCriterion.this.cp.coord2int(i2, n2++);
                    result[coord] = -(sum += OptimizeMCMCCriterion.this.getL(x, i2));
                }
            }
            for (int k = 0; k < OptimizeMCMCCriterion.this.nObs; ++k) {
                double subSum = 0.0;
                for (int p = 0; p < OptimizeMCMCCriterion.this.nParams; ++p) {
                    subSum += OptimizeMCMCCriterion.this.get(x, p, k);
                }
                double current = subSum - 1.0;
                int coord = OptimizeMCMCCriterion.this.cp.size() + k;
                result[coord] = -current;
            }
            return result;
        }

        @Override
        public int dimension() {
            return OptimizeMCMCCriterion.this.cp.size() + OptimizeMCMCCriterion.this.nObs;
        }

        @Override
        public double valueAt(double[] x) {
            double sum = 0.0;
            for (int n = 0; n < OptimizeMCMCCriterion.this.nParams; ++n) {
                for (int i = 0; i < OptimizeMCMCCriterion.this.nObs; ++i) {
                    for (int m = 0; m < OptimizeMCMCCriterion.this.nParams; ++m) {
                        sum += OptimizeMCMCCriterion.this.likelihood(n, i) * OptimizeMCMCCriterion.this.likelihood(m, 0) * OptimizeMCMCCriterion.this.get(x, n, 0) * OptimizeMCMCCriterion.this.get(x, m, i);
                    }
                }
            }
            for (int k = 0; k < OptimizeMCMCCriterion.this.nObs; ++k) {
                double subSum = 0.0;
                for (int p = 0; p < OptimizeMCMCCriterion.this.nParams; ++p) {
                    subSum += OptimizeMCMCCriterion.this.get(x, p, k);
                }
                sum += OptimizeMCMCCriterion.this.getL(x, k) * (subSum - 1.0);
            }
            return -sum;
        }
    }
}

