/*
 * Decompiled with CFR 0.152.
 */
package scratch;

public class PhaseTransition {
    public static void main(String[] args) {
        PhaseTransition.test2();
    }

    public static void test() {
        double alpha = 1.0;
        for (int N = 1; N < 100; ++N) {
            System.out.println("" + N + "," + PhaseTransition.expectedK(N, alpha));
        }
    }

    public static void test2() {
        int N = 200;
        for (double alpha = 0.1; alpha < 200.0; alpha += 0.1) {
            System.out.println("" + alpha + "," + PhaseTransition.expectedK(N, alpha));
        }
    }

    public static double expectedK(int N, double alpha) {
        PartitionPr pp = new PartitionPr(N, alpha);
        double sum = 0.0;
        for (int k = 1; k <= N; ++k) {
            sum += (double)k * pp.c(N, k);
        }
        return sum;
    }

    public static class PartitionPr {
        private double[][] c;
        private int N;
        private double alpha;

        public PartitionPr(int N, double alpha) {
            this.N = N;
            this.alpha = alpha;
            this.c = new double[N + 1][N + 1];
            for (int i = 0; i <= N; ++i) {
                for (int j = 0; j <= N; ++j) {
                    this.c[i][j] = -1.0;
                }
            }
        }

        public double c(int n, int k) {
            if (this.c[n][k] != -1.0) {
                return this.c[n][k];
            }
            double result = 0.0;
            if (n == 1) {
                result = k == 1 ? 1.0 : 0.0;
            } else {
                if (k < 1 || k > n) {
                    return 0.0;
                }
                double den = this.alpha + (double)n - 1.0;
                result = this.alpha * this.c(n - 1, k - 1) / den + ((double)n - 1.0) * this.c(n - 1, k) / den;
            }
            this.c[n][k] = result;
            return result;
        }
    }
}

