/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import fig.basic.Pair;
import java.util.Random;
import nuts.math.Sampling;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class TestExponentials {
    static Random rand = new Random(1L);

    public static void main(String[] args) {
        int nIters = 1000000;
        int nPairs = 2;
        SummaryStatistics s1 = new SummaryStatistics();
        SummaryStatistics s2 = new SummaryStatistics();
        SummaryStatistics a1 = new SummaryStatistics();
        SummaryStatistics a2 = new SummaryStatistics();
        for (int iter = 0; iter < nIters; ++iter) {
            Pair<Double, Double> sampledDatum = TestExponentials.sampled(nPairs);
            Pair<Double, Double> analyticDatum = TestExponentials.analytic(nPairs);
            s1.addValue(sampledDatum.getFirst().doubleValue());
            s2.addValue(sampledDatum.getSecond().doubleValue());
            a1.addValue(analyticDatum.getFirst().doubleValue());
            a2.addValue(analyticDatum.getSecond().doubleValue());
        }
        System.out.println(s1);
        System.out.println(a1);
        System.out.println(s2);
        System.out.println(a2);
    }

    public static Pair<Double, Double> sampled(int nPairs) {
        double small = Double.POSITIVE_INFINITY;
        double larger = -1.0;
        for (int i = 0; i < nPairs; ++i) {
            double d2;
            double d1 = Sampling.sampleExponential(rand, 1.0);
            double min = Math.min(d1, d2 = Sampling.sampleExponential(rand, 1.0));
            if (!(min < small)) continue;
            small = min;
            larger = Math.max(d1, d2);
        }
        return Pair.makePair(small, larger);
    }

    public static Pair<Double, Double> analytic(int nPairs) {
        double delta = Sampling.sampleExponential(rand, 0.5 / (double)nPairs);
        double uni = rand.nextDouble();
        double prj = delta - Math.log(-uni + 1.0);
        return Pair.makePair(delta, prj);
    }
}

