/*
 * Decompiled with CFR 0.152.
 */
package sgi;

import fig.basic.CharEncUtils;
import fig.basic.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import nuts.io.IO;
import sgi.Main;

public class PrepareExperimentalCorpus {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("[zh dir] [en dir] [out]");
            return;
        }
        String dirName1 = args[0];
        String dirName2 = args[1];
        String outName = args[2];
        File d1 = new File(dirName1);
        File d2 = new File(dirName2);
        HashSet<String> files1 = new HashSet<String>(Arrays.asList(d1.list()));
        HashSet<String> files2 = new HashSet<String>(Arrays.asList(d2.list()));
        files1.retainAll(files2);
        PrintWriter out1 = IOUtils.openOut(outName + ".zh");
        PrintWriter out2 = IOUtils.openOut(outName + ".en");
        try {
            for (String fileName : files1) {
                System.out.print(".");
                File f1 = new File(dirName1, fileName);
                File f2 = new File(dirName2, fileName);
                String initEnc = CharEncUtils.getCharEncoding();
                CharEncUtils.setCharEncoding("GB18030");
                int nTrees1 = Main.nTrees(f1.getPath());
                CharEncUtils.setCharEncoding(initEnc);
                int nTrees2 = Main.nTrees(f2.getPath());
                if (nTrees1 != nTrees2) {
                    System.err.println("\nWarning: nTree diverge in " + fileName + " (" + nTrees1 + " neq " + nTrees2);
                    System.err.println("Skipping");
                    continue;
                }
                CharEncUtils.setCharEncoding("GB18030");
                for (String line : IO.i(f1)) {
                    out1.append(line + "\n");
                }
                CharEncUtils.setCharEncoding(initEnc);
                for (String line : IO.i(f2)) {
                    out2.append(line + "\n");
                }
            }
        }
        finally {
            out1.close();
            out2.close();
        }
    }
}

