/*
 * Decompiled with CFR 0.152.
 */
package web;

import fig.basic.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nuts.io.IO;
import nuts.tui.Table;
import nuts.util.CollUtils;

public class ConvertNews
implements Runnable {
    @Option
    public String csvNewsPath = "/Users/bouchard/Documents/courses/stat547-fa2011/misc/news.csv";
    @Option
    public String htmlFilePath = "/Users/bouchard/Documents/courses/stat547-fa2011/web/stat547-fa2011/updates.html";
    @Option
    public String xmlFilePath = "/Users/bouchard/Documents/courses/stat547-fa2011/web/stat547-fa2011/updates.xml";
    @Option
    public String tag = "<!-- news -->";
    @Option
    public String siteRoot = "http://www.stat.ubc.ca/~bouchard/courses/stat547-fa2011/";
    @Option
    public String year = "2011";

    public static void main(String[] args) {
        IO.runLight(args, new ConvertNews());
    }

    @Override
    public void run() {
        String strHtml = IO.f2s(this.htmlFilePath);
        IO.writeToDisk(this.htmlFilePath + ".backup", strHtml);
        String strXml = IO.f2s(this.xmlFilePath);
        IO.writeToDisk(this.xmlFilePath + ".backup", strXml);
        ArrayList<News> newss = CollUtils.list();
        Table t = new Table();
        int r = 0;
        for (List<String> fields : IO.iCSV(this.csvNewsPath)) {
            if (r != 0) {
                newss.add(new News(fields));
            }
            ++r;
        }
        Collections.reverse(newss);
        boolean first = true;
        StringBuilder transformed = new StringBuilder();
        for (String line : strHtml.split("\n")) {
            if (line.contains(this.tag)) {
                if (first) {
                    for (News news : newss) {
                        transformed.append(this.tag + news.toHTML() + "\n");
                    }
                }
                first = false;
                continue;
            }
            transformed.append(line + "\n");
        }
        IO.writeToDisk(this.htmlFilePath, transformed.toString());
        first = true;
        transformed = new StringBuilder();
        for (String line : strXml.split("\n")) {
            if (line.contains(this.tag)) {
                if (first) {
                    transformed.append(this.tag + "<!--lastBuildDate>" + ((News)newss.get(0)).dateStr + "</lastBuildDate-->\n");
                    transformed.append(this.tag + "<!--pubDate>" + ((News)newss.get(newss.size() - 1)).dateStr + "</pubDat-->\n");
                    for (News news : newss) {
                        transformed.append(this.tag + news.toXML() + "\n");
                    }
                }
                first = false;
                continue;
            }
            transformed.append(line + "\n");
        }
        IO.writeToDisk(this.xmlFilePath, transformed.toString());
    }

    public class News {
        private int id;
        private String dateStr;
        private String shortDate;
        private String desc;

        public News(List<String> fields) {
            for (String str : fields) {
                if (!str.contains("\n")) continue;
                throw new RuntimeException("MAKE SURE THERE ARE NOT NEW LINES IN THE INDIVIDUAL CSV ENTRIES");
            }
            this.id = Integer.parseInt(fields.get(0));
            this.dateStr = fields.get(3) + " " + fields.get(1) + " " + ConvertNews.this.year + " " + fields.get(4) + ":00:00 PST";
            this.shortDate = fields.get(3) + " " + fields.get(1) + ", " + fields.get(4) + ":00";
            this.desc = fields.get(5);
        }

        public String toXML() {
            return "<item><title>" + this.desc + "</title>" + "<link>" + ConvertNews.this.siteRoot + "updates.html#up" + this.id + "</link>" + "<description>" + this.desc + "</description>" + "<guid>" + ConvertNews.this.siteRoot + "updates.html#up" + this.id + "</guid>" + "<!--pubDate>" + this.dateStr + "</pubDate-->" + "</item>\n";
        }

        public String toHTML() {
            return "<li id=\"up" + this.id + "\">" + this.shortDate + " : " + this.desc + "</li>\n";
        }
    }
}

