/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.swing.JOptionPane;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.tools.PhylogeneticInferenceOptions;
import org.forester.archaeopteryx.tools.RunnableProcess;
import org.forester.evoinference.distance.NeighborJoining;
import org.forester.evoinference.distance.PairwiseDistanceCalculator;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.evoinference.tools.BootstrapResampler;
import org.forester.io.parsers.FastaParser;
import org.forester.io.writers.SequenceWriter;
import org.forester.msa.BasicMsa;
import org.forester.msa.Mafft;
import org.forester.msa.Msa;
import org.forester.msa.MsaInferrer;
import org.forester.msa.MsaMethods;
import org.forester.msa.ResampleableMsa;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sequence.Sequence;
import org.forester.tools.ConfidenceAssessor;
import org.forester.util.ForesterUtil;

public class PhylogeneticInferrer
extends RunnableProcess {
    private Msa _msa;
    private final MainFrameApplication _mf;
    private final PhylogeneticInferenceOptions _options;
    private final List<Sequence> _seqs;
    private final boolean DEBUG = true;
    public static final String MSA_FILE_SUFFIX = ".aln";
    public static final String PWD_FILE_SUFFIX = ".pwd";

    public PhylogeneticInferrer(List<Sequence> list, PhylogeneticInferenceOptions phylogeneticInferenceOptions, MainFrameApplication mainFrameApplication) {
        this._msa = null;
        this._seqs = list;
        this._mf = mainFrameApplication;
        this._options = phylogeneticInferenceOptions;
    }

    public PhylogeneticInferrer(Msa msa, PhylogeneticInferenceOptions phylogeneticInferenceOptions, MainFrameApplication mainFrameApplication) {
        this._msa = msa;
        this._seqs = null;
        this._mf = mainFrameApplication;
        this._options = phylogeneticInferenceOptions;
    }

    private Msa inferMsa() throws IOException, InterruptedException {
        File file = File.createTempFile("__msa__temp__", ".fasta");
        System.out.println();
        System.out.println("temp file: " + file);
        System.out.println();
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        SequenceWriter.writeSeqs(this._seqs, bufferedWriter, SequenceWriter.SEQ_FORMAT.FASTA, 100);
        bufferedWriter.close();
        List<String> list = this.processMafftOptions();
        return this.runMAFFT(file, list);
    }

    private List<String> processMafftOptions() {
        String string = this._options.getMsaPrgParameters().trim().toLowerCase();
        String[] stringArray = string.split(" ");
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (String string2 : stringArray) {
            arrayList.add(string2);
            if (!string2.equals("--quiet")) continue;
            bl = true;
        }
        if (!bl) {
            arrayList.add("--quiet");
        }
        return arrayList;
    }

    private Phylogeny inferPhylogeny(Msa msa) {
        Object object;
        BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix = null;
        switch (this._options.getPwdDistanceMethod()) {
            case KIMURA_DISTANCE: {
                basicSymmetricalDistanceMatrix = PairwiseDistanceCalculator.calcKimuraDistances(msa);
                break;
            }
            case POISSON_DISTANCE: {
                basicSymmetricalDistanceMatrix = PairwiseDistanceCalculator.calcPoissonDistances(msa);
                break;
            }
            case FRACTIONAL_DISSIMILARITY: {
                basicSymmetricalDistanceMatrix = PairwiseDistanceCalculator.calcFractionalDissimilarities(msa);
                break;
            }
            default: {
                throw new RuntimeException("invalid pwd method");
            }
        }
        if (!ForesterUtil.isEmpty(this._options.getIntermediateFilesBase())) {
            try {
                object = new BufferedWriter(new FileWriter(this._options.getIntermediateFilesBase() + PWD_FILE_SUFFIX));
                basicSymmetricalDistanceMatrix.write((Writer)object);
                ((BufferedWriter)object).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        object = NeighborJoining.createInstance();
        Phylogeny phylogeny = ((NeighborJoining)object).execute(basicSymmetricalDistanceMatrix);
        PhylogeneticInferrer.extractFastaInformation(phylogeny);
        return phylogeny;
    }

    private void infer() throws InterruptedException {
        if (this._msa == null && this._seqs == null) {
            throw new IllegalArgumentException("cannot run phylogenetic analysis with null msa and seq array");
        }
        this.start(this._mf, "phylogenetic inference");
        if (this._msa == null) {
            Msa msa = null;
            try {
                msa = this.inferMsa();
            }
            catch (IOException iOException) {
                this.end(this._mf);
                JOptionPane.showMessageDialog(this._mf, "Could not create multiple sequence alignment with \"" + this._options.getMsaPrg() + "\" and the following parameters:\n\"" + this._options.getMsaPrgParameters() + "\"\nError: " + iOException.getLocalizedMessage(), "Failed to Calculate MSA", 0);
                iOException.printStackTrace();
                return;
            }
            catch (Exception exception) {
                this.end(this._mf);
                JOptionPane.showMessageDialog(this._mf, "Could not create multiple sequence alignment with \"" + this._options.getMsaPrg() + "\" and the following parameters:\n\"" + this._options.getMsaPrgParameters() + "\"\nError: " + exception.getLocalizedMessage(), "Unexpected Exception During MSA Calculation", 0);
                exception.printStackTrace();
                return;
            }
            if (msa == null) {
                this.end(this._mf);
                JOptionPane.showMessageDialog(this._mf, "Could not create multiple sequence alignment with " + this._options.getMsaPrg() + "\nand the following parameters:\n\"" + this._options.getMsaPrgParameters() + "\"", "Failed to Calculate MSA", 0);
                return;
            }
            System.out.println(msa.toString());
            System.out.println(MsaMethods.calcBasicGapinessStatistics(msa).toString());
            MsaMethods msaMethods = MsaMethods.createInstance();
            if (this._options.isExecuteMsaProcessing() && (msa = msaMethods.removeGapColumns(this._options.getMsaProcessingMaxAllowedGapRatio(), this._options.getMsaProcessingMinAllowedLength(), msa)) == null) {
                this.end(this._mf);
                JOptionPane.showMessageDialog(this._mf, "Less than two sequences longer than " + this._options.getMsaProcessingMinAllowedLength() + " residues left after MSA processing", "MSA Processing Settings Too Stringent", 0);
                return;
            }
            System.out.println(msaMethods.getIgnoredSequenceIds());
            System.out.println(msa.toString());
            System.out.println(MsaMethods.calcBasicGapinessStatistics(msa).toString());
            this._msa = msa;
        }
        int n = this._options.getBootstrapSamples();
        long l = this._options.getRandomNumberGeneratorSeed();
        Phylogeny phylogeny = this.inferPhylogeny(this._msa);
        if (this._options.isPerformBootstrapResampling() && n > 0) {
            ResampleableMsa resampleableMsa = new ResampleableMsa((BasicMsa)this._msa);
            int[][] nArray = BootstrapResampler.createResampledColumnPositions(this._msa.getLength(), n, l);
            Phylogeny[] phylogenyArray = new Phylogeny[n];
            for (int i = 0; i < n; ++i) {
                resampleableMsa.resample(nArray[i]);
                phylogenyArray[i] = this.inferPhylogeny(resampleableMsa);
            }
            ConfidenceAssessor.evaluate("bootstrap", phylogenyArray, phylogeny, true, 1.0);
        }
        this._mf.getMainPanel().addPhylogenyInNewTab(phylogeny, this._mf.getConfiguration(), "nj", "njpath");
        this.end(this._mf);
        JOptionPane.showMessageDialog(this._mf, "Inference successfully completed", "Inference Completed", 1);
    }

    @Override
    public void run() {
        try {
            this.infer();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private Msa runMAFFT(File file, List<String> list) throws IOException, InterruptedException {
        Msa msa = null;
        MsaInferrer msaInferrer = Mafft.createInstance();
        try {
            msa = msaInferrer.infer(file, list);
        }
        catch (IOException iOException) {
            System.out.println(msaInferrer.getErrorDescription());
        }
        return msa;
    }

    private void writeToFiles(BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix) {
        if (!ForesterUtil.isEmpty(this._options.getIntermediateFilesBase())) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this._options.getIntermediateFilesBase() + MSA_FILE_SUFFIX));
                this._msa.write(bufferedWriter);
                bufferedWriter.close();
                BufferedWriter bufferedWriter2 = new BufferedWriter(new FileWriter(this._options.getIntermediateFilesBase() + PWD_FILE_SUFFIX));
                basicSymmetricalDistanceMatrix.write(bufferedWriter2);
                bufferedWriter2.close();
            }
            catch (Exception exception) {
                System.out.println("Error: " + exception.getMessage());
            }
        }
    }

    public static void extractFastaInformation(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            Matcher matcher;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (ForesterUtil.isEmpty(phylogenyNode.getName()) || !(matcher = FastaParser.FASTA_DESC_LINE.matcher(phylogenyNode.getName())).lookingAt()) continue;
            System.out.println();
            String string = matcher.group(1);
            String string2 = matcher.group(2);
            String string3 = matcher.group(3);
            String string4 = matcher.group(4);
            if (!ForesterUtil.isEmpty(string) && !ForesterUtil.isEmpty(string2)) {
                AptxUtil.ensurePresenceOfSequence(phylogenyNode);
                phylogenyNode.getNodeData().getSequence(0).setAccession(new Accession(string2, string));
            }
            if (!ForesterUtil.isEmpty(string3)) {
                AptxUtil.ensurePresenceOfSequence(phylogenyNode);
                phylogenyNode.getNodeData().getSequence(0).setName(string3);
            }
            if (ForesterUtil.isEmpty(string4)) continue;
            AptxUtil.ensurePresenceOfTaxonomy(phylogenyNode);
            phylogenyNode.getNodeData().getTaxonomy(0).setScientificName(string4);
        }
    }
}

