/*
 * Decompiled with CFR 0.152.
 */
package spoon.processing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import spoon.Launcher;
import spoon.processing.AbstractManualProcessor;
import spoon.processing.Property;
import spoon.processing.Severity;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtGenericElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.processing.XmlProcessorProperties;

public class XMLAnnotationProcessor
extends AbstractManualProcessor {
    @Property
    public String xmlPath = "annotations.xml";
    private Document document;

    @Override
    public final void init() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(this.getClass().getClassLoader().getResourceAsStream(this.xmlPath));
        }
        catch (SAXParseException spe) {
            this.getEnvironment().report(this, Severity.ERROR, "XML parsing error line " + spe.getLineNumber() + ", uri " + spe.getSystemId());
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            Launcher.logger.error(((Throwable)x).getMessage(), x);
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            Launcher.logger.error(((Throwable)x).getMessage(), x);
        }
        catch (ParserConfigurationException pce) {
            Launcher.logger.error(pce.getMessage(), pce);
        }
        catch (IOException ioe) {
            Launcher.logger.error(ioe.getMessage(), ioe);
        }
    }

    protected boolean isTypeMatching(CtType<?> type, String typeExpression) {
        return Pattern.matches(typeExpression, type.getQualifiedName());
    }

    protected boolean isExecutableMatching(CtExecutable<?> executable, String executableExpression) {
        String signature = executable.getSignature();
        return Pattern.matches(executableExpression, signature);
    }

    protected boolean isFieldMatching(CtField<?> field, String fieldExpression) {
        String signature = field.getSignature();
        return Pattern.matches(fieldExpression, signature);
    }

    @Override
    public final void process() {
        Element root = this.document.getDocumentElement();
        NodeList nodeList = root.getElementsByTagName("class");
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Element clazz = (Element)nodeList.item(i);
            String nameExpr = clazz.getAttribute("expr");
            for (CtType<?> t : this.getFactory().Type().getAll(true)) {
                if (!this.isTypeMatching(t, nameExpr)) continue;
                try {
                    this.annotateElement(t, clazz);
                }
                catch (Exception e) {
                    Launcher.logger.error(e.getMessage(), e);
                }
                NodeList nodeList3 = clazz.getElementsByTagName("field");
                for (int j = 0; j < nodeList3.getLength(); ++j) {
                    Element fieldElt = (Element)nodeList3.item(j);
                    if (fieldElt.getParentNode() != clazz) continue;
                    String fieldExpr = fieldElt.getAttribute("expr");
                    for (CtField<?> field : t.getFields()) {
                        if (!this.isFieldMatching(field, fieldExpr)) continue;
                        try {
                            this.annotateElement(field, fieldElt);
                        }
                        catch (Exception e) {
                            Launcher.logger.error(e.getMessage(), e);
                        }
                    }
                }
                if (!(t instanceof CtType)) continue;
                ArrayList<CtGenericElement> executables = new ArrayList<CtGenericElement>();
                executables.addAll(t.getMethods());
                if (t instanceof CtClass) {
                    executables.addAll(((CtClass)t).getConstructors());
                }
                NodeList nodeList2 = clazz.getElementsByTagName("executable");
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element executableElt = (Element)nodeList2.item(j);
                    if (executableElt.getParentNode() != clazz) continue;
                    String executableExpr = executableElt.getAttribute("expr");
                    for (CtExecutable ctExecutable : executables) {
                        if (!this.isExecutableMatching(ctExecutable, executableExpr)) continue;
                        try {
                            this.annotateElement(ctExecutable, executableElt);
                        }
                        catch (Exception e) {
                            Launcher.logger.error(e.getMessage(), e);
                        }
                    }
                }
            }
        }
    }

    private void annotateElement(CtElement javaElt, Element xmlNode) throws Exception {
        NodeList annNodeList = xmlNode.getElementsByTagName("annotation");
        for (int i = 0; i < annNodeList.getLength(); ++i) {
            Element annotationNode = (Element)annNodeList.item(i);
            if (annotationNode.getParentNode() != xmlNode) continue;
            String name = annotationNode.getAttribute("name");
            CtTypeReference aref = this.getFactory().Annotation().createReference(name);
            this.getFactory().Annotation().annotate(javaElt, aref);
            NodeList fieldNodeList = annotationNode.getElementsByTagName("element");
            for (int f = 0; f < fieldNodeList.getLength(); ++f) {
                Element fieldNode = (Element)fieldNodeList.item(f);
                String fieldName = fieldNode.getAttribute("name");
                String fieldValue = fieldNode.getAttribute("value");
                Class<?> type = aref.getActualClass().getMethod(fieldName, new Class[0]).getReturnType();
                Object v = ((XmlProcessorProperties)this.getEnvironment().getProcessorProperties(this.getClass().getName())).convert(type, fieldValue);
                this.getFactory().Annotation().annotate(javaElt, aref, fieldName, v);
            }
        }
    }
}

