/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.reference;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import spoon.Launcher;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;
import spoon.support.visitor.SignaturePrinter;

public abstract class CtReferenceImpl
implements CtReference,
Serializable,
Comparable<CtReference> {
    private static final long serialVersionUID = 1L;
    String simplename;
    transient Factory factory;

    @Override
    public int compareTo(CtReference o) {
        SignaturePrinter pr = new SignaturePrinter();
        pr.scan(this);
        String current = pr.getSignature();
        pr.reset();
        pr.scan(o);
        return current.compareTo(pr.getSignature());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof CtReference) {
            return this.compareTo((CtReference)object) == 0;
        }
        return false;
    }

    protected abstract AnnotatedElement getActualAnnotatedElement();

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        CtElement e = this.getDeclaration();
        if (e != null) {
            return e.getAnnotation(annotationType);
        }
        return this.getActualAnnotatedElement().getAnnotation(annotationType);
    }

    @Override
    public <A extends Annotation> CtAnnotation<A> getAnnotation(CtTypeReference<A> annotationType) {
        CtElement e = this.getDeclaration();
        if (e != null) {
            return e.getAnnotation(annotationType);
        }
        try {
            Class<A> ac = annotationType.getActualClass();
            A a = this.getActualAnnotatedElement().getAnnotation(ac);
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (Method m : ac.getMethods()) {
                Object value = m.invoke(a, new Object[0]);
                if (value instanceof Class) {
                    Class clazz = (Class)value;
                    values.put(m.getName(), this.getFactory().Type().createReference(clazz));
                    continue;
                }
                values.put(m.getName(), value);
            }
            CtAnnotation ctAnnotation = this.getFactory().Core().createAnnotation();
            ctAnnotation.setElementValues(values);
            return ctAnnotation;
        }
        catch (Exception ex) {
            Launcher.logger.error(ex.getMessage(), ex);
            return null;
        }
    }

    @Override
    public List<Annotation> getAnnotations() {
        CtElement e = this.getDeclaration();
        if (e != null) {
            Annotation[] annotations = new Annotation[e.getAnnotations().size()];
            int i = 0;
            for (CtAnnotation<? extends Annotation> a : e.getAnnotations()) {
                annotations[i++] = a.getActualAnnotation();
            }
            return Arrays.asList(annotations);
        }
        AnnotatedElement elt = this.getActualAnnotatedElement();
        return Arrays.asList(elt.getAnnotations());
    }

    @Override
    public String getSimpleName() {
        return this.simplename;
    }

    @Override
    public void setSimpleName(String simplename) {
        if (simplename.contains("?")) {
            throw new RuntimeException("argl");
        }
        this.simplename = simplename;
    }

    public String toString() {
        DefaultJavaPrettyPrinter printer = new DefaultJavaPrettyPrinter(this.getFactory().getEnvironment());
        printer.scan(this);
        return printer.toString();
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
    }
}

