/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;

public class TypeReferenceScanner
extends CtScanner {
    Set<CtTypeReference<?>> references;

    public TypeReferenceScanner() {
        this.references = new HashSet();
    }

    public TypeReferenceScanner(HashSet<CtTypeReference<?>> references) {
        this.references = references;
    }

    public Set<CtTypeReference<?>> getReferences() {
        return this.references;
    }

    private <T> boolean addReference(CtTypeReference<T> ref) {
        return this.references.add(ref);
    }

    @Override
    public <T> void visitCtSuperAccess(CtSuperAccess<T> f) {
        this.enter(f);
        this.scan(f.getVariable());
        this.scan(f.getAnnotations());
        this.scanReferences(f.getTypeCasts());
        this.scan(f.getVariable());
        this.scan((CtElement)f.getTarget());
        this.exit(f);
    }

    @Override
    public <T> void visitCtFieldAccess(CtFieldAccess<T> f) {
        this.enter(f);
        this.scan(f.getVariable());
        this.scan(f.getAnnotations());
        this.scanReferences(f.getTypeCasts());
        this.scan(f.getVariable());
        this.scan((CtElement)f.getTarget());
        this.exit(f);
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        this.enterReference(reference);
        this.scan(reference.getDeclaringType());
        this.exitReference(reference);
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        this.enterReference(reference);
        this.scanReferences(reference.getActualTypeArguments());
        this.scanReferences(reference.getActualTypeArguments());
        this.exitReference(reference);
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
        if (!(reference instanceof CtArrayTypeReference)) {
            this.addReference(reference);
        }
        super.visitCtTypeReference(reference);
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        this.addReference(annotationType.getReference());
        super.visitCtAnnotationType(annotationType);
    }

    @Override
    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.addReference(ctEnum.getReference());
        super.visitCtEnum(ctEnum);
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        this.addReference(intrface.getReference());
        for (CtType<?> t : intrface.getNestedTypes()) {
            this.addReference(t.getReference());
        }
        super.visitCtInterface(intrface);
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.addReference(ctClass.getReference());
        for (CtType<?> t : ctClass.getNestedTypes()) {
            this.addReference(t.getReference());
        }
        super.visitCtClass(ctClass);
    }
}

