/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.vectors;

import JSci.GlobalSettings;
import JSci.maths.Mapping;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.matrices.DoubleSparseMatrix;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.DoubleVector;
import JSci.maths.vectors.MathVector;
import JSci.maths.vectors.VectorDimensionException;

public final class DoubleSparseVector
extends AbstractDoubleVector {
    private double[] vector;
    private int[] pos;
    private int count = 0;
    private int capacityIncrement = 1;

    public DoubleSparseVector(int n) {
        super(n);
        this.vector = new double[0];
        this.pos = new int[0];
    }

    public DoubleSparseVector(int n, int n2) {
        this(n);
        this.capacityIncrement = n2;
    }

    public DoubleSparseVector(double[] dArray) {
        super(dArray.length);
        int n;
        int n2 = 0;
        for (n = 0; n < this.N; ++n) {
            if (!(Math.abs(dArray[n]) > GlobalSettings.ZERO_TOL)) continue;
            ++n2;
        }
        this.count = n2;
        this.vector = new double[n2];
        this.pos = new int[n2];
        n2 = 0;
        for (n = 0; n < this.N; ++n) {
            if (!(Math.abs(dArray[n]) > GlobalSettings.ZERO_TOL)) continue;
            this.vector[n2] = dArray[n];
            this.pos[n2] = n;
            ++n2;
        }
    }

    public boolean equals(Object object, double d) {
        if (object != null && object instanceof DoubleSparseVector && this.N == ((DoubleSparseVector)object).N) {
            DoubleSparseVector doubleSparseVector = (DoubleSparseVector)object;
            double d2 = 0.0;
            for (int i = 0; i < this.count; ++i) {
                if (this.pos[i] != doubleSparseVector.pos[i]) {
                    return false;
                }
                double d3 = this.vector[i] - doubleSparseVector.vector[i];
                d2 += d3 * d3;
            }
            return d2 <= d * d;
        }
        return false;
    }

    public double getComponent(int n) {
        int n2;
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
        }
        for (n2 = 0; n2 < this.count && this.pos[n2] < n; ++n2) {
        }
        if (n2 < this.count && this.pos[n2] == n) {
            return this.vector[n2];
        }
        return 0.0;
    }

    public void setComponent(int n, double d) {
        int n2;
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
        }
        for (n2 = 0; n2 < this.count && this.pos[n2] < n; ++n2) {
        }
        if (n2 < this.count && this.pos[n2] == n) {
            if (Math.abs(d) <= GlobalSettings.ZERO_TOL) {
                System.arraycopy(this.vector, n2 + 1, this.vector, n2, this.count - n2 - 1);
                System.arraycopy(this.pos, n2 + 1, this.pos, n2, this.count - n2 - 1);
                --this.count;
            } else {
                this.vector[n2] = d;
            }
        } else if (Math.abs(d) > GlobalSettings.ZERO_TOL) {
            if (this.count == this.vector.length) {
                double[] dArray = this.vector;
                int[] nArray = this.pos;
                this.vector = new double[dArray.length + this.capacityIncrement];
                this.pos = new int[nArray.length + this.capacityIncrement];
                System.arraycopy(dArray, 0, this.vector, 0, n2);
                System.arraycopy(nArray, 0, this.pos, 0, n2);
                System.arraycopy(dArray, n2, this.vector, n2 + 1, dArray.length - n2);
                System.arraycopy(nArray, n2, this.pos, n2 + 1, nArray.length - n2);
            } else {
                System.arraycopy(this.vector, n2, this.vector, n2 + 1, this.count - n2);
                System.arraycopy(this.pos, n2, this.pos, n2 + 1, this.count - n2);
            }
            this.vector[n2] = d;
            this.pos[n2] = n;
            ++this.count;
        }
    }

    public int componentCount() {
        return this.count;
    }

    public double norm() {
        return Math.sqrt(this.sumSquares());
    }

    public double sumSquares() {
        double d = 0.0;
        for (int i = 0; i < this.count; ++i) {
            d += this.vector[i] * this.vector[i];
        }
        return d;
    }

    public double mass() {
        double d = 0.0;
        for (int i = 0; i < this.count; ++i) {
            d += this.vector[i];
        }
        return d;
    }

    public AbelianGroup.Member negate() {
        DoubleSparseVector doubleSparseVector = new DoubleSparseVector(this.N);
        doubleSparseVector.count = this.count;
        doubleSparseVector.vector = new double[this.count];
        doubleSparseVector.pos = new int[this.count];
        System.arraycopy(this.pos, 0, doubleSparseVector.pos, 0, this.count);
        for (int i = 0; i < this.count; ++i) {
            doubleSparseVector.vector[i] = -this.vector[i];
        }
        return doubleSparseVector;
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof AbstractDoubleVector) {
            return this.add((AbstractDoubleVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector add(AbstractDoubleVector abstractDoubleVector) {
        int n;
        if (abstractDoubleVector instanceof DoubleSparseVector) {
            return this.add((DoubleSparseVector)abstractDoubleVector);
        }
        if (abstractDoubleVector instanceof DoubleVector) {
            return this.add((DoubleVector)abstractDoubleVector);
        }
        if (this.N != abstractDoubleVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        dArray[0] = abstractDoubleVector.getComponent(0);
        for (n = 1; n < this.N; ++n) {
            dArray[n] = abstractDoubleVector.getComponent(n);
        }
        for (n = 0; n < this.count; ++n) {
            int n2 = this.pos[n];
            dArray[n2] = dArray[n2] + this.vector[n];
        }
        return new DoubleVector(dArray);
    }

    public DoubleVector add(DoubleVector doubleVector) {
        if (this.N != doubleVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        System.arraycopy(doubleVector.vector, 0, dArray, 0, this.N);
        for (int i = 0; i < this.count; ++i) {
            int n = this.pos[i];
            dArray[n] = dArray[n] + this.vector[i];
        }
        return new DoubleVector(dArray);
    }

    public DoubleSparseVector add(DoubleSparseVector doubleSparseVector) {
        int n;
        if (this.N != doubleSparseVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        for (n = 0; n < this.count; ++n) {
            dArray[this.pos[n]] = this.vector[n] + doubleSparseVector.getComponent(this.pos[n]);
        }
        for (int i = 0; i < doubleSparseVector.count; ++i) {
            n = doubleSparseVector.pos[i];
            dArray[n] = this.getComponent(n) + doubleSparseVector.vector[i];
        }
        return new DoubleSparseVector(dArray);
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof AbstractDoubleVector) {
            return this.subtract((AbstractDoubleVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector subtract(AbstractDoubleVector abstractDoubleVector) {
        int n;
        if (abstractDoubleVector instanceof DoubleSparseVector) {
            return this.subtract((DoubleSparseVector)abstractDoubleVector);
        }
        if (abstractDoubleVector instanceof DoubleVector) {
            return this.subtract((DoubleVector)abstractDoubleVector);
        }
        if (this.N != abstractDoubleVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        dArray[0] = -abstractDoubleVector.getComponent(0);
        for (n = 1; n < this.N; ++n) {
            dArray[n] = -abstractDoubleVector.getComponent(n);
        }
        for (n = 0; n < this.count; ++n) {
            int n2 = this.pos[n];
            dArray[n2] = dArray[n2] + this.vector[n];
        }
        return new DoubleVector(dArray);
    }

    public DoubleVector subtract(DoubleVector doubleVector) {
        int n;
        if (this.N != doubleVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        dArray[0] = -doubleVector.vector[0];
        for (n = 1; n < this.N; ++n) {
            dArray[n] = -doubleVector.vector[n];
        }
        for (n = 0; n < this.count; ++n) {
            int n2 = this.pos[n];
            dArray[n2] = dArray[n2] + this.vector[n];
        }
        return new DoubleVector(dArray);
    }

    public DoubleSparseVector subtract(DoubleSparseVector doubleSparseVector) {
        int n;
        if (this.N != doubleSparseVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        for (n = 0; n < this.count; ++n) {
            dArray[this.pos[n]] = this.vector[n] - doubleSparseVector.getComponent(this.pos[n]);
        }
        for (int i = 0; i < doubleSparseVector.count; ++i) {
            n = doubleSparseVector.pos[i];
            dArray[n] = this.getComponent(n) - doubleSparseVector.vector[i];
        }
        return new DoubleSparseVector(dArray);
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector scalarMultiply(double d) {
        DoubleSparseVector doubleSparseVector = new DoubleSparseVector(this.N);
        doubleSparseVector.count = this.count;
        doubleSparseVector.vector = new double[this.count];
        doubleSparseVector.pos = new int[this.count];
        System.arraycopy(this.pos, 0, doubleSparseVector.pos, 0, this.count);
        for (int i = 0; i < this.count; ++i) {
            doubleSparseVector.vector[i] = d * this.vector[i];
        }
        return doubleSparseVector;
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractDoubleVector scalarDivide(double d) {
        DoubleSparseVector doubleSparseVector = new DoubleSparseVector(this.N);
        doubleSparseVector.count = this.count;
        doubleSparseVector.vector = new double[this.count];
        doubleSparseVector.pos = new int[this.count];
        System.arraycopy(this.pos, 0, doubleSparseVector.pos, 0, this.count);
        for (int i = 0; i < this.count; ++i) {
            doubleSparseVector.vector[i] = this.vector[i] / d;
        }
        return doubleSparseVector;
    }

    public double scalarProduct(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector instanceof DoubleSparseVector) {
            return this.scalarProduct((DoubleSparseVector)abstractDoubleVector);
        }
        if (abstractDoubleVector instanceof DoubleVector) {
            return this.scalarProduct((DoubleVector)abstractDoubleVector);
        }
        if (this.N != abstractDoubleVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double d = 0.0;
        for (int i = 0; i < this.count; ++i) {
            d += this.vector[i] * abstractDoubleVector.getComponent(this.pos[i]);
        }
        return d;
    }

    public double scalarProduct(DoubleVector doubleVector) {
        if (this.N != doubleVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double d = 0.0;
        for (int i = 0; i < this.count; ++i) {
            d += this.vector[i] * doubleVector.vector[this.pos[i]];
        }
        return d;
    }

    public double scalarProduct(DoubleSparseVector doubleSparseVector) {
        if (this.N != doubleSparseVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double d = 0.0;
        if (this.count <= doubleSparseVector.count) {
            for (int i = 0; i < this.count; ++i) {
                d += this.vector[i] * doubleSparseVector.getComponent(this.pos[i]);
            }
        } else {
            for (int i = 0; i < doubleSparseVector.count; ++i) {
                d += this.getComponent(doubleSparseVector.pos[i]) * doubleSparseVector.vector[i];
            }
        }
        return d;
    }

    public DoubleSparseMatrix tensorProduct(DoubleSparseVector doubleSparseVector) {
        DoubleSparseMatrix doubleSparseMatrix = new DoubleSparseMatrix(this.N, doubleSparseVector.N);
        for (int i = 0; i < this.count; ++i) {
            for (int j = 0; j < doubleSparseVector.count; ++j) {
                doubleSparseMatrix.setElement(this.pos[i], doubleSparseVector.pos[j], this.vector[i] * doubleSparseVector.vector[j]);
            }
        }
        return doubleSparseMatrix;
    }

    public AbstractDoubleVector mapComponents(Mapping mapping) {
        double d = mapping.map(0.0);
        if (Math.abs(d) <= GlobalSettings.ZERO_TOL) {
            return this.sparseMap(mapping);
        }
        return this.generalMap(mapping, d);
    }

    private AbstractDoubleVector sparseMap(Mapping mapping) {
        DoubleSparseVector doubleSparseVector = new DoubleSparseVector(this.N);
        doubleSparseVector.count = this.count;
        doubleSparseVector.vector = new double[this.count];
        doubleSparseVector.pos = new int[this.count];
        System.arraycopy(this.pos, 0, doubleSparseVector.pos, 0, this.count);
        for (int i = 0; i < this.count; ++i) {
            doubleSparseVector.vector[i] = mapping.map(this.vector[i]);
        }
        return doubleSparseVector;
    }

    private AbstractDoubleVector generalMap(Mapping mapping, double d) {
        int n;
        double[] dArray = new double[this.N];
        for (n = 0; n < this.N; ++n) {
            dArray[n] = d;
        }
        for (n = 0; n < this.count; ++n) {
            dArray[n] = mapping.map(this.vector[this.pos[n]]);
        }
        return new DoubleVector(dArray);
    }
}

