/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies3;

import JSci.maths.ArrayMath;
import JSci.maths.NumericalConstants;
import JSci.maths.WaveletMath;
import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.Multiresolution;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies3.Scaling3;
import JSci.maths.wavelet.daubechies3.Wavelet3;

public final class Daubechies3
extends Multiresolution
implements Filter,
NumericalConstants {
    protected static final int filtretype = 4;
    protected static final int minlength = 8;
    static final double[] vgtemp = new double[]{0.33267055295, 0.806891509311, 0.459877502118, -0.13501102001, -0.085441273882, 0.035226291882};
    static final double[] v0temp = new double[]{0.689047760315, 0.724715933318};
    static final double[] v1temp = new double[]{0.0306457241755, -0.0291374408035, -0.986047279405, 0.161005005859};
    static final double[] v2temp = new double[]{0.0172802631418, -0.0164297845102, 0.00443452721664, 0.0208960300827, -0.924034270866, 0.380966943247};
    static final double[] v3temp = new double[]{0.027026368393, -0.0256962180001, 0.0639688879804, 0.381971870809, 0.176750229211, 0.404677356783, -0.747429432607, 0.308155135811};
    static final double[] vd0temp = new double[]{0.889500699418, 0.456933808921};
    static final double[] vd1temp = new double[]{-0.198411021088, 0.386241373662, 0.832668382346, 0.343677222149};
    static final double[] vd2temp = new double[]{0.0390630495665, -0.0760429831027, -0.143921176769, 0.456707890812, 0.807766275151, 0.33303120718};
    static final double[] vd3temp = new double[]{-2.76799784313E-4, 5.38838660959E-4, 0.0349752642807, -0.085504178774, -0.134969198046, 0.459895243878, 0.806892290508, 0.332670875027};
    static final double[] vg = ArrayMath.scalarMultiply(1.4142135623730951, vgtemp);
    static final double[] vd0 = ArrayMath.scalarMultiply(1.4142135623730951, ArrayMath.invert(vd0temp));
    static final double[] vd1 = ArrayMath.scalarMultiply(1.4142135623730951, ArrayMath.invert(vd1temp));
    static final double[] vd2 = ArrayMath.scalarMultiply(1.4142135623730951, ArrayMath.invert(vd2temp));
    static final double[] vd3 = ArrayMath.scalarMultiply(1.4142135623730951, ArrayMath.invert(vd3temp));
    static final double[] v0 = ArrayMath.scalarMultiply(1.4142135623730951, v0temp);
    static final double[] v1 = ArrayMath.scalarMultiply(1.4142135623730951, v1temp);
    static final double[] v2 = ArrayMath.scalarMultiply(1.4142135623730951, v2temp);
    static final double[] v3 = ArrayMath.scalarMultiply(1.4142135623730951, v3temp);
    static final double[] phvg = WaveletMath.lowToHigh(vgtemp);
    static final double[] phv0 = new double[]{0.720522830617, -0.685061028561, 0.0259917491699, -0.101939535681, 0.0200641216304, -0.00827216838973};
    static final double[] phv1 = new double[]{0.0639675079235, -0.0608192341872, 0.151405112504, 0.904072212264, -0.0510574707719, -0.18071490589, 0.315790060572, -0.130196008824};
    static final double[] phvd0temp = new double[]{-0.409742284317, 0.797634233593, -0.419058128916, -0.117669342504, 0.0741631890253, 0.0305764886814};
    static final double[] phvd0 = ArrayMath.invert(phvd0temp);
    static final double[] phvd1temp = new double[]{-0.00261427398522, 0.00508913652903, 0.330328738376, -0.807556085169, 0.460310974517, 0.13519444871, -0.0854338960798, -0.0352232501168};
    static final double[] phvd1 = ArrayMath.invert(phvd1temp);

    public int getFilterType() {
        return 4;
    }

    public MultiscaleFunction primaryScaling(int n, int n2) {
        return new Scaling3(n, n2);
    }

    public MultiscaleFunction dualScaling(int n, int n2) {
        return new Scaling3(n, n2);
    }

    public MultiscaleFunction primaryWavelet(int n, int n2) {
        return new Wavelet3(n, n2);
    }

    public MultiscaleFunction dualWavelet(int n, int n2) {
        return new Wavelet3(n, n2);
    }

    public int previousDimension(int n) {
        return Cascades.previousDimension(4, n);
    }

    public double[] lowpass(double[] dArray, double[] dArray2) {
        return this.lowpass(dArray);
    }

    public double[] highpass(double[] dArray, double[] dArray2) {
        return this.highpass(dArray);
    }

    public double[] lowpass(double[] dArray) {
        int n;
        int n2;
        if (dArray.length < 8) {
            throw new IllegalScalingException("The array is not long enough : " + dArray.length + " < " + 8);
        }
        double[] dArray2 = new double[2 * dArray.length - 4];
        int n3 = dArray.length - 1;
        for (n2 = 4; n2 <= n3 - 4; ++n2) {
            for (n = -3; n < 3; ++n) {
                int n4 = 2 * n2 + n - 1;
                dArray2[n4] = dArray2[n4] + vg[n + 3] * dArray[n2];
            }
        }
        dArray2 = ArrayMath.add(dArray2, dArray[0], v0, 0);
        dArray2 = ArrayMath.add(dArray2, dArray[1], v1, 0);
        dArray2 = ArrayMath.add(dArray2, dArray[2], v2, 0);
        dArray2 = ArrayMath.add(dArray2, dArray[3], v3, 0);
        n2 = dArray2.length - vd0.length;
        n = dArray2.length - vd1.length;
        int n5 = dArray2.length - vd2.length;
        int n6 = dArray2.length - vd3.length;
        dArray2 = ArrayMath.add(dArray2, dArray[n3], vd0, n2);
        dArray2 = ArrayMath.add(dArray2, dArray[n3 - 1], vd1, n);
        dArray2 = ArrayMath.add(dArray2, dArray[n3 - 2], vd2, n5);
        dArray2 = ArrayMath.add(dArray2, dArray[n3 - 3], vd3, n6);
        return dArray2;
    }

    public double[] highpass(double[] dArray) {
        int n;
        int n2;
        double[] dArray2 = new double[2 * dArray.length + 4];
        int n3 = dArray.length - 1;
        for (n2 = 2; n2 <= n3 - 2; ++n2) {
            for (n = -3; n < 3; ++n) {
                int n4 = 2 * n2 + n + 3;
                dArray2[n4] = dArray2[n4] + phvg[n + 3] * dArray[n2];
            }
        }
        dArray2 = ArrayMath.add(dArray2, dArray[0], phv0, 0);
        n2 = dArray2.length - phvd0.length;
        dArray2 = ArrayMath.add(dArray2, dArray[n3], phvd0, n2);
        dArray2 = ArrayMath.add(dArray2, dArray[1], phv1, 0);
        n = dArray2.length - phvd1.length;
        dArray2 = ArrayMath.add(dArray2, dArray[n3 - 1], phvd1, n);
        return dArray2;
    }

    public double[] evalScaling(int n, int n2, int n3) {
        return Cascades.evalScaling(this, n, n3, n2);
    }

    public double[] evalWavelet(int n, int n2, int n3) {
        return Cascades.evalWavelet(this, 4, n, n3, n2);
    }
}

