/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.particles;

import JSci.physics.particles.AntiLepton;
import JSci.physics.particles.AntiTauNeutrino;
import JSci.physics.particles.Photon;
import JSci.physics.particles.Tau;
import JSci.physics.particles.WMinus;
import JSci.physics.particles.WPlus;
import JSci.physics.particles.ZZero;
import JSci.physics.quantum.QuantumParticle;

public final class AntiTau
extends AntiLepton {
    public double restMass() {
        return 1777.03;
    }

    public int charge() {
        return 1;
    }

    public int eLeptonQN() {
        return 0;
    }

    public int muLeptonQN() {
        return 0;
    }

    public int tauLeptonQN() {
        return -1;
    }

    public QuantumParticle anti() {
        return new Tau();
    }

    public boolean isAnti(QuantumParticle quantumParticle) {
        return quantumParticle != null && quantumParticle instanceof Tau;
    }

    public String toString() {
        return new String("Antitau");
    }

    public AntiTau emit(Photon photon) {
        this.momentum = this.momentum.subtract(photon.momentum);
        return this;
    }

    public AntiTau absorb(Photon photon) {
        this.momentum = this.momentum.add(photon.momentum);
        return this;
    }

    public AntiTauNeutrino emit(WPlus wPlus) {
        AntiTauNeutrino antiTauNeutrino = new AntiTauNeutrino();
        antiTauNeutrino.momentum = this.momentum.subtract(wPlus.momentum);
        return antiTauNeutrino;
    }

    public AntiTauNeutrino absorb(WMinus wMinus) {
        AntiTauNeutrino antiTauNeutrino = new AntiTauNeutrino();
        antiTauNeutrino.momentum = this.momentum.add(wMinus.momentum);
        return antiTauNeutrino;
    }

    public AntiTau emit(ZZero zZero) {
        this.momentum = this.momentum.subtract(zZero.momentum);
        return this;
    }

    public AntiTau absorb(ZZero zZero) {
        this.momentum = this.momentum.add(zZero.momentum);
        return this;
    }
}

