/*
 * Decompiled with CFR 0.152.
 */
package conifer.data;

import conifer.Phylogeny;
import conifer.data.TaxonIndexedData;
import conifer.evol.EvolutionaryParameters;
import java.io.File;
import ma.MSAPoset;
import nuts.io.IO;
import pty.UnrootedTree;

public class PhylogeneticData {
    private Phylogeny phylogeny;
    private TaxonIndexedData observedTaxonIndexData;
    private MSAPoset msa;
    public EvolutionaryParameters generatingEvolutionaryOptions;

    public PhylogeneticData(Phylogeny phylogeny, TaxonIndexedData observedTaxonIndexData, MSAPoset msa, EvolutionaryParameters inferenceEvolutionaryOptions) {
        this.phylogeny = phylogeny;
        this.observedTaxonIndexData = observedTaxonIndexData;
        this.msa = msa;
        this.generatingEvolutionaryOptions = inferenceEvolutionaryOptions;
    }

    public PhylogeneticData(PhylogeneticData model) {
        this(model.phylogeny, model.getObservedTaxonIndexData(), model.msa, model.generatingEvolutionaryOptions);
    }

    public MSAPoset getMsa() {
        return this.msa;
    }

    public PhylogeneticData holdoutGeneratingParams() {
        PhylogeneticData data = new PhylogeneticData(this);
        if (data.generatingEvolutionaryOptions == null) {
            throw new RuntimeException();
        }
        data.generatingEvolutionaryOptions = null;
        return data;
    }

    public PhylogeneticData holdoutPhylogeny() {
        PhylogeneticData data = new PhylogeneticData(this);
        if (data.phylogeny == null) {
            throw new RuntimeException();
        }
        data.phylogeny = null;
        return data;
    }

    public PhylogeneticData holdoutMSA() {
        PhylogeneticData data = new PhylogeneticData(this);
        if (data.msa == null) {
            throw new RuntimeException();
        }
        data.msa = new MSAPoset(data.msa.sequences());
        return data;
    }

    public Phylogeny getPhylogeny() {
        return this.phylogeny;
    }

    public TaxonIndexedData getObservedTaxonIndexData() {
        return this.observedTaxonIndexData;
    }

    public void writeToDisk(File file) {
        if (!file.mkdir()) {
            return;
        }
        if (this.phylogeny != null) {
            UnrootedTree ut = this.phylogeny.getUnrooted();
            File phyloFile = new File(file, "tree.newick");
            IO.writeToDisk(phyloFile, ut.toNewick());
        }
        if (this.msa != null) {
            File msaFile = new File(file, "msa.fasta");
            this.msa.toFASTA(msaFile);
        }
        if (this.observedTaxonIndexData != null) {
            File observed = new File(file, "taxon-indexed-data");
            this.observedTaxonIndexData.writeToDisk(observed);
        }
    }

    public String toString() {
        return "Phylogeny:\n" + this.phylogeny + "\nMSA:\n" + this.msa;
    }
}

