/*
 * Decompiled with CFR 0.152.
 */
package conifer.ssm;

import conifer.ssm.Edit;
import conifer.ssm.StringMutationModel;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.OptionSet;
import fig.basic.Pair;
import fig.exec.Execution;
import fig.prob.SampleUtils;
import java.io.PrintWriter;
import java.util.List;
import java.util.Random;
import nuts.io.CSV;
import nuts.io.IO;
import nuts.math.Sampling;
import nuts.util.Counter;
import nuts.util.MathUtils;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class ForwardSimulator {
    public static Pair<Edit, Double> next(String current, StringMutationModel model, Random rand) {
        Pair<List<Edit>, double[]> rates = model.rates(current);
        double totalRate = MathUtils.normalizeAndGetNorm(rates.getSecond());
        double waitingTime = Sampling.sampleExponential(rand, 1.0 / totalRate);
        List<Edit> candidates = rates.getFirst();
        Edit sampledEdit = candidates.get(SampleUtils.sampleMultinomial(rand, rates.getSecond()));
        return Pair.makePair(sampledEdit, waitingTime);
    }

    public static String next(String current, StringMutationModel model, double branchLength, Random rand, List<Edit> edits) {
        Pair<Edit, Double> sample;
        double curLen = 0.0;
        while (curLen < branchLength && !((curLen += (sample = ForwardSimulator.next(current, model, rand)).getSecond().doubleValue()) > branchLength)) {
            if (edits != null) {
                edits.add(sample.getFirst());
            }
            current = sample.getFirst().newSeq;
        }
        return current;
    }

    public static String approxStationarySampling(StringMutationModel model, Random rand) {
        return ForwardSimulator.approxStationarySampling(model, rand, 1000);
    }

    public static String approxStationarySampling(StringMutationModel model, Random rand, int n) {
        String current = "";
        for (int i = 0; i < n; ++i) {
            Pair<Edit, Double> sampled = ForwardSimulator.next(current, model, rand);
            current = sampled.getFirst().newSeq;
        }
        return current;
    }

    public static String statistics(StringMutationModel model, Random rand, int nBurnIn, int nIterations, PrintWriter out) {
        StringBuilder output = new StringBuilder();
        output.append("MC Statistics for: " + model + "\n");
        output.append("nBurnIn=" + nBurnIn + ", nIterations=" + nIterations + "\n");
        String current = ForwardSimulator.approxStationarySampling(model, rand, nBurnIn);
        Counter<String> editTypeDistribution = new Counter<String>();
        SummaryStatistics length = new SummaryStatistics();
        SummaryStatistics waitingTimes = new SummaryStatistics();
        long generationTime = 0L;
        if (out != null) {
            out.println(CSV.header("iteration", "length", "operationType", "waitingTime", "string"));
        }
        for (int i = 0; i < nIterations; ++i) {
            long start = System.nanoTime();
            Pair<Edit, Double> sampled = ForwardSimulator.next(current, model, rand);
            generationTime += System.nanoTime() - start;
            current = sampled.getFirst().newSeq;
            editTypeDistribution.incrementCount("" + sampled.getFirst().getSummaryString(), 1.0);
            length.addValue((double)current.length());
            waitingTimes.addValue(sampled.getSecond().doubleValue());
            if (out == null) continue;
            out.println(CSV.body(i, current.length(), sampled.getFirst().getSummaryString(), sampled.getSecond(), current));
        }
        output.append("time(s)=" + (double)generationTime / 1.0E10 + "\n");
        editTypeDistribution.normalize();
        output.append("editTypeDistribution=" + editTypeDistribution + "\n");
        output.append("meanLength=" + ForwardSimulator.sumStat2String(length) + "\n");
        output.append("meanWaitingTimes=" + ForwardSimulator.sumStat2String(waitingTimes) + "\n");
        return output.toString();
    }

    public static String sumStat2String(SummaryStatistics stat) {
        return "" + stat.getMean() + " (" + stat.getStandardDeviation() + ")";
    }

    public static void main(String[] args) {
        IO.run(args, new ForwardMain());
    }

    public static class ForwardMain
    implements Runnable {
        @OptionSet(name="model")
        public StringMutationModel model = new StringMutationModel();
        @Option
        public Random rand = new Random(1L);
        @Option
        public int nBurnIn = 10000;
        @Option
        public int nIterations = 10000;
        @Option(gloss="Detailed output in state/execs/x.exec/details.csv")
        public boolean details = false;

        @Override
        public void run() {
            PrintWriter out = null;
            if (this.details) {
                out = IOUtils.openOutEasy(Execution.getFile("details.csv"));
            }
            LogInfo.logs(ForwardSimulator.statistics(this.model, this.rand, this.nBurnIn, this.nIterations, out));
            if (this.details) {
                out.close();
            }
        }
    }
}

