/*
 * Decompiled with CFR 0.152.
 */
package emc;

import conifer.apps.AbstractPhyloApp;
import conifer.apps.PhyloAppUtils;
import conifer.exp.Experiment;
import conifer.exp.TreeReconstructionExperiment;
import conifer.particle.PhyloParticle;
import emc.EMCNode;
import ev.poi.processors.TreeDistancesProcessor;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.UnorderedPair;
import goblin.Taxon;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Random;
import monaco.process.ProcessSchedule;
import monaco.process.ProcessScheduleContext;
import nuts.util.Counter;
import pty.smc.ParticleKernel;

public class TestEMC
extends AbstractPhyloApp
implements Runnable {
    @Option(required=true)
    public int K;
    @Option(required=true)
    public int M;
    @Option(required=true)
    public int max;
    @Option(required=true)
    public int nodeId;
    @Option(required=true)
    public int bootstrapPort;
    @Option(required=true)
    public String bootstrapIp;
    @Option(required=true)
    public Random seed1 = new Random(1L);
    @Option(required=true)
    public Random seed2 = new Random(1L);
    @Option
    public boolean transferExperiment = false;
    @Option
    public boolean dht = false;
    @Option
    public String datafile;
    private ParticleKernel<PhyloParticle> kernel;
    private TreeDistancesProcessor processor;

    @Override
    public void run() {
        LogInfo.logs("Running TestEMC");
        LogInfo.logs("Node ID=" + this.nodeId);
        LogInfo.logs("bootstrap IP=" + this.bootstrapIp);
        LogInfo.logs("bootstrap port=" + this.bootstrapPort);
        LogInfo.logs("transfer experiment=" + this.transferExperiment);
        LogInfo.logs("DHT=" + this.dht);
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            LogInfo.logs("localhost=" + localhost.getHostName());
        }
        catch (UnknownHostException e) {
            LogInfo.logs(e);
        }
        this.kernel = this.getKernel();
        this.processor = null;
        ProcessSchedule schedule = null;
        EMCNode<PhyloParticle> emcNode = new EMCNode<PhyloParticle>(this.nodeId, this.bootstrapIp, this.bootstrapPort, this.K, this.M, this.max, this.seed1.nextInt(), this.seed2.nextInt(), this.kernel, this.transferExperiment, this.processor, schedule);
        emcNode.launch();
    }

    @Override
    public void monitor(ProcessScheduleContext context) {
        int r = context.getGeneration();
        LogInfo.logs("generation=" + r);
        try {
            if (context.getGeneration() > this.allOptions.processOptions.burnIn) {
                List<Experiment> exps = this.getExperiments();
                TreeReconstructionExperiment exp = (TreeReconstructionExperiment)exps.get(0);
                Counter<UnorderedPair<Taxon, Taxon>> distances = this.processor.getMeanDistances();
                Object[] context2 = new Object[]{"generation", r};
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        PhyloAppUtils.run(args, new TestEMC());
    }
}

