/*
 * Decompiled with CFR 0.152.
 */
package ev.ex;

import ev.ex.PairAlign;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import goblin.CognateId;
import goblin.Taxon;
import java.io.ObjectInputStream;
import ma.BalibaseCorpus;
import ma.GreedyDecoder;
import ma.MSAPoset;
import nuts.io.IO;
import nuts.util.Counter;
import nuts.util.MathUtils;

public class SegmentationTest
implements Runnable {
    @Option(required=true)
    public String pathToSeri = null;

    public static void main(String[] args) {
        IO.run(args, new SegmentationTest(), "bali", PairAlign.options);
    }

    @Override
    public void run() {
        BalibaseCorpus bc = new BalibaseCorpus(PairAlign.options);
        for (CognateId id : bc.getMultiAlignments().keySet()) {
            MSAPoset gold = MSAPoset.fromMultiAlignmentObject(bc.getMultiAlignment(id));
            ObjectInputStream ois = IOUtils.openBinInHard(this.pathToSeri);
            try {
                Counter post = (Counter)ois.readObject();
                MSAPoset guess = MSAPoset.maxRecallMSA(gold.sequences(), post);
                for (MSAPoset.Column c : guess.columns()) {
                    if (c.getPoints().size() != gold.sequences().size()) continue;
                    double sum = 0.0;
                    double nNonZero = 0.0;
                    double error = 0.0;
                    for (int i = 0; i < guess.nTaxa(); ++i) {
                        for (int j = i + 1; j < guess.nTaxa(); ++j) {
                            Taxon t1 = guess.taxa().get(i);
                            Taxon t2 = guess.taxa().get(j);
                            GreedyDecoder.Edge e = new GreedyDecoder.Edge(c.getPoints().get(t1), c.getPoints().get(t2), t1, t2);
                            sum += post.getCount(e);
                            if (post.getCount(e) > 0.0) {
                                nNonZero += 1.0;
                            }
                            if (gold.containsEdge(e)) continue;
                            error += 1.0;
                        }
                    }
                    LogInfo.logsForce("" + sum / nNonZero + "\t" + error / (double)MathUtils.nChoose2(guess.nTaxa()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

