/*
 * Decompiled with CFR 0.152.
 */
package ev.io;

import fig.basic.LogInfo;
import fig.basic.Option;
import goblin.Taxon;
import java.io.File;
import nuts.io.IO;
import pty.UnrootedTree;

public class CheckDistance
implements Runnable {
    @Option
    public String treeFile = "/Users/bouchard/Documents/data/utcs/16S.B.ALL.raxml.nwk";
    @Option(required=true)
    public String taxon;

    @Override
    public void run() {
        LogInfo.track("Loading data");
        UnrootedTree t = UnrootedTree.fromNewick(new File(this.treeFile));
        LogInfo.logs("Read tree with " + t.leaves().size() + " leaves");
        Taxon ref = new Taxon(this.taxon);
        LogInfo.end_track();
        LogInfo.track("distances relative to " + this.taxon);
        for (Taxon other : t.leaves()) {
            LogInfo.logsForce("" + other + "\t" + t.totalBranchLengthDistance(ref, other));
        }
        LogInfo.end_track();
    }

    public static void main(String[] args) {
        IO.run(args, new CheckDistance());
    }
}

