/*
 * Decompiled with CFR 0.152.
 */
package ev.to;

import java.util.List;
import java.util.regex.Pattern;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.util.Counter;

public class GCContents {
    public static Pattern p = Pattern.compile("([^\\s]*)\\s([0-9]*[.]0)");

    public static void main(String[] args) {
        if (args[0].contains("sample")) {
            GCContents.parseFromSamples(args);
        } else {
            GCContents.parseFromRecon(args);
        }
    }

    private static void parseFromRecon(String[] args) {
        Counter<Character> cur = new Counter<Character>();
        Pattern p = Pattern.compile(args[1] + " (.*)");
        for (String line : IO.i(args[0])) {
            String match;
            if (!p.matcher(line).matches() || (match = StringUtils.selectFirstRegex(p, line)) == null) continue;
            for (char c : match.toCharArray()) {
                cur.incrementCount(Character.valueOf(c), 1.0);
            }
        }
        cur.normalize();
        System.out.println(cur);
    }

    public static void parseFromSamples(String[] args) {
        Counter<Character> cur = new Counter<Character>();
        Counter tot = new Counter();
        for (String line : IO.i(args[0])) {
            if (line.equals("----")) {
                cur.normalize();
                tot.incrementAll(cur);
                cur = new Counter();
                continue;
            }
            if (!p.matcher(line).matches()) continue;
            List<String> ms = StringUtils.multiSelectFirstRegex(p, line);
            String s = ms.get(0);
            double mult = Double.parseDouble(ms.get(1));
            GCContents.process(s, mult, cur);
        }
        cur.normalize();
        tot.incrementAll(cur);
        tot.normalize();
        System.out.println(tot);
    }

    private static void process(String s, double mult, Counter<Character> cur) {
        if (s != null) {
            for (char c : s.toCharArray()) {
                cur.incrementCount(Character.valueOf(c), mult);
            }
        }
    }
}

