/*
 * Decompiled with CFR 0.152.
 */
package fenchel.tests.utils;

import fenchel.factor.UnaryFactor;
import fenchel.factor.multisites.MSUnaryFactor;
import fig.basic.NumUtils;
import java.util.List;

public class NaiveUnary
implements MSUnaryFactor {
    public final double[] values;

    public NaiveUnary(double[] values) {
        this.values = values;
    }

    @Override
    public int nStates() {
        return this.values.length;
    }

    @Override
    public UnaryFactor multiply(List<UnaryFactor> otherFactors) {
        if (otherFactors.size() == 0) {
            return this;
        }
        int size = ((NaiveUnary)otherFactors.get((int)0)).values.length;
        NaiveUnary result = new NaiveUnary(new double[size]);
        for (int i = 0; i < size; ++i) {
            double prod = this.values[i];
            for (UnaryFactor other : otherFactors) {
                prod *= ((NaiveUnary)other).values[i];
            }
            result.values[i] = prod;
        }
        return result;
    }

    @Override
    public double logNorm() {
        double sum = 0.0;
        int nStates = this.nStates();
        for (int i = 0; i < nStates; ++i) {
            sum += this.values[i];
        }
        return Math.log(sum);
    }

    @Override
    public double[][] normalizedValues() {
        double[][] result = new double[1][this.values.length];
        result[0] = (double[])this.values.clone();
        NumUtils.normalize(result[0]);
        return result;
    }

    @Override
    public int nSites() {
        return 1;
    }

    @Override
    public double[][] values() {
        double[][] result = new double[1][this.values.length];
        result[0] = this.values;
        return result;
    }
}

