/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import java.io.File;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassInitializer {
    public static void setVerbose(int verbose) {
        StandardLog.verbose = verbose;
    }

    private ClassInitializer() {
    }

    public static void initializeAll() {
        ClassInitializer.initializeRuntime();
        ClassInitializer.initializeClassPath();
    }

    public static void initializeRuntime() {
        String bootPath = System.getProperty("sun.boot.class.path");
        String pathSeparator = System.getProperty("path.separator");
        if (bootPath == null || pathSeparator == null) {
            StandardLog.warning("Cannot initialize boot path through system properties");
            return;
        }
        ClassInitializer.initialize(bootPath, pathSeparator);
        String javaHome = System.getProperty("java.home");
        String fileSeparator = System.getProperty("file.separator");
        if (javaHome == null || fileSeparator == null) {
            StandardLog.warning("Cannot initialize extension library through system properties");
            return;
        }
        File extDir = new File(javaHome + fileSeparator + "lib" + fileSeparator + "ext");
        if (!extDir.getClass().getName().equals("java.io.File")) {
            StandardLog.warning("Extension classes initialization not supported for J2ME build");
            return;
        }
        if (extDir.isDirectory()) {
            File[] files = extDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String path = files[i].getPath();
                if (!path.endsWith(".jar") && !path.endsWith(".zip")) continue;
                ClassInitializer.initializeJar(path);
            }
        } else {
            StandardLog.warning(extDir + " is not a directory");
        }
    }

    public static void initializeClassPath() {
        String classPath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        if (classPath == null || pathSeparator == null) {
            StandardLog.warning("Cannot initialize classpath through system properties");
            return;
        }
        ClassInitializer.initialize(classPath, pathSeparator);
    }

    private static void initialize(String classPath, String pathSeparator) {
        StandardLog.fine("Initialize classpath: " + classPath);
        while (classPath.length() > 0) {
            String name;
            int index = classPath.indexOf(pathSeparator);
            if (index < 0) {
                name = classPath;
                classPath = "";
            } else {
                name = classPath.substring(0, index);
                classPath = classPath.substring(index + pathSeparator.length());
            }
            if (name.endsWith(".jar") || name.endsWith(".zip")) {
                ClassInitializer.initializeJar(name);
                continue;
            }
            ClassInitializer.initializeDir(name);
        }
    }

    public static void initialize(Class cls) {
        Reflection.getClass(cls.getName());
    }

    public static void initializeJar(String jarName) {
        try {
            StandardLog.fine("Initialize Jar file: " + jarName);
            ZipFile jarFile = new ZipFile(jarName);
            if (!jarFile.getClass().getName().equals("java.util.zip.ZipFile")) {
                StandardLog.warning("Initialization of classes in jar file not supported for J2ME build");
                return;
            }
            Enumeration<? extends ZipEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class")) continue;
                String className = entryName.substring(0, entryName.length() - 6);
                Class cls = Reflection.getClass(className = className.replace('/', '.'));
                if (cls == null) continue;
                StandardLog.finer(className + " initialized");
            }
        }
        catch (Exception e) {
            StandardLog.error(e);
        }
    }

    public static void initializeDir(String dirName) {
        StandardLog.fine("Initialize Directory: " + dirName);
        File file = new File(dirName);
        if (!file.getClass().getName().equals("java.io.File")) {
            StandardLog.warning("Initialization of classes in directory not supported for J2ME build");
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                ClassInitializer.initialize("", files[i]);
            }
        } else {
            StandardLog.warning(dirName + " is not a directory");
        }
    }

    private static void initialize(String prefix, File file) {
        String className;
        Class cls;
        String name = file.getName();
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            String newPrefix = prefix.length() == 0 ? name : prefix + "." + name;
            for (int i = 0; i < files.length; ++i) {
                ClassInitializer.initialize(newPrefix, files[i]);
            }
        } else if (name.endsWith(".class") && (cls = Reflection.getClass(className = prefix + "." + name.substring(0, name.length() - 6))) != null) {
            StandardLog.finer(className + " initialized");
        }
    }

    static class Reflection {
        static ClassLoader loader = ClassLoader.getSystemClassLoader();

        Reflection() {
        }

        public static Class getClass(String name) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }

    static class StandardLog {
        public static int verbose = 0;

        StandardLog() {
        }

        public static void warning(Object o) {
            System.err.println(o);
        }

        public static void error(Object o) {
            System.err.println(o);
        }

        public static void fine(Object o) {
            if (verbose >= 1) {
                System.err.println(o);
            }
        }

        public static void finer(Object o) {
            if (verbose >= 2) {
                System.err.println(o);
            }
        }
    }
}

