/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.Exceptions;
import fig.basic.Ref;
import fig.exec.Execution;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class Parallelizer<T> {
    int numThreads;
    private Thread primaryThread;

    public Parallelizer(int numThreads) {
        this.numThreads = numThreads;
    }

    public void process(final List<T> points, final Processor<T> processor) {
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);
        final Ref<Object> exception = new Ref<Object>(null);
        this.primaryThread = null;
        for (int i = 0; i < points.size(); ++i) {
            final int I = i;
            final T x = points.get(i);
            if (this.numThreads == 1) {
                if (Execution.shouldBail()) {
                    return;
                }
                try {
                    if (exception.value != null) continue;
                    this.setPrimaryThread();
                    processor.process(x, I, points.size(), this.isPrimary());
                }
                catch (Throwable t) {
                    exception.value = t;
                }
                continue;
            }
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (Execution.shouldBail()) {
                        return;
                    }
                    try {
                        if (exception.value == null) {
                            Parallelizer.this.setPrimaryThread();
                            processor.process(x, I, points.size(), Parallelizer.this.isPrimary());
                        }
                    }
                    catch (Throwable t) {
                        exception.value = t;
                    }
                }
            });
        }
        executor.shutdown();
        try {
            while (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
            }
        }
        catch (InterruptedException e) {
            throw Exceptions.bad("Interrupted");
        }
        if (exception.value != null) {
            throw new RuntimeException((Throwable)exception.value);
        }
    }

    public synchronized void setPrimaryThread() {
        if (this.primaryThread == null) {
            this.primaryThread = Thread.currentThread();
        }
    }

    public synchronized boolean isPrimary() {
        return Thread.currentThread() == this.primaryThread;
    }

    public static interface Processor<T> {
        public void process(T var1, int var2, int var3, boolean var4);
    }
}

