/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.MapUtils;
import fig.basic.OrderedStringMap;
import fig.basic.StopWatch;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class StopWatchSet {
    private static Map<String, StopWatch> stopWatches = new LinkedHashMap<String, StopWatch>();
    private static LinkedList<StopWatch> lastStopWatches = new LinkedList();

    public static StopWatch getWatch(String s) {
        return MapUtils.getMut(stopWatches, s, new StopWatch());
    }

    public static synchronized void begin(String s) {
        lastStopWatches.addLast(StopWatchSet.getWatch(s).start());
    }

    public static synchronized void end() {
        lastStopWatches.removeLast().accumStop();
    }

    public static OrderedStringMap getStats() {
        OrderedStringMap map = new OrderedStringMap();
        for (String key : stopWatches.keySet()) {
            StopWatch watch = StopWatchSet.getWatch(key);
            map.put(key, watch + " (" + new StopWatch(watch.n == 0 ? 0L : watch.ms / (long)watch.n) + " x " + watch.n + ")");
        }
        return map;
    }
}

