/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.IOUtils;
import fig.exec.servlet.Basket;
import fig.exec.servlet.DirSource;
import fig.exec.servlet.DomainView;
import fig.exec.servlet.FileItem;
import fig.exec.servlet.FileView;
import fig.exec.servlet.MyException;
import fig.exec.servlet.Source;
import java.io.File;

public class FileSource
extends Source {
    protected final DomainView domainView;
    protected final File path;

    public FileSource(DomainView domainView, File path) {
        this.domainView = domainView;
        this.path = path;
    }

    public FileSource(DomainView domainView, String path) {
        this(domainView, new File(path));
    }

    public FileSource(DirSource parent, String name) {
        this.domainView = parent.domainView;
        this.path = new File(parent.path, name);
    }

    public DomainView getDomainView() {
        return this.domainView;
    }

    public FileView getFileView() {
        return this.domainView.getFileViewDB().getRootFileView();
    }

    public FileView getFileView(String dirPath) throws MyException {
        return this.domainView.getFileViewDB().getItem(dirPath);
    }

    public Basket getBasket(String name) throws MyException {
        return (Basket)this.domainView.getBasketDB().getItem(name);
    }

    public FileItem getFileItem(File path) throws MyException {
        return (FileItem)this.domainView.getFileViewDB().getRootFileView().getItem(path.toString());
    }

    public FileItem getFileItem() throws MyException {
        return this.getFileItem(this.getPath());
    }

    public File getPath() {
        return this.path;
    }

    public String getParent() {
        return this.path.getParent();
    }

    public String getName() {
        return this.path.getName();
    }

    public String getExt() {
        return IOUtils.getFileExt(this.path.getName());
    }
}

