/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.exec.servlet.ExecFactory;
import fig.exec.servlet.ExecItem;
import fig.exec.servlet.ExecView;
import fig.exec.servlet.Field;
import fig.exec.servlet.FileSource;
import fig.exec.servlet.MapFileField;
import fig.exec.servlet.MyException;
import fig.exec.servlet.Trail;
import fig.exec.servlet.UpdateQueue;
import fig.exec.servlet.UpdateSpec;
import java.io.File;

public class GroundedExecView
extends ExecView {
    private boolean hasUpdated = false;

    public boolean hasUpdated() {
        return this.hasUpdated;
    }

    public GroundedExecView(Trail trail, FileSource source, ExecFactory factory) {
        super(trail, source, factory);
    }

    @Override
    public Field getField(String key, String gloss) {
        if (key.equals("description") || key.equals("note")) {
            MapFileField field = new MapFileField(key, gloss, "", key, this.source.getFileView());
            field.mutable = true;
            if (key.equals("note")) {
                field.multiline = true;
            }
            return field;
        }
        return super.getField(key, gloss);
    }

    @Override
    protected String itemToSpec(ExecItem item) {
        if (item.isDivider()) {
            return item.getDividerName();
        }
        return item.getTrail().getName();
    }

    @Override
    protected ExecItem specToItem(String itemName) throws MyException {
        return (ExecItem)this.source.getDomainView().getExecViewDB().getAllExecView().getItem(itemName);
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        this.updateItemsFromFile(spec, this.source);
        this.updateChildren(spec, priority);
        this.hasUpdated = true;
    }

    @Override
    protected File getGroundedIndexPath() {
        return this.source.getPath();
    }
}

