/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.IntRef;
import fig.basic.ListUtils;
import fig.basic.StrUtils;
import fig.record.AbstractRecordNode;
import fig.record.AllMatcher;
import fig.record.CombineCommandNode;
import fig.record.CommandEnv;
import fig.record.CommandNode;
import fig.record.ExactMatcher;
import fig.record.FilterCommandNode;
import fig.record.FuncCommandNode;
import fig.record.GlobalEnv;
import fig.record.Matcher;
import fig.record.NumMatcher;
import fig.record.OrMatcher;
import fig.record.RecordNode;
import fig.record.RecordNodeMatcher;
import fig.record.RegexMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class CommandUtils {
    public static CommandNode parse(String line, CommandEnv cmdEnv) {
        line = CommandUtils.substituteMacro(line, cmdEnv.getGlobalEnv());
        if ((line = line.replaceAll("\\s+", " ").trim()).equals("")) {
            return FuncCommandNode.noOpCmd;
        }
        CommandNode cmd = CommandUtils.parseDefineMacro(line);
        if (cmd != null) {
            return cmd;
        }
        cmd = CommandUtils.parseRecordCommand(line);
        if (cmd != null) {
            return cmd;
        }
        throw new RuntimeException("Can't parse: " + line);
    }

    private static List<String> parseCall(String[] prefixes, String s, IntRef iRef) {
        int j;
        int i = iRef == null ? 0 : iRef.value;
        ArrayList<String> args = new ArrayList<String>();
        for (String prefix : prefixes) {
            if (!s.substring(i).startsWith(prefix)) continue;
            args.add(prefix);
            i += prefix.length();
            break;
        }
        if (args.size() == 0) {
            return null;
        }
        for (j = i; j < s.length() && Character.isLetterOrDigit(s.charAt(j)); ++j) {
        }
        if (i == j) {
            return null;
        }
        args.add(s.substring(i, j));
        i = j;
        int indent = 1;
        if (i < s.length() && s.charAt(i) == '(') {
            j = i;
            do {
                if ((j = StrUtils.indexOfIgnoreEscaped(s, "()", j + 1)) == -1) {
                    return null;
                }
                if (s.charAt(j) == '(') {
                    ++indent;
                    continue;
                }
                --indent;
            } while (indent > 0);
            args.addAll(StrUtils.splitIgnoreEscaped(s.substring(i + 1, j), ","));
            i = j + 1;
        }
        if (iRef != null) {
            iRef.value = i;
        }
        return args;
    }

    private static String substituteMacro(String line, GlobalEnv globalEnv) {
        for (int t = 0; t < 10; ++t) {
            String newLine = CommandUtils.substituteMacroOnePass(line, globalEnv);
            if (newLine.equals(line)) {
                return line;
            }
            line = newLine;
        }
        return line;
    }

    private static String substituteMacroOnePass(String line, GlobalEnv globalEnv) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < line.length()) {
            IntRef iRef = new IntRef(i);
            List<String> args = CommandUtils.parseCall(new String[]{"$"}, line, iRef);
            if (args != null) {
                String var = args.get(1);
                String val = globalEnv.getVar(var);
                if (val == null) {
                    throw new RuntimeException("Variable undefined: " + var);
                }
                val = CommandUtils.expandMacro(val, args.subList(2, args.size()));
                sb.append(val);
                i = iRef.value;
                continue;
            }
            sb.append(line.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    private static String expandMacro(String s, List<String> args) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (true) {
            int j;
            if ((j = s.indexOf(92, i)) == -1) {
                j = s.length();
            }
            buf.append(s.substring(i, j));
            if (j == s.length()) break;
            i = j++;
            while (j < s.length() && Character.isDigit(s.charAt(j))) {
                ++j;
            }
            if (i + 1 < j) {
                int argIndex = Integer.parseInt(s.substring(i + 1, j)) - 1;
                if (argIndex < args.size()) {
                    buf.append(args.get(argIndex));
                }
            } else {
                buf.append(s.substring(i, j));
            }
            i = j;
        }
        return buf.toString();
    }

    private static boolean isEndOfChain(String s) {
        return s.equals("}") || s.equals("/");
    }

    public static CommandNode parseRecordCommand(String line) {
        CombineCommandNode rootCmd;
        List<String> tokens = StrUtils.splitIgnoreEscaped(line, " ");
        CommandNode parentCmd = rootCmd = new CombineCommandNode(CombineCommandNode.CombineType.COMPOSE);
        ArrayList<CommandNode> pivotCmds = ListUtils.newList(rootCmd);
        String lastLabel = null;
        CommandNode leafCmd = FuncCommandNode.identityCmd;
        for (int k = 0; k < tokens.size(); ++k) {
            boolean labelSpecified;
            String s = tokens.get(k);
            CommandNode cmd = null;
            boolean isEndOfChain = k + 1 == tokens.size() || CommandUtils.isEndOfChain(tokens.get(k + 1));
            boolean flatten = false;
            java.util.regex.Matcher m = StrUtils.match("(.)?\\{", s);
            if (m.matches()) {
                CombineCommandNode.CombineType type = CombineCommandNode.parseCombineType(m.groupCount() >= 1 ? m.group(1) : null);
                cmd = new CombineCommandNode(type);
                pivotCmds.add(cmd);
            } else {
                if (s.equals("/")) {
                    parentCmd = ListUtils.getLast(pivotCmds);
                    continue;
                }
                if (s.equals("}")) {
                    parentCmd = ListUtils.removeLast(pivotCmds);
                    continue;
                }
                if (s.equals("?")) {
                    cmd = FuncCommandNode.childKeysCmd;
                } else if (s.equals("..")) {
                    cmd = FuncCommandNode.keySkeletonCmd;
                } else if (s.equals("...")) {
                    cmd = FuncCommandNode.identityCmd;
                } else {
                    List<String> args = CommandUtils.parseCall(new String[]{"!!", "!"}, s, null);
                    if (args != null) {
                        boolean applyToChildren = args.get(0).length() > 1;
                        for (int i = 2; i < args.size(); ++i) {
                            args.set(i, args.get(i));
                        }
                        cmd = new FuncCommandNode(args.get(1), args.subList(2, args.size()), leafCmd, applyToChildren);
                    } else {
                        Matcher valueMatcher;
                        Matcher keyMatcher;
                        m = StrUtils.match("'(.*)'", s);
                        if (m.matches()) {
                            lastLabel = m.group(1);
                            continue;
                        }
                        m = StrUtils.match("([^=<>]+)(<=|>=|<|>|==)(.+)", s);
                        if (m.matches()) {
                            keyMatcher = CommandUtils.getMatcher(m.group(1));
                            valueMatcher = new NumMatcher(m.group(2), m.group(3));
                        } else {
                            m = StrUtils.match("([^=]+)=(.+)", s);
                            if (m.matches()) {
                                keyMatcher = CommandUtils.getMatcher(m.group(1));
                                valueMatcher = CommandUtils.getMatcher(m.group(2));
                            } else {
                                m = StrUtils.match("=(.+)", s);
                                if (m.matches()) {
                                    keyMatcher = AllMatcher.matcher;
                                    valueMatcher = CommandUtils.getMatcher(m.group(1));
                                } else {
                                    m = StrUtils.match("(.+)", s);
                                    if (m.matches()) {
                                        keyMatcher = CommandUtils.getMatcher(s);
                                        valueMatcher = AllMatcher.matcher;
                                    } else {
                                        throw new RuntimeException("Bad filter string: " + s);
                                    }
                                }
                            }
                        }
                        cmd = new FilterCommandNode(new RecordNodeMatcher(keyMatcher, valueMatcher), isEndOfChain ? FuncCommandNode.withoutChildrenCmd : leafCmd);
                        flatten = true;
                    }
                }
            }
            boolean bl = labelSpecified = lastLabel != null;
            if (labelSpecified) {
                flatten = false;
            }
            ArrayList<AbstractRecordNode> cmds = new ArrayList<AbstractRecordNode>();
            cmds.add((AbstractRecordNode)((Object)cmd));
            if (!StrUtils.isEmpty(lastLabel)) {
                cmds.add(new FuncCommandNode("key", Collections.singletonList(lastLabel), (CommandNode)ListUtils.getLast(cmds), true));
            }
            if (flatten) {
                cmds.add(new FuncCommandNode("flatten", labelSpecified ? Collections.singletonList("append") : Collections.EMPTY_LIST, (CommandNode)ListUtils.getLast(cmds), false));
            }
            if (parentCmd != null) {
                cmds.add((AbstractRecordNode)((Object)parentCmd));
            }
            for (int i = 1; i < cmds.size(); ++i) {
                if (FuncCommandNode.isImmutableCmd((CommandNode)cmds.get(i))) {
                    throw new RuntimeException("Can't add children to " + cmds.get(i));
                }
                ((CommandNode)cmds.get(i)).addChild((RecordNode)cmds.get(i - 1));
            }
            parentCmd = (CommandNode)cmds.get(0);
            lastLabel = null;
        }
        return CommandUtils.removeFinalFlatten(rootCmd);
    }

    private static CommandNode removeFinalFlatten(CommandNode cmd) {
        if (cmd instanceof FuncCommandNode && ((FuncCommandNode)cmd).getName().equals("flatten") && CommandUtils.numDescendentFilterNodes(cmd, new IntRef(0)) == 1) {
            return (CommandNode)((FuncCommandNode)cmd).getChild();
        }
        CommandNode newCmd = (CommandNode)cmd.withoutChildren();
        for (RecordNode childCmd : cmd.getChildren()) {
            newCmd.addChild(CommandUtils.removeFinalFlatten((CommandNode)childCmd));
        }
        return newCmd;
    }

    private static int numDescendentFilterNodes(CommandNode cmd, IntRef count) {
        if (cmd != null) {
            if (cmd instanceof FilterCommandNode) {
                ++count.value;
            }
            for (RecordNode childCmd : cmd.getChildren()) {
                CommandUtils.numDescendentFilterNodes((CommandNode)childCmd, count);
            }
        }
        return count.value;
    }

    private static Matcher getMatcher(String s) {
        if (s.equals("*")) {
            return AllMatcher.matcher;
        }
        java.util.regex.Matcher m = Pattern.compile("/([^,]+)/").matcher(s);
        if (m.matches()) {
            return new RegexMatcher(m.group(1));
        }
        m = Pattern.compile("\\{([^}]*)\\}").matcher(s);
        if (m.matches()) {
            OrMatcher matcher = new OrMatcher();
            for (String t : StrUtils.splitIgnoreEscaped(m.group(1), ",")) {
                matcher.addMatcher(CommandUtils.getMatcher(t));
            }
            return matcher;
        }
        return new ExactMatcher(s);
    }

    public static CommandNode parseDefineMacro(String line) {
        Pattern p = Pattern.compile("(\\w+)\\s*:=\\s*(.*)");
        java.util.regex.Matcher m = p.matcher(line);
        if (!m.matches()) {
            return null;
        }
        return new FuncCommandNode("define", ListUtils.newList(m.group(1), m.group(2)), FuncCommandNode.identityCmd, false);
    }
}

