/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.IOUtils;
import fig.basic.StrUtils;
import fig.basic.Utils;
import fig.servlet.BasketFactory;
import fig.servlet.BasketView;
import fig.servlet.ExecViewDB;
import fig.servlet.FieldListMap;
import fig.servlet.FieldSpecView;
import fig.servlet.Item;
import fig.servlet.MyException;
import fig.servlet.MyExceptions;
import fig.servlet.UpdateQueue;
import fig.servlet.UpdateSpec;
import fig.servlet.WebState;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class DomainItem
extends Item {
    public BasketView basketView;
    public FieldSpecView fieldSpecView;
    public ExecViewDB execViewDB;
    private BasketFactory basketFactory;
    private String domainDir;
    private String basketFactoryClassName;
    private String classpath;
    private ClassLoader classLoader;

    public DomainItem(Item parent, String name, String sourcePath) {
        super(parent, name, sourcePath);
        IOUtils.createNewFileIfNotExistsEasy(sourcePath);
    }

    @Override
    protected boolean isHidden() {
        return Boolean.parseBoolean((String)this.metadataMap.get("isHidden"));
    }

    @Override
    public FieldListMap getItemsFields() {
        return countDescriptionFields;
    }

    @Override
    protected void loadFromDisk() throws MyException {
        String newDomainDir;
        super.loadFromDisk();
        boolean classpathChanged = false;
        String newClasspath = (String)this.metadataMap.get("classpath");
        if (!Utils.equals(newClasspath, this.classpath)) {
            classpathChanged = true;
            this.classpath = newClasspath;
            WebState.logs("New classpath: " + this.classpath);
            if (!StrUtils.isEmpty(this.classpath)) {
                try {
                    ArrayList<URL> urls = new ArrayList<URL>();
                    for (String path : StrUtils.split(this.classpath, ":")) {
                        urls.add(new File(path).toURL());
                    }
                    this.classLoader = new URLClassLoader(urls.toArray(new URL[0]), this.getClass().getClassLoader());
                }
                catch (Throwable e) {
                    WebState.logs("Error loading classpath: " + e);
                    this.classLoader = null;
                }
            } else {
                this.classLoader = null;
            }
            this.basketView = null;
        }
        String newBasketFactoryClassName = (String)this.metadataMap.get("basketFactory");
        if (classpathChanged || !Utils.equals(newBasketFactoryClassName, this.basketFactoryClassName)) {
            block20: {
                this.basketFactoryClassName = newBasketFactoryClassName;
                WebState.logs("New basketFactory: " + this.basketFactoryClassName);
                if (!StrUtils.isEmpty(this.basketFactoryClassName)) {
                    try {
                        if (this.classLoader != null) {
                            Class<?> cls = this.classLoader.loadClass(this.basketFactoryClassName);
                            this.basketFactory = (BasketFactory)cls.newInstance();
                            break block20;
                        }
                        this.basketFactory = (BasketFactory)Class.forName(this.basketFactoryClassName).newInstance();
                    }
                    catch (Throwable e) {
                        WebState.logs("Error dynamically creating class: " + e);
                        this.basketFactory = BasketView.defaultBasketFactory;
                    }
                } else {
                    this.basketFactory = BasketView.defaultBasketFactory;
                }
            }
            this.basketView = null;
        }
        if (!Utils.equals(newDomainDir = (String)this.metadataMap.get("domainDir"), this.domainDir) && newDomainDir != null && new File(newDomainDir).isDirectory()) {
            this.domainDir = newDomainDir;
            WebState.logs("New domainDir: " + this.domainDir);
            this.basketView = null;
            this.fieldSpecView = null;
            this.execViewDB = null;
        }
        if (!StrUtils.isEmpty(this.domainDir)) {
            if (this.basketView == null) {
                this.basketView = new BasketView(this, "baskets", new File(this.domainDir, "baskets").toString(), this.basketFactory, false);
            }
            if (this.fieldSpecView == null) {
                this.fieldSpecView = new FieldSpecView(this, "fieldSpecs", new File(this.domainDir, "fieldSpecs").toString());
            }
            if (this.execViewDB == null) {
                this.execViewDB = new ExecViewDB(this, "execs", new File(this.domainDir, "execs").toString(), new File(this.domainDir, "views").toString());
            }
        }
        if (this.basketView != null) {
            this.addItem(this.basketView);
        }
        if (this.fieldSpecView != null) {
            this.addItem(this.fieldSpecView);
        }
        if (this.execViewDB != null) {
            this.addItem(this.execViewDB);
        }
    }

    @Override
    public FieldListMap getMetadataFields() {
        FieldListMap fields = new FieldListMap();
        fields.add(mutableDescriptionField);
        fields.add((String)"domainDir", (String)"Domain directory").mutable = true;
        fields.add((String)"basketFactory", (String)"Class name of the basket factory (e.g., for visualization)").mutable = true;
        fields.add((String)"classpath", (String)"Classpath used to dynamically load the needed classes").mutable = true;
        return fields;
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        super.update(spec, priority);
        if (this.fieldSpecView != null) {
            spec.queue.enqueue(this.fieldSpecView, priority);
        }
        this.updateChildren(spec, priority.next());
    }

    @Override
    protected Item handleToItem(String handle) throws MyException {
        return null;
    }

    @Override
    protected String itemToHandle(Item item) throws MyException {
        return null;
    }

    @Override
    protected boolean isView() {
        return true;
    }

    @Override
    protected Item newItem(String name) throws MyException {
        throw MyExceptions.unsupported;
    }
}

