/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import goblin.BayesRiskMinimizer;
import goblin.CognateId;
import goblin.CognateSet;
import goblin.DataLoader;
import goblin.DataLoaderInterface;
import goblin.DerivationTree;
import goblin.ObservationsTracker;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import nuts.util.Arbre;
import nuts.util.Counter;
import nuts.util.Tree;

public abstract class Baseline {
    protected Map<CognateId, String> result = null;

    public Map<CognateId, String> baseline(DataLoaderInterface dataLoader) {
        return this.baseline(dataLoader.getCognateSet(), dataLoader.getHeldout());
    }

    public Map<CognateId, String> baseline(CognateSet cs, Collection<DataLoader.HeldoutEntry> heldout) {
        if (this.result != null) {
            return this.result;
        }
        this.result = new HashMap<CognateId, String>();
        for (DataLoader.HeldoutEntry entry : heldout) {
            Arbre<DerivationTree.DerivationNode> tree = cs.getTree(entry.id);
            ObservationsTracker obs = cs.getObs(entry.id);
            HashMap<Taxon, String> words = new HashMap<Taxon, String>();
            for (Taxon lang : obs.observedLanguages()) {
                words.put(lang, DerivationTree.findNodeByLangName(tree, lang).getContents().getWord());
            }
            this.result.put(entry.id, this.baseline(words, entry.trueReconstruction));
        }
        return this.result;
    }

    public abstract String baseline(Map<Taxon, String> var1, String var2);

    public static <T> Tree<T> findNode(Tree<T> root, T target) {
        for (Tree<T> node : root.getPreOrderTraversal()) {
            if (!node.getLabel().equals(target)) continue;
            return node;
        }
        throw new RuntimeException("Node not found:" + target);
    }

    public static class RandomBaseline
    extends Baseline {
        private final Random randomBaselineRand;

        public RandomBaseline(Random randomBaselineRand) {
            this.randomBaselineRand = randomBaselineRand;
        }

        @Override
        public String baseline(Map<Taxon, String> words, String truth) {
            ArrayList<String> wordList = new ArrayList<String>();
            for (Taxon lang : words.keySet()) {
                wordList.add(words.get(lang));
            }
            return (String)wordList.get(this.randomBaselineRand.nextInt(words.size()));
        }
    }

    public static class OracleLanguageBaseline
    extends Baseline {
        @Override
        public String baseline(Map<Taxon, String> words, String truth) {
            throw new RuntimeException();
        }
    }

    public static class OracleBaseline
    extends Baseline {
        private final BayesRiskMinimizer.LossFct<String> loss;
        private final Counter<Taxon> bestPredictiveLanguages = new Counter();

        public OracleBaseline(BayesRiskMinimizer.LossFct<String> loss) {
            this.loss = loss;
        }

        @Override
        public String baseline(Map<Taxon, String> words, String truth) {
            String result = null;
            double min = Double.POSITIVE_INFINITY;
            Taxon bestLang = null;
            for (Taxon lang : words.keySet()) {
                String word = words.get(lang);
                double cLoss = this.loss.loss(word, truth);
                if (!(cLoss < min)) continue;
                result = word;
                min = cLoss;
                bestLang = lang;
            }
            this.bestPredictiveLanguages.incrementCount(bestLang, 1.0);
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Taxon lang : this.bestPredictiveLanguages) {
                builder.append("" + lang + "\t" + this.bestPredictiveLanguages.getCount(lang) + "\n");
            }
            return builder.toString();
        }
    }

    public static class FlatMinRiskBaseline
    extends Baseline {
        private final BayesRiskMinimizer.LossFct<String> loss;
        private final Set<Taxon> restriction;
        private final boolean useFrank;

        public FlatMinRiskBaseline(BayesRiskMinimizer.LossFct<String> loss, boolean useFrank) {
            this.useFrank = useFrank;
            this.loss = loss;
            this.restriction = null;
        }

        public FlatMinRiskBaseline(BayesRiskMinimizer.LossFct<String> loss, DataLoader loader, boolean useFrank) {
            this.useFrank = useFrank;
            this.loss = loss;
            this.restriction = new HashSet<Taxon>();
            List<Tree<String>> desc = FlatMinRiskBaseline.findNode(loader.getTopology(), loader.heldoutLang).getPreOrderTraversal();
            for (Tree<String> node : desc) {
                this.restriction.add(new Taxon(node.getLabel()));
            }
        }

        @Override
        public String baseline(Map<Taxon, String> words, String truth) {
            Counter<String> multiplicities = new Counter<String>();
            for (Taxon lang : words.keySet()) {
                if (this.restriction != null && !this.restriction.contains(lang)) continue;
                multiplicities.incrementCount(words.get(lang), 1.0);
            }
            if (multiplicities.totalCount() == 0.0) {
                for (Taxon lang : words.keySet()) {
                    multiplicities.incrementCount(words.get(lang), 1.0);
                }
            }
            BayesRiskMinimizer<String> riskMinimizer = new BayesRiskMinimizer<String>(this.loss, this.useFrank);
            return riskMinimizer.findMin(multiplicities);
        }
    }

    public static class RestrictToModernCharsUpperBound
    extends Baseline {
        @Override
        public Map<CognateId, String> baseline(DataLoaderInterface dataLoader) {
            if (this.result != null) {
                return this.result;
            }
            this.result = new HashMap();
            for (DataLoader.HeldoutEntry entry : dataLoader.getHeldout()) {
                Arbre<DerivationTree.DerivationNode> tree = dataLoader.getCognateSet().getTree(entry.id);
                ObservationsTracker obs = dataLoader.getCognateSet().getObs(entry.id);
                HashSet<Character> obsChars = new HashSet<Character>();
                for (Taxon lang : obs.observedLanguages()) {
                    char[] cArray = DerivationTree.findNodeByLangName(tree, lang).getContents().getWord().toCharArray();
                    int n = cArray.length;
                    for (int i = 0; i < n; ++i) {
                        char c = cArray[i];
                        obsChars.add(Character.valueOf(c));
                    }
                }
                StringBuilder withRemovedChars = new StringBuilder();
                for (char c : entry.trueReconstruction.toCharArray()) {
                    if (!obsChars.contains(Character.valueOf(c))) continue;
                    withRemovedChars.append(c);
                }
                this.result.put(entry.id, withRemovedChars.toString());
            }
            return this.result;
        }

        @Override
        public String baseline(Map<Taxon, String> words, String truth) {
            throw new RuntimeException();
        }
    }
}

