/*
 * Decompiled with CFR 0.152.
 */
package ma;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.StrUtils;
import goblin.CognateId;
import goblin.CognateSet;
import goblin.DataPrepUtils;
import goblin.DerivationTree;
import goblin.Heldout;
import goblin.ObservationsTracker;
import goblin.Taxon;
import goblin.TreeSamplers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import ma.LongGapAlignmentSampler;
import ma.MultiAlignment;
import nuts.math.MeasureZeroException;
import nuts.util.Arbre;

public class AlignMain {
    private static Set<Arbre<DerivationTree.DerivationNode>> initSubtrees(Map<Taxon, String> sequences) {
        HashSet<Arbre<DerivationTree.DerivationNode>> result = new HashSet<Arbre<DerivationTree.DerivationNode>>();
        for (Taxon lang : sequences.keySet()) {
            String sequence = sequences.get(lang);
            DerivationTree.DerivationNode node = new DerivationTree.DerivationNode(lang, sequence);
            Arbre<DerivationTree.DerivationNode> tree = Arbre.arbre(node);
            result.add(tree);
        }
        return result;
    }

    public static class MultiAlignCorpusLoader {
    }

    public static class MultiAlignDecoder {
        private TreeSamplers.AncestryMCMCKernelOptions samplerOptions;
        private LongGapAlignmentSampler.LongGapAlignmentSamplerParams params;
        @Option
        public int nIterations = 10;
        @Option
        public Random rand = new Random(1L);
        public static final CognateId dummyId = new CognateId("XXX");

        public void init(TreeSamplers.AncestryMCMCKernelOptions samplerOptions, LongGapAlignmentSampler.LongGapAlignmentSamplerParams params) {
            this.samplerOptions = samplerOptions;
            this.params = params;
        }

        public Arbre<DerivationTree.DerivationNode> decode(Arbre<DerivationTree.DerivationNode> initial, MultiAlignment reference) {
            ObservationsTracker obs = ObservationsTracker.modernObservationsTracker(initial);
            return this.decode(initial, reference, obs);
        }

        public Arbre<DerivationTree.DerivationNode> decode(Arbre<DerivationTree.DerivationNode> initial, MultiAlignment reference, ObservationsTracker obs) {
            Arbre<DerivationTree.DerivationNode> currentSample = initial;
            CognateSet dummyCognateSet = new CognateSet();
            dummyCognateSet.addCognate(dummyId, initial, obs);
            Heldout heldout = new Heldout();
            heldout.addMultiAlignmentReferenceEntry(dummyId, reference);
            Heldout heldout2 = heldout;
            heldout2.getClass();
            Heldout.BayesEvaluator evaluator = heldout2.new Heldout.BayesEvaluator(dummyCognateSet);
            LogInfo.track("Evaluating initialization");
            return currentSample;
        }
    }

    public static class BottomUpTreeBuilder {
        private final Map<Taxon, String> sequences;
        private final LongGapAlignmentSampler.LongGapAlignmentSamplerParams params;
        private Set<Arbre<DerivationTree.DerivationNode>> subtrees;

        public BottomUpTreeBuilder(Map<Taxon, String> sequences, LongGapAlignmentSampler.LongGapAlignmentSamplerParams params) {
            this.sequences = sequences;
            this.params = params;
            this.subtrees = null;
        }

        public Arbre<DerivationTree.DerivationNode> buildTree() {
            if (this.subtrees == null) {
                LogInfo.track("Building tree");
                try {
                    this.subtrees = AlignMain.initSubtrees(this.sequences);
                    while (this.subtrees.size() >= 2) {
                        Arbre<DerivationTree.DerivationNode> merged = this.popAndMergeClosest();
                        LogInfo.logss("Current tree: \n" + merged.deepToString());
                        this.subtrees.add(merged);
                    }
                }
                finally {
                    LogInfo.end_track();
                }
            }
            return this.subtrees.iterator().next();
        }

        public Set<Arbre<DerivationTree.DerivationNode>> buildSmallGammas() {
            return this.buildSmallGammas(null);
        }

        public Set<Arbre<DerivationTree.DerivationNode>> buildSmallGammas(MultiAlignment goldAlign) {
            ArrayList oneNodeTrees = new ArrayList(AlignMain.initSubtrees(this.sequences));
            HashSet<Arbre<DerivationTree.DerivationNode>> result = new HashSet<Arbre<DerivationTree.DerivationNode>>();
            for (int i = 0; i < oneNodeTrees.size(); ++i) {
                for (int j = 0; j < i; ++j) {
                    result.add(this.merge((Arbre)oneNodeTrees.get(i), (Arbre)oneNodeTrees.get(j), goldAlign));
                }
            }
            return result;
        }

        public Arbre<DerivationTree.DerivationNode> buildFlatTree() {
            return this.buildFlatTree(null);
        }

        public Arbre<DerivationTree.DerivationNode> buildFlatTree(MultiAlignment goldAlign) {
            ArrayList<Arbre<DerivationTree.DerivationNode>> oneNodeTrees = new ArrayList<Arbre<DerivationTree.DerivationNode>>(AlignMain.initSubtrees(this.sequences));
            return this.merge(oneNodeTrees, goldAlign);
        }

        private LongGapAlignmentSampler getAlignSampler(String top, String bottom) {
            return new LongGapAlignmentSampler(top, bottom, this.params);
        }

        private double distance(String seq1, String seq2) {
            return this.getAlignSampler(seq1, seq2).getLogMaxScore() / (double)(seq1.length() + seq2.length());
        }

        private Arbre<DerivationTree.DerivationNode> popAndMergeClosest() {
            double min = Double.POSITIVE_INFINITY;
            StringBuilder msg = new StringBuilder();
            Arbre<DerivationTree.DerivationNode> best1 = null;
            Arbre<DerivationTree.DerivationNode> best2 = null;
            for (Arbre<DerivationTree.DerivationNode> tree1 : this.subtrees) {
                for (Arbre<DerivationTree.DerivationNode> tree2 : this.subtrees) {
                    if (tree1.getContents().getLanguage().equals(tree2.getContents().getLanguage())) continue;
                    double current = this.distance(tree1.getContents().getWord(), tree2.getContents().getWord());
                    msg.append("" + current + " ");
                    if (!(current < min)) continue;
                    best1 = tree1;
                    best2 = tree2;
                    min = current;
                }
            }
            LogInfo.logss("Picked lowest distance of " + min + " among " + msg.toString());
            this.subtrees.remove(best1);
            this.subtrees.remove(best2);
            return this.merge(best1, best2);
        }

        private Arbre<DerivationTree.DerivationNode> merge(Arbre<DerivationTree.DerivationNode> tree1, Arbre<DerivationTree.DerivationNode> tree2) {
            return this.merge(tree1, tree2, null);
        }

        private Arbre<DerivationTree.DerivationNode> merge(Arbre<DerivationTree.DerivationNode> tree1, Arbre<DerivationTree.DerivationNode> tree2, MultiAlignment goldAlign) {
            tree1 = tree1.copy();
            tree2 = tree2.copy();
            DerivationTree.DerivationNode newTop = this.initTop(tree1, tree2, goldAlign);
            if (!tree1.getContents().getDerivation().getAncestorWord().equals(newTop.getWord()) || !tree2.getContents().getDerivation().getAncestorWord().equals(newTop.getWord())) {
                throw new RuntimeException();
            }
            return Arbre.arbreWithChildren(newTop, tree1, tree2);
        }

        private Arbre<DerivationTree.DerivationNode> merge(List<Arbre<DerivationTree.DerivationNode>> children, MultiAlignment goldAlign) {
            DerivationTree.DerivationNode newTop = this.initTop(children, goldAlign);
            return Arbre.arbre(newTop, children);
        }

        private DerivationTree.DerivationNode initTop(Arbre<DerivationTree.DerivationNode> child1, Arbre<DerivationTree.DerivationNode> child2, MultiAlignment goldAlign) {
            ArrayList<Arbre<DerivationTree.DerivationNode>> children = new ArrayList<Arbre<DerivationTree.DerivationNode>>();
            children.add(child1);
            children.add(child2);
            return this.initTop(children, goldAlign);
        }

        private DerivationTree.DerivationNode initTop(List<Arbre<DerivationTree.DerivationNode>> children, MultiAlignment goldAlign) {
            ArrayList<String> childLangs = new ArrayList<String>();
            for (Arbre<DerivationTree.DerivationNode> child : children) {
                childLangs.add(child.getContents().getLanguage().toString());
            }
            Collections.sort(childLangs);
            Taxon newName = new Taxon(StrUtils.join(childLangs, "-"));
            String topWord = children.get(0).getContents().getWord();
            if (goldAlign == null) {
                for (Arbre<DerivationTree.DerivationNode> child : children) {
                    child.setContents(this.initDerivation(child.getContents(), topWord));
                }
            } else {
                children.get(0).setContents(DataPrepUtils.monotonicDerivation(children.get(0).getContents()));
                for (int i = 1; i < children.size(); ++i) {
                    children.get(i).setContents(this.goldDerivation(children.get(i).getContents(), children.get(0).getContents(), goldAlign));
                }
            }
            return new DerivationTree.DerivationNode(newName, topWord);
        }

        private DerivationTree.DerivationNode goldDerivation(DerivationTree.DerivationNode bottomNode, DerivationTree.DerivationNode topNode, MultiAlignment goldAlign) {
            DerivationTree.Derivation d = goldAlign.getDerivation(topNode.getLanguage(), bottomNode.getLanguage());
            return new DerivationTree.DerivationNode(bottomNode.getLanguage(), bottomNode.getWord(), d);
        }

        private DerivationTree.DerivationNode initDerivation(DerivationTree.DerivationNode bottom, String top) {
            DerivationTree.Derivation d;
            try {
                d = this.getAlignSampler(top, bottom.getWord()).mode();
            }
            catch (MeasureZeroException e) {
                throw new RuntimeException(e);
            }
            return new DerivationTree.DerivationNode(bottom.getLanguage(), bottom.getWord(), d);
        }
    }
}

