/*
 * Decompiled with CFR 0.152.
 */
package ma;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Pair;
import goblin.BayesRiskMinimizer;
import goblin.DerivationTree;
import goblin.ObservationsTracker;
import goblin.Taxon;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import ma.GreedyDecoder;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.math.EqClasses;
import nuts.util.Arbre;
import nuts.util.Counter;
import nuts.util.MathUtils;
import pepper.Encodings;

public class MultiAlignment
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final char GAP_CHAR = '.';
    private final EqClasses<SequenceCoordinate> alignmentEqClasses;
    private final List<Taxon> alignedNodes;
    private final Map<Taxon, String> words;
    private boolean isReference;
    public static final String ALN_LINE = "^[^ ]+\\s+[A-Za-z- ]+$";

    public Map<Taxon, String> getSequences() {
        return Collections.unmodifiableMap(this.words);
    }

    public MultiAlignment(Map<Taxon, String> words) {
        this.words = new HashMap<Taxon, String>(words);
        this.isReference = false;
        this.alignedNodes = new ArrayList<Taxon>(words.keySet());
        this.alignmentEqClasses = new EqClasses();
        for (Taxon lang : words.keySet()) {
            for (int i = 0; i < words.get(lang).length(); ++i) {
                this.alignmentEqClasses.addNewElt(new SequenceCoordinate(lang, i));
            }
        }
    }

    public void addAlign(Taxon l1, int i1, Taxon l2, int i2) {
        SequenceCoordinate sc1 = new SequenceCoordinate(l1, i1);
        SequenceCoordinate sc2 = new SequenceCoordinate(l2, i2);
        this.alignmentEqClasses.forceNewRelation(sc1, sc2);
    }

    public void addAll(MultiAlignment ma2) {
        for (SequenceCoordinate repr : ma2.alignmentEqClasses.representatives()) {
            ArrayList<SequenceCoordinate> elts = new ArrayList<SequenceCoordinate>(ma2.alignmentEqClasses.eqClass(repr));
            if (elts.size() <= 1) continue;
            for (int i = 0; i < elts.size(); ++i) {
                SequenceCoordinate first = (SequenceCoordinate)elts.get(i);
                if (!this.getSequences().keySet().contains(first.getNodeIdentifier())) continue;
                for (int j = i + 1; j < elts.size(); ++j) {
                    SequenceCoordinate second = (SequenceCoordinate)elts.get(j);
                    if (!this.getSequences().keySet().contains(second.getNodeIdentifier())) continue;
                    this.alignmentEqClasses.forceNewRelation(first, second);
                }
            }
        }
    }

    public MultiAlignment copy() {
        Set<Taxon> all = this.getSequences().keySet();
        return this.restrict(all);
    }

    public MultiAlignment restrict(Collection<Taxon> restriction) {
        HashMap<Taxon, String> restricted = new HashMap<Taxon, String>();
        for (Taxon lang : restriction) {
            restricted.put(lang, this.getSequences().get(lang));
        }
        MultiAlignment result = new MultiAlignment(restricted);
        result.addAll(this);
        result.isReference = this.isReference;
        if (this.isReference) {
            HashMap<SequenceCoordinate, SequenceCoordinate> all = new HashMap<SequenceCoordinate, SequenceCoordinate>();
            for (SequenceCoordinate rep : result.alignmentEqClasses.representatives()) {
                for (SequenceCoordinate elt : result.alignmentEqClasses.eqClass(rep)) {
                    all.put(elt, elt);
                }
            }
            for (SequenceCoordinate rep : this.alignmentEqClasses.representatives()) {
                for (SequenceCoordinate elt : this.alignmentEqClasses.eqClass(rep)) {
                    if (!restriction.contains(elt.getNodeIdentifier())) continue;
                    SequenceCoordinate newSC = (SequenceCoordinate)all.get(elt);
                    newSC.isCoreBlock = elt.isCoreBlock;
                }
            }
        }
        return result;
    }

    public void changeString(Taxon l, String newStr) {
        if (this.words.get(l).length() != newStr.length()) {
            throw new RuntimeException();
        }
        this.words.put(l, newStr);
    }

    public EqClasses<SequenceCoordinate> eqClasses() {
        return this.alignmentEqClasses;
    }

    public List<Taxon> nodes() {
        return Collections.unmodifiableList(this.alignedNodes);
    }

    @Deprecated
    public static MultiAlignment restrict(MultiAlignment ma, Collection<Taxon> currentSet) {
        String[] originalLines = ma.toMSFString().split("\n");
        StringBuilder result = new StringBuilder();
        block2: for (String line : originalLines) {
            for (Taxon lang : currentSet) {
                String langStr = lang.toString();
                int langStrLen = langStr.length();
                if (line.length() <= langStrLen || !line.substring(0, langStrLen).equals(langStr)) continue;
                result.append(line + '\n');
                continue block2;
            }
        }
        String msfString = "//\n" + result.toString();
        try {
            return MultiAlignment.parseMSFStringToMultiAlignment(msfString);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MultiAlignment(Set<GreedyDecoder.Edge> edges, Map<Taxon, String> words) {
        this.words = new HashMap<Taxon, String>(words);
        this.isReference = false;
        this.alignedNodes = new ArrayList<Taxon>(words.keySet());
        this.alignmentEqClasses = new EqClasses();
        for (GreedyDecoder.Edge edge : edges) {
            SequenceCoordinate sc1 = new SequenceCoordinate(edge.lang1(), edge.index1());
            SequenceCoordinate sc2 = new SequenceCoordinate(edge.lang2(), edge.index2());
            this.alignmentEqClasses.forceNewRelation(sc1, sc2);
        }
        for (Taxon lang : words.keySet()) {
            for (int i = 0; i < words.get(lang).length(); ++i) {
                SequenceCoordinate sc = new SequenceCoordinate(lang, i);
                if (this.alignmentEqClasses.contains(sc)) continue;
                this.alignmentEqClasses.addNewElt(sc);
            }
        }
    }

    public static MultiAlignment inducedMultiAlignment(Arbre<DerivationTree.DerivationNode> arbre, ObservationsTracker obs) {
        ArrayList<Taxon> observedNodes = new ArrayList<Taxon>(obs.observedLanguages());
        return new MultiAlignment(arbre, observedNodes);
    }

    public static MultiAlignment inducedMultiAlignment(Arbre<DerivationTree.DerivationNode> arbre) {
        ObservationsTracker tracker = ObservationsTracker.modernObservationsTracker(arbre);
        return MultiAlignment.inducedMultiAlignment(arbre, tracker);
    }

    public static MultiAlignment fullInducedMultiAlignment(Arbre<DerivationTree.DerivationNode> arbre) {
        ObservationsTracker tracker = ObservationsTracker.allObservationsTracker(arbre);
        return MultiAlignment.inducedMultiAlignment(arbre, tracker);
    }

    public static MultiAlignment inducedMultiAlignment(Taxon topNode, Taxon bottomNode, DerivationTree.Derivation derivation) {
        DerivationTree.DerivationNode dummyTop = new DerivationTree.DerivationNode(topNode, derivation.getAncestorWord());
        DerivationTree.DerivationNode dummyBottom = new DerivationTree.DerivationNode(bottomNode, derivation.getCurrentWord(), derivation);
        Arbre<DerivationTree.DerivationNode> dummyTree = Arbre.arbreWithChildren(dummyTop, Arbre.arbre(dummyBottom));
        HashSet<Taxon> obs = new HashSet<Taxon>();
        obs.add(topNode);
        obs.add(bottomNode);
        return MultiAlignment.inducedMultiAlignment(dummyTree, new ObservationsTracker(obs));
    }

    public int gappiness() {
        return this.alignmentEqClasses.representatives().size();
    }

    @Deprecated
    public MultiAlignment restrict(Taxon node1, Taxon node2) {
        DerivationTree.Derivation deriv = this.getDerivation(node1, node2);
        return MultiAlignment.inducedMultiAlignment(node1, node2, deriv);
    }

    public DerivationTree.Derivation getDerivation(Taxon topNode, Taxon bottomNode) {
        String topWord = this.words.get(topNode);
        String bottomWord = this.words.get(bottomNode);
        if (topWord == null || bottomWord == null) {
            throw new RuntimeException("Bad args in MultiAlignment.getDerivation");
        }
        int[] ancestors = new int[bottomWord.length()];
        for (int bottomPos = 0; bottomPos < bottomWord.length(); ++bottomPos) {
            SequenceCoordinate key = new SequenceCoordinate(bottomNode, bottomPos);
            Set<SequenceCoordinate> eqClass = this.alignmentEqClasses.eqClass(key);
            int ancestor = -1;
            for (SequenceCoordinate alignedTo : eqClass) {
                if (!alignedTo.getNodeIdentifier().equals(topNode)) continue;
                ancestor = alignedTo.indexInSequence();
            }
            ancestors[bottomPos] = ancestor;
        }
        return new DerivationTree.Derivation(ancestors, topWord, bottomWord);
    }

    public double averageEqClassSize() {
        double sum = 0.0;
        double denom = 0.0;
        for (SequenceCoordinate rep : this.alignmentEqClasses.representatives()) {
            denom += 1.0;
            sum += (double)this.alignmentEqClasses.eqClass(rep).size();
        }
        return denom == 0.0 ? 0.0 : sum / denom;
    }

    public boolean isCoreBlock(Taxon l, int index) {
        SequenceCoordinate key = new SequenceCoordinate(l, index);
        Set<SequenceCoordinate> eq = this.alignmentEqClasses.eqClass(key);
        for (SequenceCoordinate coord : eq) {
            if (!coord.getNodeIdentifier().equals(l) || coord.indexInSequence() != index) continue;
            return coord.isCoreBlock;
        }
        throw new RuntimeException("Internal error in isCoreBlock");
    }

    public boolean isAligned(Taxon l1, int index1, Taxon l2, int index2) {
        if (!this.isReference) {
            throw new RuntimeException();
        }
        SequenceCoordinate key1 = new SequenceCoordinate(l1, index1);
        SequenceCoordinate key2 = new SequenceCoordinate(l2, index2);
        return this.alignmentEqClasses.areRelated(key1, key2);
    }

    public MultiAlignment interpolate(Taxon lang0, Taxon lang1, Taxon interpolatedNewLang, Random rand) {
        return new MultiAlignment(this, lang0, lang1, interpolatedNewLang, rand);
    }

    private MultiAlignment(MultiAlignment init, Taxon lang0, Taxon lang1, Taxon newLang, Random rand) {
        if (!init.words.keySet().contains(lang0) || !init.words.keySet().contains(lang1)) {
            throw new RuntimeException("" + lang0 + " or " + lang1 + " not in " + init.words.keySet());
        }
        if (init.alignedNodes.contains(newLang)) {
            throw new RuntimeException("Bad args 2 in MA constr");
        }
        this.isReference = false;
        ArrayList<Taxon> alignedNodes = new ArrayList<Taxon>(init.alignedNodes);
        alignedNodes.add(newLang);
        this.alignedNodes = Collections.unmodifiableList(alignedNodes);
        HashMap<Taxon, String> words = new HashMap<Taxon, String>(init.words);
        this.alignmentEqClasses = new EqClasses();
        StringBuilder currentNewWord = new StringBuilder();
        for (int word0pos = 0; word0pos < ((String)words.get(lang0)).length(); ++word0pos) {
            MultiAlignment multiAlignment = init;
            multiAlignment.getClass();
            SequenceCoordinate lang0rep = multiAlignment.new SequenceCoordinate(lang0, word0pos);
            this.alignmentEqClasses.addNewElt(new SequenceCoordinate(lang0rep));
            Set<SequenceCoordinate> curEqClass = init.alignmentEqClasses.eqClass(lang0rep);
            for (SequenceCoordinate related : curEqClass) {
                if (related.equals(lang0rep)) continue;
                this.alignmentEqClasses.addNewRelation(new SequenceCoordinate(lang0rep), new SequenceCoordinate(related));
                if (!related.getNodeIdentifier().equals(lang1)) continue;
                char newChar = rand.nextInt(2) == 0 ? lang0rep.getCharValue() : related.getCharValue();
                int newIndex = currentNewWord.length();
                currentNewWord.append(newChar);
                SequenceCoordinate newSc = new SequenceCoordinate(newLang, newIndex);
                this.alignmentEqClasses.addNewRelation(new SequenceCoordinate(lang0rep), newSc);
            }
        }
        for (SequenceCoordinate rep : init.alignmentEqClasses.representatives()) {
            if (this.alignmentEqClasses.contains(rep)) continue;
            rep = new SequenceCoordinate(rep);
            this.alignmentEqClasses.addNewElt(rep);
            for (SequenceCoordinate x : init.alignmentEqClasses.eqClass(rep)) {
                if (x.equals(rep)) continue;
                this.alignmentEqClasses.addNewRelation(rep, new SequenceCoordinate(x));
            }
        }
        words.put(newLang, currentNewWord.toString());
        this.words = Collections.unmodifiableMap(words);
        this.alignmentEqClasses.freeze();
    }

    private MultiAlignment(Arbre<DerivationTree.DerivationNode> arbre, List<Taxon> alignedNodes) {
        this.isReference = false;
        this.alignedNodes = Collections.unmodifiableList(new ArrayList<Taxon>(alignedNodes));
        HashMap<Taxon, String> words = new HashMap<Taxon, String>();
        for (Arbre<DerivationTree.DerivationNode> node : arbre.nodes()) {
            if (!alignedNodes.contains(node.getContents().getLanguage())) continue;
            words.put(node.getContents().getLanguage(), node.getContents().getWord());
        }
        this.words = Collections.unmodifiableMap(words);
        this.alignmentEqClasses = this.createAlignmentEqClasses(arbre);
        this.alignmentEqClasses.freeze();
    }

    public boolean isReference() {
        return this.isReference;
    }

    private Map<Set<SequenceCoordinate>, Map<Taxon, Integer>> getAmaCache() {
        HashMap<Set<SequenceCoordinate>, Map<Taxon, Integer>> _amaCache = new HashMap<Set<SequenceCoordinate>, Map<Taxon, Integer>>();
        for (SequenceCoordinate sc : this.alignmentEqClasses.representatives()) {
            Set<SequenceCoordinate> current = this.alignmentEqClasses.eqClass(sc);
            HashMap<Taxon, Integer> organized = new HashMap<Taxon, Integer>();
            for (SequenceCoordinate elt : current) {
                organized.put(elt.getNodeIdentifier(), elt.indexInSequence());
            }
            _amaCache.put(current, organized);
        }
        return _amaCache;
    }

    public static double ama(MultiAlignment ma1, MultiAlignment ma2) {
        if (ma1.isReference() && ma2.isReference()) {
            throw new RuntimeException();
        }
        if (ma2.isReference()) {
            MultiAlignment temp = ma1;
            ma1 = ma2;
            ma2 = temp;
        }
        Map<Set<SequenceCoordinate>, Map<Taxon, Integer>> c1 = ma1.getAmaCache();
        Map<Set<SequenceCoordinate>, Map<Taxon, Integer>> c2 = ma2.getAmaCache();
        Map<Taxon, String> words = ma1.getSequences();
        if (!words.equals(ma2.getSequences())) {
            throw new RuntimeException();
        }
        double result = 0.0;
        ArrayList<Taxon> langs = new ArrayList<Taxon>(ma1.getSequences().keySet());
        for (int i = 0; i < langs.size(); ++i) {
            Taxon lang = (Taxon)langs.get(i);
            for (int position = 0; position < words.get(lang).length(); ++position) {
                MultiAlignment multiAlignment = ma1;
                multiAlignment.getClass();
                SequenceCoordinate sc = multiAlignment.new SequenceCoordinate(lang, position);
                if (ma1.isReference() && !sc.isCoreBlock()) continue;
                Map<Taxon, Integer> links1FromSC = c1.get(ma1.alignmentEqClasses.eqClass(sc));
                Map<Taxon, Integer> links2FromSC = c2.get(ma2.alignmentEqClasses.eqClass(sc));
                for (int j = 0; j < langs.size(); ++j) {
                    Taxon lang2 = (Taxon)langs.get(j);
                    if (lang2.equals(lang)) continue;
                    result += 1.0;
                    if (!MultiAlignment.bothLinked(links1FromSC, links2FromSC, lang2) && !MultiAlignment.bothUnLinked(links1FromSC, links2FromSC, lang2)) continue;
                    result -= 1.0;
                }
            }
        }
        return result;
    }

    public static double amaSim(MultiAlignment ma1, MultiAlignment ma2) {
        double sumOfLength = 0.0;
        for (String seqn : ma1.getSequences().values()) {
            sumOfLength += (double)seqn.length();
        }
        return 1.0 - MultiAlignment.ama(ma1, ma2) / ((double)ma1.getSequences().size() - 1.0) / sumOfLength;
    }

    private static boolean bothLinked(Map<Taxon, Integer> links1FromSC, Map<Taxon, Integer> links2FromSC, Taxon lang2) {
        Integer i1 = links1FromSC.get(lang2);
        Integer i2 = links2FromSC.get(lang2);
        if (i1 == null || i2 == null) {
            return false;
        }
        return i1.equals(i2);
    }

    private static boolean bothUnLinked(Map<Taxon, Integer> links1FromSC, Map<Taxon, Integer> links2FromSC, Taxon lang2) {
        Integer i1 = links1FromSC.get(lang2);
        Integer i2 = links2FromSC.get(lang2);
        return i1 == null && i2 == null;
    }

    private MultiAlignment(Map<Taxon, String> msfAlignedData, CoreBlockSpecs coreBlockSpecs) {
        this.isReference = coreBlockSpecs != null;
        this.alignedNodes = Collections.unmodifiableList(new ArrayList<Taxon>(msfAlignedData.keySet()));
        this.words = Collections.unmodifiableMap(MultiAlignment.removeGaps(msfAlignedData));
        this.alignmentEqClasses = this.createAlignmentEqClasses(msfAlignedData);
        this.alignmentEqClasses.freeze();
        if (coreBlockSpecs != null) {
            this.processCoreBlockSpecs(coreBlockSpecs);
        }
    }

    private void processCoreBlockSpecs(CoreBlockSpecs coreBlockSpecs) {
        int referenceSeqLength = this.words.get(coreBlockSpecs.refNodeId).length();
        for (SequenceCoordinate rep : this.alignmentEqClasses.representatives()) {
            for (SequenceCoordinate elt : this.alignmentEqClasses.eqClass(rep)) {
                elt.isCoreBlock = false;
            }
        }
        Iterator<Serializable> iterator = coreBlockSpecs.intervals.elements().iterator();
        while (iterator.hasNext()) {
            int position = (Integer)iterator.next();
            if (position < 0 || position >= referenceSeqLength) {
                System.err.println("Invalid position: " + position + " in seqn " + coreBlockSpecs.refNodeId + " (length " + referenceSeqLength + ")");
                continue;
            }
            SequenceCoordinate rep = new SequenceCoordinate(coreBlockSpecs.refNodeId, position);
            for (SequenceCoordinate elt : this.alignmentEqClasses.eqClass(rep)) {
                elt.isCoreBlock = true;
            }
        }
    }

    private EqClasses<SequenceCoordinate> createAlignmentEqClasses(Map<Taxon, String> msfAlignedData) {
        EqClasses<SequenceCoordinate> result = new EqClasses<SequenceCoordinate>();
        Counter<Taxon> currentPositionInSequences = new Counter<Taxon>();
        for (int col = 0; col < msfAlignedData.values().iterator().next().length(); ++col) {
            SequenceCoordinate representative = null;
            for (Taxon lang : msfAlignedData.keySet()) {
                char cChar = msfAlignedData.get(lang).charAt(col);
                representative = this.processColumn(lang, cChar, currentPositionInSequences, result, representative);
            }
        }
        return result;
    }

    private SequenceCoordinate processColumn(Taxon lang, char cChar, Counter<Taxon> currentPositionInSequences, EqClasses<SequenceCoordinate> eqClass, SequenceCoordinate representative) {
        if (cChar == '.') {
            return representative;
        }
        int currentSeqIndex = (int)currentPositionInSequences.getCount(lang);
        SequenceCoordinate current = new SequenceCoordinate(lang, currentSeqIndex);
        if (representative == null) {
            representative = current;
            eqClass.addNewElt(representative);
        } else {
            eqClass.addNewRelation(representative, current);
        }
        currentPositionInSequences.incrementCount(lang, 1.0);
        return representative;
    }

    private boolean isAlignedNode(Taxon lang) {
        return this.words.containsKey(lang);
    }

    private EqClasses<SequenceCoordinate> createAlignmentEqClasses(Arbre<DerivationTree.DerivationNode> arbre) {
        EqClasses<SequenceCoordinate> result = new EqClasses<SequenceCoordinate>();
        for (Arbre<DerivationTree.DerivationNode> node : arbre.nodes()) {
            Taxon lang = node.getContents().getLanguage();
            if (!this.isAlignedNode(lang)) continue;
            String cWord = this.words.get(lang);
            for (int position = 0; position < cWord.length(); ++position) {
                SequenceCoordinate representative = new SequenceCoordinate(lang, position);
                if (result.contains(representative)) continue;
                this.addEqClass(representative, node, result);
            }
        }
        return result;
    }

    private void addEqClass(SequenceCoordinate representative, Arbre<DerivationTree.DerivationNode> node, EqClasses<SequenceCoordinate> eqClasses) {
        eqClasses.addNewElt(representative);
        DerivationTree.Window window = new DerivationTree.Window(representative.indexInSequence(), representative.indexInSequence() + 1);
        Arbre<DerivationTree.LineagedNode> lineagedTree = DerivationTree.lineage(node, window, false);
        for (Arbre<DerivationTree.LineagedNode> lineagedNode : lineagedTree.nodes()) {
            DerivationTree.Window lineagedNodeWindow;
            Taxon lineagedNodeLang = lineagedNode.getContents().getDerivationNode().getLanguage();
            if (!this.isAlignedNode(lineagedNodeLang) || (lineagedNodeWindow = lineagedNode.getContents().getWindow()).length() == 0) continue;
            if (lineagedNodeWindow.length() == 1) {
                SequenceCoordinate newElt = new SequenceCoordinate(lineagedNodeLang, lineagedNodeWindow.left());
                if (newElt.equals(representative)) continue;
                eqClasses.addNewRelation(representative, newElt);
                continue;
            }
            throw new RuntimeException("Internal error in MA.addEqClass");
        }
    }

    private Map<Taxon, Integer> createReverseNodeIndex() {
        HashMap<Taxon, Integer> reverseNodeIndex = new HashMap<Taxon, Integer>();
        for (int i = 0; i < this.alignedNodes.size(); ++i) {
            reverseNodeIndex.put(this.alignedNodes.get(i), i);
        }
        return reverseNodeIndex;
    }

    public String toMSFString() {
        return this.createAlignmentMatrix().toMSFString();
    }

    public LinearizedAlignmentMatrix createAlignmentMatrix() {
        LinearizedAlignmentMatrix linearizedAlignmentMatrix = new LinearizedAlignmentMatrix();
        Map<Taxon, Integer> reverseNodeIndex = this.createReverseNodeIndex();
        SequenceStacks stacks = new SequenceStacks();
        int cCol = 0;
        while (!stacks.areEmpty()) {
            Set<SequenceCoordinate> eqClass = this.findSurfaceEquivalenceClass(stacks);
            for (SequenceCoordinate elt : eqClass) {
                Taxon eltLang = elt.getNodeIdentifier();
                char eltChar = elt.getCharValue();
                if (this.isReference) {
                    linearizedAlignmentMatrix.addPoint(reverseNodeIndex.get(eltLang), cCol, eltChar, elt.isCoreBlock());
                } else {
                    linearizedAlignmentMatrix.addPoint(reverseNodeIndex.get(eltLang), cCol, eltChar);
                }
                stacks.pop(eltLang);
            }
            ++cCol;
        }
        return linearizedAlignmentMatrix;
    }

    private Set<SequenceCoordinate> findSurfaceEquivalenceClass(SequenceStacks stacks) {
        Set<Taxon> langs = stacks.findNonEmptyStacks();
        for (Taxon lang : langs) {
            int indexInString;
            SequenceCoordinate representative = new SequenceCoordinate(lang, indexInString = stacks.peakIndex(lang));
            Set<SequenceCoordinate> eqClass = this.alignmentEqClasses.eqClass(representative);
            if (!stacks.isEqClassOnStackSurface(eqClass)) continue;
            return eqClass;
        }
        throw new RuntimeException("Internal error in findSurfaceEqClass");
    }

    public String toString() {
        return this.createAlignmentMatrix().toString();
    }

    public int hashCode() {
        return this.alignmentEqClasses.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof MultiAlignment)) {
            return false;
        }
        MultiAlignment o_cast = (MultiAlignment)o;
        if (!this.alignmentEqClasses.equals(o_cast.alignmentEqClasses)) {
            return false;
        }
        return this.words.equals(o_cast.words);
    }

    private static double pairsF1(MultiAlignment m1, MultiAlignment m2) {
        double r = m1.sumOfPairsScore(m2, true);
        double p = m2.sumOfPairsScore(m1, true);
        return 2.0 * p * r / (p + r);
    }

    public static double columnsF1(MultiAlignment m1, MultiAlignment m2) {
        double r = m1.columnScore(m2, true);
        double p = m2.columnScore(m1, true);
        return 2.0 * p * r / (p + r);
    }

    public double columnScore(MultiAlignment guess) {
        return this.columnScore(guess, false);
    }

    public double columnScore(MultiAlignment guess, boolean ignoreCB) {
        double num = 0.0;
        double denom = 0.0;
        for (SequenceCoordinate refColRep : this.alignmentEqClasses.representatives()) {
            Set<SequenceCoordinate> guessColEqClass;
            if (!ignoreCB && !refColRep.isCoreBlock) continue;
            denom += 1.0;
            Set<SequenceCoordinate> refColEqClass = this.alignmentEqClasses.eqClass(refColRep);
            if (!refColEqClass.equals(guessColEqClass = guess.alignmentEqClasses.eqClass(refColRep))) continue;
            num += 1.0;
        }
        return num / denom;
    }

    public double sumOfPairsScore(MultiAlignment guess) {
        return this.sumOfPairsScore(guess, false);
    }

    private double sumOfPairsScore(MultiAlignment guess, boolean ignoreCB) {
        if (!guess.getSequences().equals(this.getSequences())) {
            throw new RuntimeException();
        }
        double num = 0.0;
        double denom = 0.0;
        for (SequenceCoordinate refColRep : this.alignmentEqClasses.representatives()) {
            if (!ignoreCB && !refColRep.isCoreBlock) continue;
            ArrayList<SequenceCoordinate> refColEqClass = new ArrayList<SequenceCoordinate>(this.alignmentEqClasses.eqClass(refColRep));
            for (int i = 0; i < refColEqClass.size(); ++i) {
                for (int j = 0; j < i; ++j) {
                    SequenceCoordinate y;
                    denom += 1.0;
                    SequenceCoordinate x = (SequenceCoordinate)refColEqClass.get(i);
                    if (!guess.alignmentEqClasses.areRelated(x, y = (SequenceCoordinate)refColEqClass.get(j))) continue;
                    num += 1.0;
                }
            }
        }
        return num / denom;
    }

    public static MultiAlignment parseMSFToMultiAlignment(String msfFile) throws IOException {
        return new MSFParser(IOUtils.openIn(msfFile), null, "").constructMultiAlignment();
    }

    public static MultiAlignment parseMSFStringToMultiAlignment(String msfString) throws IOException {
        return new MSFParser(new BufferedReader(new StringReader(msfString)), null, "").constructMultiAlignment();
    }

    public static MultiAlignment parseMSFToMultiAlignment(String msfFile, String annotationsFile) throws IOException {
        return MultiAlignment.parseMSFToMultiAlignment(msfFile, annotationsFile, "");
    }

    public static MultiAlignment parseMSFToMultiAlignment(String msfFile, String annotationsFile, String prefix) throws IOException {
        return new MSFParser(IOUtils.openIn(msfFile), annotationsFile, prefix).constructMultiAlignment();
    }

    public static Map<Taxon, String> parseMSFToUnalignedSeq(String file) throws IOException {
        return new MSFParser(IOUtils.openIn(file)).getUnalignedSequences();
    }

    public static MultiAlignment parseALNStringToMultiAlignment(String contents, String prefix) throws IOException {
        String msf = MultiAlignment.aln2msf(contents);
        BufferedReader reader = new BufferedReader(new StringReader(msf));
        return new MSFParser(reader, null, prefix).constructMultiAlignment();
    }

    public static MultiAlignment parseALNToMultiAlignment(String alnFile, String prefix) throws IOException {
        StringBuilder contents = new StringBuilder();
        for (String line : IO.i(alnFile)) {
            contents.append(line + "\n");
        }
        return MultiAlignment.parseALNStringToMultiAlignment(contents.toString(), prefix);
    }

    public static String aln2msf(String msfFileContents) {
        StringBuilder result = new StringBuilder();
        result.append("\n//\n");
        for (String line : msfFileContents.split("\n")) {
            if (line.matches("^.*multiple sequence alignment.*$")) continue;
            if (line.matches(ALN_LINE)) {
                String[] fields = line.split("\\s+");
                String convertedLine = fields[0] + " ";
                for (int i = 1; i < fields.length; ++i) {
                    convertedLine = convertedLine + fields[i].replaceAll("[-]", ".").replaceAll(" ", "") + " ";
                }
                result.append(convertedLine + "\n");
                continue;
            }
            if (line.matches("^[ *.:]+$")) continue;
            if (line.matches("^\\s*$")) {
                result.append("\n");
                continue;
            }
            System.err.println("Warning, unknown line: " + line);
        }
        return result.toString();
    }

    public static Map<Taxon, String> removeGaps(Map<Taxon, String> msfAlignedData) {
        HashMap<Taxon, String> result = new HashMap<Taxon, String>();
        for (Taxon nodeId : msfAlignedData.keySet()) {
            String contents = msfAlignedData.get(nodeId);
            String processedSequence = contents.replaceAll("[.]", "");
            result.put(nodeId, processedSequence);
        }
        return result;
    }

    public static String toGDE(MultiAlignment ma) {
        StringBuilder result = new StringBuilder();
        Map<Taxon, String> sequences = ma.words;
        for (Taxon l : sequences.keySet()) {
            result.append("{\n");
            result.append("name \"" + l.toString() + "\"\n");
            result.append("type PROTEIN\n");
            result.append("sequence \"" + sequences.get(l) + "\"\n");
            result.append("\n}\n\n");
        }
        return result.toString();
    }

    public void saveToMSF(File path) {
        String contents = this.createAlignmentMatrix().toMSFString();
        try {
            PrintWriter out = IOUtils.openOut(path);
            out.append(contents);
            out.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static String toFASTA(MultiAlignment ma) {
        StringBuilder result = new StringBuilder();
        Map<Taxon, String> sequences = ma.words;
        for (Taxon l : sequences.keySet()) {
            result.append(">");
            result.append(l.toString() + "\n");
            result.append(sequences.get(l) + "\n");
        }
        return result.toString();
    }

    public static void testAMA(String[] args) throws IOException {
        MultiAlignment ma1 = MultiAlignment.parseMSFToMultiAlignment(args[0] + ".msf");
        MultiAlignment ma2 = MultiAlignment.parseALNToMultiAlignment(args[0] + ".aln", "");
        double dist = MultiAlignment.ama(ma1, ma2);
        System.out.println("ama(ma1,ma2)=" + dist);
        if (!MathUtils.close((int)dist, dist)) {
            throw new RuntimeException();
        }
        if (!MathUtils.close(dist, MultiAlignment.ama(ma2, ma1))) {
            throw new RuntimeException();
        }
        ArrayList<Taxon> langs = new ArrayList<Taxon>(ma1.getSequences().keySet());
        double direct = 0.0;
        for (int i = 0; i < langs.size(); ++i) {
            for (int j = i + 1; j < langs.size(); ++j) {
                MultiAlignment sma1 = ma1.restrict((Taxon)langs.get(i), (Taxon)langs.get(j));
                MultiAlignment sma2 = ma2.restrict((Taxon)langs.get(i), (Taxon)langs.get(j));
                direct += MultiAlignment.ama(sma1, sma2);
            }
        }
        System.out.println("Direct=" + direct);
        System.out.println("Sim=" + MultiAlignment.amaSim(ma1, ma2));
        System.out.println("ama(ma1,ma1)=" + MultiAlignment.ama(ma1, ma1));
        System.out.println("sim=" + MultiAlignment.amaSim(ma1, ma1));
        System.out.println("ama(ma2,ma2)=" + MultiAlignment.ama(ma2, ma2));
        System.out.println("sim=" + MultiAlignment.amaSim(ma2, ma2));
    }

    public static MultiAlignment parse(String path) {
        MultiAlignment ma = null;
        try {
            ma = MultiAlignment.parseMSFToMultiAlignment(path);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (ma != null) {
            return ma;
        }
        try {
            ma = MultiAlignment.parseALNToMultiAlignment(path, "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ma != null) {
            return ma;
        }
        throw new RuntimeException();
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        MultiAlignment ma = null;
        try {
            ma = MultiAlignment.parseMSFToMultiAlignment(args[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (ma != null) {
            System.out.println(ma.toMSFString());
        }
        try {
            ma = MultiAlignment.parseALNToMultiAlignment(args[0], "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ma != null) {
            System.out.println(ma.toMSFString());
        } else {
            System.err.println("Could not read!");
        }
    }

    public static Counter<Integer> topGapLengthDistribution(MultiAlignment ma, Taxon top, Taxon bot, boolean useOnlyCoreBlocks) {
        Counter<Integer> result = new Counter<Integer>();
        DerivationTree.Derivation d = ma.getDerivation(top, bot);
        Integer prevCoreBlockAncestor = null;
        for (int botIndex = 0; botIndex < d.getCurrentWord().length(); ++botIndex) {
            if (useOnlyCoreBlocks && !ma.isCoreBlock(bot, botIndex)) {
                prevCoreBlockAncestor = null;
                continue;
            }
            if (!d.hasAncestor(botIndex)) continue;
            int ancestor = d.ancestor(botIndex);
            if (prevCoreBlockAncestor != null) {
                result.incrementCount(ancestor - prevCoreBlockAncestor, 1.0);
            }
            prevCoreBlockAncestor = ancestor;
        }
        return result;
    }

    public static Counter<Integer> gapLengthDistribution(MultiAlignment ma, boolean useOnlyCoreBlocks) {
        Counter<Integer> result = new Counter<Integer>();
        for (Taxon lang1 : ma.getSequences().keySet()) {
            for (Taxon lang2 : ma.getSequences().keySet()) {
                if (lang1.equals(lang2)) continue;
                result.incrementAll(MultiAlignment.topGapLengthDistribution(ma, lang1, lang2, useOnlyCoreBlocks));
            }
        }
        return result;
    }

    public static class ALN2MSF {
        public static void main(String[] args) throws IOException {
            MultiAlignment ma = MultiAlignment.parseALNToMultiAlignment(args[0], "");
            System.out.println(ma.createAlignmentMatrix().toMSFString());
        }
    }

    private static class Intervals {
        private final List<DerivationTree.Window> intervals = new ArrayList<DerivationTree.Window>();

        public Intervals(List<DerivationTree.Window> intervals) {
            this.intervals.addAll(intervals);
        }

        public boolean contains(int point) {
            for (DerivationTree.Window interval : this.intervals) {
                if (!interval.contains(point)) continue;
                return true;
            }
            return false;
        }

        public Collection<Integer> elements() {
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (DerivationTree.Window interval : this.intervals) {
                for (int i = interval.left(); i < interval.right(); ++i) {
                    result.add(i);
                }
            }
            return result;
        }
    }

    public static class CoreBlockSpecs {
        private final Taxon refNodeId;
        private final Intervals intervals;

        public CoreBlockSpecs(Taxon refNodeId, Intervals intervals) {
            if (refNodeId == null || intervals == null) {
                throw new RuntimeException("Illegal CoreBlockSpecs constr");
            }
            this.refNodeId = refNodeId;
            this.intervals = intervals;
        }
    }

    public static class MSFParser {
        private final Map<Taxon, String> msfAlignedData = new HashMap<Taxon, String>();
        private final CoreBlockSpecs coreBlockSpecs;
        private transient Taxon firstNode = null;
        private final String prefix;
        private boolean capitalize = true;
        public static final String BPOS_MATCH = "^BPOS\\s+([0-9]+[_=-][0-9]+\\s*|[0-9]+\\s*)+";
        public static final String INTERVALS_MATCH = "([0-9]+[_=-][0-9]+)";
        public static final String SELECT_LEFT = "([0-9]+)[_=-][0-9]+";
        public static final String SELECT_RIGHT = "[0-9]+[_=-]([0-9]+)";
        public static final String SELECT_SINGLE = "^\\s*[0-9]+\\s*$";

        public Map<Taxon, String> getUnalignedSequences() {
            return MultiAlignment.removeGaps(this.msfAlignedData);
        }

        public MultiAlignment constructMultiAlignment() {
            if (this.coreBlockSpecs == null) {
                return new MultiAlignment(this.msfAlignedData, null);
            }
            return new MultiAlignment(this.msfAlignedData, this.coreBlockSpecs);
        }

        private void addRow(Taxon nodeId, String suffixSequence) {
            String fullSequence = this.msfAlignedData.get(nodeId);
            if (fullSequence == null) {
                fullSequence = "";
            }
            fullSequence = fullSequence + suffixSequence;
            this.msfAlignedData.put(nodeId, fullSequence);
        }

        public MSFParser(BufferedReader fileReader) throws IOException {
            this(fileReader, null, "");
        }

        public MSFParser(BufferedReader fileReader, String annotationFile, String prefix) throws IOException {
            this.prefix = prefix;
            this.parseAlignmentFile(fileReader);
            this.coreBlockSpecs = this.parseAnnotationFile(annotationFile);
            this.checkConsistency();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseAlignmentFile(BufferedReader reader) throws IOException {
            try {
                boolean headerFinished = false;
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (!headerFinished && line.matches("^[/][/].*")) {
                        headerFinished = true;
                        continue;
                    }
                    if (line.matches("\\s*([0-9]+\\s*)+")) continue;
                    if (headerFinished && line.matches("^\\s*[^ ]*\\s+[a-zA-Z.~ ]+$")) {
                        this.processLine(line);
                        continue;
                    }
                    if (headerFinished && line.matches("\\s*") || !headerFinished) continue;
                    throw new RuntimeException("Bad line:" + line);
                }
            }
            finally {
                reader.close();
            }
        }

        private CoreBlockSpecs parseAnnotationFile(String annotationFile) throws IOException {
            if (annotationFile == null) {
                return null;
            }
            Intervals intervals = null;
            for (String line : IO.i(annotationFile)) {
                if (!line.matches(BPOS_MATCH)) continue;
                intervals = this.parseIntervals(line);
                break;
            }
            if (intervals == null) {
                throw new NoCoreBlockException();
            }
            return new CoreBlockSpecs(this.firstNode, intervals);
        }

        private Intervals parseIntervals(String line) {
            List<String> intervalStrs = StringUtils.selectRegex(INTERVALS_MATCH, line);
            ArrayList<DerivationTree.Window> intervals = new ArrayList<DerivationTree.Window>();
            for (String intervalStr : intervalStrs) {
                int right;
                int left;
                if (intervalStr.matches(SELECT_SINGLE)) {
                    right = left = Integer.parseInt(intervalStr);
                } else {
                    left = Integer.parseInt(StringUtils.selectRegex(SELECT_LEFT, intervalStr).get(0));
                    right = Integer.parseInt(StringUtils.selectRegex(SELECT_RIGHT, intervalStr).get(0));
                }
                if (left > right) continue;
                intervals.add(new DerivationTree.Window(left - 1, right + 1 - 1));
            }
            return new Intervals(intervals);
        }

        private void checkConsistency() {
            int length = -1;
            ArrayList<Taxon> incon = new ArrayList<Taxon>();
            for (Taxon lang : this.msfAlignedData.keySet()) {
                String sequence = this.msfAlignedData.get(lang);
                if (length == -1) {
                    length = sequence.length();
                    continue;
                }
                if (length == sequence.length()) continue;
                incon.add(lang);
            }
            if (incon.size() > 0) {
                throw new RuntimeException("Diff num of cols in: " + incon);
            }
            if (length == -1) {
                throw new NoSequenceException();
            }
        }

        private void processLine(String line) {
            String label = StringUtils.selectRegex("^\\s*([^ ]*)\\s+[a-zA-Z.~ ]+$", line).get(0);
            String contents = StringUtils.selectRegex("^\\s*[^ ]*\\s+([a-zA-Z.~ ]+)$", line).get(0);
            if (this.capitalize) {
                contents = contents.toUpperCase();
            }
            contents = contents.replaceAll("\\s", "");
            contents.replaceAll("[~]", ".");
            contents = this.clean(contents);
            this.addRow(new Taxon(this.prefix + label), contents);
            if (this.firstNode == null) {
                this.firstNode = new Taxon(this.prefix + label);
            }
        }

        private String clean(String contents) {
            Encodings enc = Encodings.getGlobalEncodings();
            if (enc == null) {
                return contents;
            }
            for (int i = 0; i < contents.length(); ++i) {
                if (this.valid(contents.charAt(i), enc)) continue;
                LogInfo.warning("Character not valid: " + contents.charAt(i) + "... replaced by gap");
                contents = MSFParser.replaceAt(contents, i, '.');
            }
            return contents;
        }

        private boolean valid(char c, Encodings enc) {
            if ((c = Character.toUpperCase(c)) == '.') {
                return true;
            }
            if (c == enc.boundChar()) {
                return false;
            }
            return enc.allChars().contains(Character.valueOf(c));
        }

        public static String replaceAt(String s, int i, char c) {
            return s.substring(0, i) + c + s.substring(i + 1, s.length());
        }

        public static class NoSequenceException
        extends RuntimeException {
        }

        public static class NoCoreBlockException
        extends RuntimeException {
        }
    }

    public static class MALossFunction
    implements BayesRiskMinimizer.LossFct<MultiAlignment> {
        private final boolean usePairs;

        public MALossFunction(boolean usePairs) {
            this.usePairs = usePairs;
        }

        @Override
        public double loss(MultiAlignment t1, MultiAlignment t2) {
            double result = 1.0 - (this.usePairs ? MultiAlignment.pairsF1(t1, t2) : MultiAlignment.columnsF1(t1, t2));
            if (result < 0.0 || result > 1.0) {
                throw new RuntimeException("Illegal loss fct in MALossFunction");
            }
            return result;
        }
    }

    private class SequenceStacks {
        private final Map<Taxon, Integer> stackIndices = new HashMap<Taxon, Integer>();
        private int nEltsLeft = 0;

        public String toString() {
            StringBuilder result = new StringBuilder();
            for (Taxon lang : this.stackIndices.keySet()) {
                result.append(lang.toString() + ":");
                String cWord = (String)MultiAlignment.this.words.get(lang);
                int index = this.stackIndices.get(lang);
                for (int pos = 0; pos < cWord.length(); ++pos) {
                    result.append((pos == index ? ">" : "") + cWord.charAt(pos));
                }
                result.append(" (" + this.nEltsLeft(lang) + " elts left)\n");
            }
            return result.toString();
        }

        public boolean isEqClassOnStackSurface(Set<SequenceCoordinate> coordinates) {
            for (SequenceCoordinate coord : coordinates) {
                int stackIndex = this.peakIndex(coord.getNodeIdentifier());
                int coordIndex = coord.indexInSequence();
                if (coordIndex < stackIndex) {
                    throw new RuntimeException();
                }
                if (coordIndex <= stackIndex) continue;
                return false;
            }
            return true;
        }

        private SequenceStacks() {
            for (Taxon lang : MultiAlignment.this.words.keySet()) {
                String cWord = (String)MultiAlignment.this.words.get(lang);
                this.nEltsLeft += cWord.length();
                this.stackIndices.put(lang, 0);
            }
        }

        public int nEltsLeft(Taxon lang) {
            return ((String)MultiAlignment.this.words.get(lang)).length() - this.stackIndices.get(lang);
        }

        public boolean isEmpty(Taxon lang) {
            return this.nEltsLeft(lang) == 0;
        }

        public Set<Taxon> findNonEmptyStacks() {
            HashSet<Taxon> result = new HashSet<Taxon>();
            for (Taxon lang : MultiAlignment.this.alignedNodes) {
                if (this.isEmpty(lang)) continue;
                result.add(lang);
            }
            return result;
        }

        public int peakIndex(Taxon lang) {
            return this.stackIndices.get(lang);
        }

        public void pop(Taxon lang) {
            if (this.nEltsLeft(lang) < 1) {
                throw new RuntimeException("Illegal state in pop");
            }
            int cIndex = this.peakIndex(lang);
            --this.nEltsLeft;
            this.stackIndices.put(lang, cIndex + 1);
        }

        public int nEltsLeft() {
            return this.nEltsLeft;
        }

        public boolean areEmpty() {
            return this.nEltsLeft == 0;
        }
    }

    public class LinearizedAlignmentMatrix {
        private final Map<Pair<Integer, Integer>, Character> linearizedAlignPoints = new HashMap<Pair<Integer, Integer>, Character>();
        private final Map<Integer, Boolean> coreBlockIndicators = new HashMap<Integer, Boolean>();
        private int nCols = -1;
        private String stringRep = null;
        public static final int LABEL_OFFSET = 16;

        private LinearizedAlignmentMatrix() {
        }

        private void addPoint(int row, int col, char character) {
            if (this.stringRep != null || this.nCols != -1) {
                throw new RuntimeException("Bad args in LinearizedAlignMatrix constr");
            }
            Pair<Integer, Integer> key = new Pair<Integer, Integer>(row, col);
            this.linearizedAlignPoints.put(key, Character.valueOf(character));
        }

        private void addPoint(int row, int col, char character, boolean isCoreBlock) {
            this.addPoint(row, col, character);
            this.coreBlockIndicators.put(col, isCoreBlock);
        }

        public Taxon langAt(int row) {
            return (Taxon)MultiAlignment.this.alignedNodes.get(row);
        }

        public String toString() {
            if (this.stringRep != null) {
                return this.stringRep;
            }
            StringBuilder builder = new StringBuilder();
            for (int cRow = 0; cRow < this.nRows(); ++cRow) {
                for (int cCol = 0; cCol < this.nCols(); ++cCol) {
                    builder.append(this.charAt(cRow, cCol));
                }
                builder.append("|" + ((Taxon)MultiAlignment.this.alignedNodes.get(cRow)).toString() + "\n");
            }
            if (this.coreBlockIndicators.size() > 0) {
                for (int cCol = 0; cCol < this.nCols(); ++cCol) {
                    Boolean indic = this.coreBlockIndicators.get(cCol);
                    if (indic.booleanValue()) {
                        builder.append("^");
                        continue;
                    }
                    if (!indic.booleanValue()) {
                        builder.append(" ");
                        continue;
                    }
                    throw new RuntimeException("Internal error in LinearizedAlignMatrix");
                }
            }
            this.stringRep = builder.toString();
            return this.stringRep;
        }

        public String toMSFString() {
            StringBuilder result = new StringBuilder();
            result.append("PileUp\n\n\n\n   MSF:  " + this.nCols() + "  Type: P    Check:  666   .. \n\n");
            for (Taxon lang : MultiAlignment.this.alignedNodes) {
                result.append(" Name: " + lang.toString() + " oo  Len:   " + this.nCols() + "  Check:  666  Weight:  1.00\n");
            }
            result.append("\n//\n\n\n\n");
            for (int cRow = 0; cRow < this.nRows(); ++cRow) {
                result.append((CharSequence)this.padNodeIdName((Taxon)MultiAlignment.this.alignedNodes.get(cRow), 16));
                for (int cCol = 0; cCol < this.nCols(); ++cCol) {
                    result.append(this.charAt(cRow, cCol));
                }
                result.append("\n");
            }
            result.append("\n\n\n");
            return result.toString();
        }

        private StringBuilder padNodeIdName(Taxon nodeId, int offSet) {
            StringBuilder result = new StringBuilder();
            String nodeIdStr = nodeId.toString();
            result.append(nodeIdStr);
            for (int i = 0; i < Math.max(1, offSet - nodeIdStr.length()); ++i) {
                result.append(" ");
            }
            return result;
        }

        private void checkConstistency() {
            for (int cRow = 0; cRow < this.nRows(); ++cRow) {
                String found;
                StringBuilder cString = new StringBuilder();
                for (int cCol = 0; cCol < this.nCols(); ++cCol) {
                    if (this.charAt(cRow, cCol) == '.') continue;
                    cString.append(this.charAt(cRow, cCol));
                }
                String expected = (String)MultiAlignment.this.words.get(MultiAlignment.this.alignedNodes.get(cRow));
                if (expected.equals(found = cString.toString())) continue;
                throw new RuntimeException("Expected: " + expected + ", found: " + found);
            }
        }

        public String substringWithoutGaps(Taxon lang, int leftIncl, int rightExcl) {
            int row = MultiAlignment.this.alignedNodes.indexOf(lang);
            StringBuilder result = new StringBuilder();
            for (int i = leftIncl; i < rightExcl; ++i) {
                char cur = this.charAt(row, i);
                if (cur == '.') continue;
                result.append(cur);
            }
            return result.toString();
        }

        public String stringWithGaps(Taxon lang, char gap) {
            int row = MultiAlignment.this.alignedNodes.indexOf(lang);
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.nCols(); ++i) {
                char cur = this.charAt(row, i);
                if (cur == '.') {
                    result.append(gap);
                    continue;
                }
                result.append(cur);
            }
            return result.toString();
        }

        public final char charAt(int row, int col) {
            if (row > this.nRows() || row < 0 || col > this.nCols() || col < 0) {
                throw new RuntimeException("Illegal arg in MA...charAt");
            }
            Character cChar = this.linearizedAlignPoints.get(new Pair<Integer, Integer>(row, col));
            if (cChar == null) {
                return '.';
            }
            return cChar.charValue();
        }

        public int nRows() {
            return MultiAlignment.this.alignedNodes.size();
        }

        public int nCols() {
            if (this.nCols != -1) {
                return this.nCols;
            }
            int result = Integer.MIN_VALUE;
            for (Pair<Integer, Integer> alignPoint : this.linearizedAlignPoints.keySet()) {
                int current = alignPoint.getSecond();
                if (current <= result) continue;
                result = current;
            }
            assert (++result > 0);
            this.nCols = result;
            return result;
        }
    }

    public class SequenceCoordinate
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Pair<Taxon, Integer> coordinates;
        private boolean isCoreBlock = true;

        private SequenceCoordinate(SequenceCoordinate model) {
            this.coordinates = new Pair<Taxon, Integer>(model.coordinates.getFirst(), model.coordinates.getSecond());
        }

        private SequenceCoordinate(Taxon nodeIdentifier, int indexInString) {
            this.coordinates = new Pair<Taxon, Integer>(nodeIdentifier, indexInString);
        }

        public boolean isCoreBlock() {
            if (!MultiAlignment.this.isReference) {
                throw new RuntimeException("Should not call isCoreBlock when isReference == false");
            }
            return this.isCoreBlock;
        }

        public Taxon getNodeIdentifier() {
            return this.coordinates.getFirst();
        }

        public int indexInSequence() {
            return this.coordinates.getSecond();
        }

        public char getCharValue() {
            return ((String)MultiAlignment.this.words.get(this.getNodeIdentifier())).charAt(this.indexInSequence());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof SequenceCoordinate)) {
                return false;
            }
            SequenceCoordinate o_cast = (SequenceCoordinate)o;
            return this.coordinates.equals(o_cast.coordinates);
        }

        public int hashCode() {
            return this.coordinates.hashCode();
        }

        public String toString() {
            return this.coordinates.toString();
        }
    }
}

