/*
 * Decompiled with CFR 0.152.
 */
package marking;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import fig.exec.Execution;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nuts.io.IO;
import nuts.math.StatisticsMap;
import nuts.tui.Table;
import nuts.util.CollUtils;
import nuts.util.Counter;
import nuts.util.CounterMap;
import nuts.util.MathUtils;

public class FinalGrade
implements Runnable {
    public static final String[] allLetterGrades = new String[]{"A+", "A", "A-", "B+", "B", "B-", "C+", "C", "<C"};
    @Option
    public double addition = 0.0;

    @Override
    public void run() {
        ArrayList<String> activities = CollUtils.list();
        Pair<Counter<String>, Counter<String>> scheme = this.readScheme(activities);
        Counter<String> weights = scheme.getFirst();
        CounterMap<String, String> grades = this.readGrades(scheme.getFirst().keySet(), scheme.getSecond());
        HashSet<String> students = CollUtils.set();
        for (String line : IO.i("final-student-ids.txt")) {
            if (line == null || line.length() <= 0) continue;
            students.add("s" + line);
        }
        Table table = new Table();
        StatisticsMap<String> sm = new StatisticsMap<String>();
        Counter<String> letterGradeCounter = new Counter<String>();
        table.set(0, 0, "student-id");
        int c = 1;
        for (String evalName : activities) {
            table.set(0, c++, evalName);
        }
        table.set(0, c, "final-grade");
        int r = 1;
        for (String sid : students) {
            double finalGrade = 0.0;
            table.set(r, 0, sid.substring(1));
            c = 1;
            for (String evalName : activities) {
                double currentScore = grades.getCount(sid, evalName);
                sm.addValue(evalName, currentScore);
                double weight = weights.getCount(evalName);
                finalGrade += currentScore * weight;
                table.set(r, c++, currentScore);
            }
            table.set(r, c, finalGrade += this.addition);
            sm.addValue("final-grade", finalGrade);
            String letterGrade = FinalGrade.letterGrade(finalGrade);
            letterGradeCounter.incrementCount(letterGrade, 1.0);
            table.set(r, c + 1, letterGrade);
            ++r;
        }
        c = 1;
        for (String evalName : activities) {
            double currentScore = sm.getSummaryStat(evalName).getMean();
            table.set(r, c++, currentScore);
        }
        table.set(r, c, sm.getSummaryStat("final-grade").getMean());
        LogInfo.logs(table.toString());
        letterGradeCounter.normalize();
        LogInfo.track((Object)"Histogram", true);
        for (String letterGrade : allLetterGrades) {
            LogInfo.logs(letterGrade + "\t" + letterGradeCounter.getCount(letterGrade));
        }
        LogInfo.end_track();
    }

    public static String letterGrade(double finalGrade) {
        if (finalGrade >= 0.9) {
            return allLetterGrades[0];
        }
        if (finalGrade >= 0.85) {
            return allLetterGrades[1];
        }
        if (finalGrade >= 0.8) {
            return allLetterGrades[2];
        }
        if (finalGrade >= 0.76) {
            return allLetterGrades[3];
        }
        if (finalGrade >= 0.72) {
            return allLetterGrades[4];
        }
        if (finalGrade >= 0.68) {
            return allLetterGrades[5];
        }
        if (finalGrade >= 0.64) {
            return allLetterGrades[6];
        }
        if (finalGrade >= 0.6) {
            return allLetterGrades[7];
        }
        return allLetterGrades[8];
    }

    private CounterMap<String, String> readGrades(Set<String> keySet, Counter<String> norms) {
        CounterMap<String, String> result = new CounterMap<String, String>();
        for (String activityName : keySet) {
            File curGradeDir = new File(activityName, "marked");
            File curGradeFile = new File(curGradeDir, "grades.csv");
            double currentNorm = norms.getCount(activityName);
            if (currentNorm == 0.0) {
                throw new RuntimeException();
            }
            for (List<String> line : IO.iCSV(curGradeFile)) {
                String sid;
                if (line.size() <= 0 || line.get(0).length() <= 0 || line.get(0).charAt(0) == '#' || (sid = line.get(0)) == null || sid.equals("")) continue;
                String scoreField = line.get(line.size() - 1);
                double score = 0.0;
                try {
                    score = Double.parseDouble(scoreField);
                }
                catch (Exception e) {
                    // empty catch block
                }
                result.setCount(sid, activityName, score /= currentNorm);
            }
        }
        return result;
    }

    private Pair<Counter<String>, Counter<String>> readScheme(List<String> activities) {
        File schemeFile = new File("grading-scheme.csv");
        File backup = new File(Execution.getFile("grading-scheme.txt.bu"));
        IO.cp(schemeFile, backup);
        Counter<String> weights = new Counter<String>();
        Counter<String> norms = new Counter<String>();
        for (Map<String, String> line : IO.iCSVMap(schemeFile)) {
            String evaluationName = line.get("evaluationName");
            activities.add(evaluationName);
            double weight = Double.parseDouble(line.get("weight"));
            double norm = Double.parseDouble(line.get("norm"));
            if (weights.containsKey(evaluationName)) {
                throw new RuntimeException();
            }
            weights.setCount(evaluationName, weight);
            norms.setCount(evaluationName, norm);
        }
        double totalCount = weights.totalCount();
        if (!MathUtils.close(1.0, totalCount)) {
            LogInfo.warning("Counts are not normalized!");
        }
        weights.normalize();
        LogInfo.track((Object)"Scheme", true);
        for (String key : weights) {
            LogInfo.logs("" + key + "\t" + weights.getCount(key));
        }
        LogInfo.end_track();
        return Pair.makePair(weights, norms);
    }

    public static void main(String[] args) {
        IO.run(args, new FinalGrade());
    }
}

