/*
 * Decompiled with CFR 0.152.
 */
package nuts.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class TestDb {
    Connection conn;

    public TestDb(String db_file_name_prefix) throws Exception {
        Class.forName("org.hsqldb.jdbcDriver");
        this.conn = DriverManager.getConnection("jdbc:hsqldb:" + db_file_name_prefix, "sa", "");
    }

    public void shutdown() throws SQLException {
        Statement st = this.conn.createStatement();
        st.execute("SHUTDOWN");
        this.conn.close();
    }

    public synchronized void query(String expression) throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        st = this.conn.createStatement();
        rs = st.executeQuery(expression);
        TestDb.dump(rs);
        st.close();
    }

    public synchronized void update(String expression) throws SQLException {
        Statement st = null;
        st = this.conn.createStatement();
        int i = st.executeUpdate(expression);
        if (i == -1) {
            System.out.println("db error : " + expression);
        }
        st.close();
    }

    public static void dump(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int colmax = meta.getColumnCount();
        Object o = null;
        while (rs.next()) {
            for (int i = 0; i < colmax; ++i) {
                o = rs.getObject(i + 1);
                System.out.print(o.toString() + " ");
            }
            System.out.println(" ");
        }
    }

    public static void main(String[] args) {
        TestDb db = null;
        try {
            db = new TestDb("db_file");
        }
        catch (Exception ex1) {
            ex1.printStackTrace();
            return;
        }
        try {
            db.update("CREATE TABLE sample_table ( id INTEGER IDENTITY, str_col VARCHAR(256), num_col INTEGER)");
        }
        catch (SQLException ex2) {
            // empty catch block
        }
        try {
            db.update("INSERT INTO sample_table(str_col,num_col) VALUES('Ford', 100)");
            db.update("INSERT INTO sample_table(str_col,num_col) VALUES('Toyota', 200)");
            db.update("INSERT INTO sample_table(str_col,num_col) VALUES('Honda', 300)");
            db.update("INSERT INTO sample_table(str_col,num_col) VALUES('GM', 400)");
            db.query("SELECT * FROM sample_table WHERE num_col < 250");
            db.shutdown();
        }
        catch (SQLException ex3) {
            ex3.printStackTrace();
        }
    }
}

