/*
 * Decompiled with CFR 0.152.
 */
package nuts.lang;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import nuts.io.IteratorWrapper;

public class ProductIterator<T>
implements Iterator<List<T>> {
    private List<? extends Iterator<T>> iterators;

    public ProductIterator(List<? extends Iterator<T>> iterators) {
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        boolean numberOfIteratorsWithHasNextEqualTrue = false;
        boolean numberOfIteratorsWithHasNextEqualFalse = false;
        for (Iterator<T> iterator : this.iterators) {
            if (iterator.hasNext()) {
                numberOfIteratorsWithHasNextEqualTrue = true;
                if (!numberOfIteratorsWithHasNextEqualFalse) continue;
                throw new UnmatchingProductIterandLengths();
            }
            numberOfIteratorsWithHasNextEqualFalse = true;
            if (!numberOfIteratorsWithHasNextEqualTrue) continue;
            throw new UnmatchingProductIterandLengths();
        }
        return numberOfIteratorsWithHasNextEqualTrue;
    }

    @Override
    public List<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ArrayList<T> items = new ArrayList<T>();
        for (Iterator<T> iterator : this.iterators) {
            items.add(iterator.next());
        }
        return items;
    }

    @Override
    public void remove() {
        for (Iterator<T> i : this.iterators) {
            i.remove();
        }
    }

    public static void main(String[] args) {
        ArrayList<String> l1 = new ArrayList<String>();
        l1.add("a");
        l1.add("b");
        l1.add("scrap");
        ArrayList<String> l2 = new ArrayList<String>();
        l2.add("1");
        l2.add("2");
        l2.add("moresfds");
        ArrayList list = new ArrayList();
        list.add(l1.iterator());
        list.add(l2.iterator());
        ProductIterator prodIt = new ProductIterator(list);
        for (List curr : IteratorWrapper.IW(prodIt)) {
            System.out.println(curr);
        }
    }

    public static class UnmatchingProductIterandLengths
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnmatchingProductIterandLengths() {
            super("The iterators have a different number of items.");
        }
    }
}

