/*
 * Decompiled with CFR 0.152.
 */
package nuts.tools;

import fig.basic.IOUtils;
import fig.basic.Option;
import fig.basic.OptionsParser;
import fig.exec.Execution;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import nuts.io.IO;

public class BiDiff {
    @Option(gloss="Give 2 files to process... keep only the line where they differ.", required=true)
    public static ArrayList<String> files;

    public static void main(String[] args) throws IOException {
        OptionsParser.register("bidiff", BiDiff.class);
        Execution.init(args, new Object[0]);
        if (files.size() != 2) {
            throw new RuntimeException("Give exactly 2 files to process");
        }
        ArrayList<PrintWriter> outs = new ArrayList<PrintWriter>();
        for (String file : files) {
            outs.add(IOUtils.openOut(file + ".bidiff"));
        }
        String[] paths = new String[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            String path;
            paths[i] = path = files.get(i);
        }
        for (List<String> lines : IO.i(paths)) {
            if (lines.get(0).equals(lines.get(1))) continue;
            for (int i = 0; i < files.size(); ++i) {
                ((PrintWriter)outs.get(i)).append(lines.get(i) + "\n");
            }
        }
        for (PrintWriter out : outs) {
            out.close();
        }
        Execution.finish();
    }
}

