/*
 * Decompiled with CFR 0.152.
 */
package nuts.tools;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import nuts.io.IO;
import nuts.tools.RecursiveModificationDate;
import nuts.tui.Utils;
import nuts.util.CollUtils;
import nuts.util.RemoteUtils;

public class Sync
implements Runnable {
    @Option
    public String ignoreFile = "/Users/bouchard/Documents/Dropbox/.syncignore";
    @Option
    public boolean laptop2desktop = true;
    private RecursiveModificationDate.FileExclusions exclusions;
    @Option
    public boolean expeditive = false;

    public static void main(String[] args) {
        IO.run(args, new Sync());
    }

    @Override
    public void run() {
        String dest;
        PrintWriter rawLog = IOUtils.openOutHard(Execution.getFile("rawLog"));
        File check = new File("/Users/bouchard/.islap");
        if (!check.exists()) {
            throw new RuntimeException("Must ran on laptop");
        }
        String directionStr = this.laptop2desktop ? "LAP -> DESK" : "DESK -> LAP";
        LogInfo.logs("Current direction: " + directionStr);
        String string = dest = this.laptop2desktop ? "DESK" : "LAP";
        if (!this.expeditive) {
            RSyncCaller dryUp = new RSyncCaller(true, true, false);
            RSyncCaller dryNoUp = new RSyncCaller(false, true, false);
            LogInfo.track("Additions to " + dest + ":");
            StringBuilder temp = new StringBuilder();
            for (String str : dryUp.added) {
                temp.append("ADD TO " + dest + " " + str + "\n");
            }
            rawLog.append(temp.toString());
            LogInfo.logsForce(temp);
            LogInfo.end_track();
            HashSet bigSet = CollUtils.set(dryNoUp.added);
            HashSet smallSet = CollUtils.set(dryUp.added);
            HashSet notAdded = CollUtils.set(bigSet);
            notAdded.removeAll(smallSet);
            ArrayList<String> sorted = CollUtils.list(notAdded);
            Collections.sort(sorted);
            LogInfo.track("Skipped:");
            temp = new StringBuilder();
            for (String str : sorted) {
                temp.append("SKIP " + str + "\n");
            }
            LogInfo.logsForce(temp);
            rawLog.append(temp.toString());
            LogInfo.end_track();
            LogInfo.track("Deletions from " + dest);
            temp = new StringBuilder();
            for (String str : dryNoUp.deleted) {
                temp.append("DEL FROM " + dest + " " + str + "\n");
            }
            LogInfo.logsForce(temp);
            rawLog.append(temp.toString());
            LogInfo.end_track();
        } else {
            LogInfo.logsForce("MAKE SURE THIS IS CORRECT: ***** " + directionStr + " *****");
        }
        rawLog.flush();
        rawLog.close();
        if (!"y".equals(Utils.hardPrompt("Confirm " + directionStr + " (includ. del. of prev. " + dest + " backup)? [y/n] "))) {
            return;
        }
        String host = this.laptop2desktop ? "leonov.stat.ubc.ca" : "localhost";
        String budir = "/Users/bouchard/.syncbackup";
        RemoteUtils.remoteBash(host, Arrays.asList("mkdir " + budir, "rm -r " + budir));
        RSyncCaller real = new RSyncCaller(true, false, false);
        if (this.expeditive) {
            LogInfo.track("Additions to " + dest + ":");
            StringBuilder temp = new StringBuilder();
            for (String str : real.added) {
                temp.append("ADD TO " + dest + " " + str + "\n");
            }
            rawLog.append(temp.toString());
            LogInfo.logsForce(temp);
            LogInfo.end_track();
            LogInfo.track("Deletions from " + dest);
            temp = new StringBuilder();
            for (String str : real.deleted) {
                temp.append("DEL FROM " + dest + " " + str + "\n");
            }
            LogInfo.logsForce(temp);
            rawLog.append(temp.toString());
            LogInfo.end_track();
        }
    }

    private class RSyncCaller {
        private String resultStr;
        private List<String> deleted = CollUtils.list();
        private List<String> added = CollUtils.list();

        private RSyncCaller(boolean update, boolean dryRun, boolean hack) {
            StringBuilder rsyncOptions = new StringBuilder();
            if (update) {
                rsyncOptions.append("--update ");
            }
            if (dryRun) {
                rsyncOptions.append("--dry-run ");
            }
            rsyncOptions.append("-t ");
            if (hack) {
                rsyncOptions.append("-E ");
            }
            rsyncOptions.append("--verbose ");
            rsyncOptions.append("--rsh=/usr/bin/ssh ");
            rsyncOptions.append("--recursive ");
            rsyncOptions.append("--links ");
            rsyncOptions.append("--perms ");
            rsyncOptions.append("--group ");
            rsyncOptions.append("--delete-after ");
            rsyncOptions.append("--backup ");
            rsyncOptions.append("--backup-dir=/Users/bouchard/.syncbackup/ ");
            rsyncOptions.append("--exclude-from=" + Sync.this.ignoreFile + " ");
            String subdir = hack ? "/Documents/bin/Excalibur-4.0.7" : "";
            if (!(subdir.equals("") || subdir.charAt(0) == '/' && subdir.charAt(subdir.length() - 1) != '/')) {
                throw new RuntimeException();
            }
            rsyncOptions.append((Sync.this.laptop2desktop ? "" : "leonov.stat.ubc.ca:") + "/Users/bouchard/" + subdir + "/ ");
            rsyncOptions.append((Sync.this.laptop2desktop ? "leonov.stat.ubc.ca:" : "") + "/Users/bouchard" + subdir);
            String cmd = "rsync " + rsyncOptions;
            this.resultStr = IO.call(cmd);
            boolean first = true;
            for (String line : this.resultStr.split("\n")) {
                if (first) {
                    first = false;
                    continue;
                }
                if (line.matches("^\\s*$")) continue;
                if (line.matches("^deleting .*")) {
                    this.deleted.add(line.substring(9));
                    continue;
                }
                if (line.matches("^sent .*") || line.matches("^total .*")) continue;
                this.added.add(line);
            }
        }
    }
}

