/*
 * Decompiled with CFR 0.152.
 */
package pedi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import pedi.BiAllelicDiploidGenotype;
import pedi.Genotype;
import pedi.Individual;
import pedi.factor.FactorEncodings;

public class Genotypes {
    private Map<Individual, Genotype> genotypes = new HashMap<Individual, Genotype>();
    private Map<Individual, Genotype> heldout = new HashMap<Individual, Genotype>();
    private FactorEncodings enc = null;
    private int genomeSize = -1;
    private Random ran = new Random(1L);

    public Collection<Individual> heldoutIndividuals() {
        return this.heldout.keySet();
    }

    public Genotype getHeldoutGenotype(Individual i) {
        return this.heldout.get(i);
    }

    public void holdout(Individual i) {
        Genotype g = this.genotypes.get(i);
        if (g == null) {
            throw new RuntimeException();
        }
        this.genotypes.remove(i);
        this.heldout.put(i, g);
    }

    public Genotype getGenotype(Individual i) {
        Genotype result = this.genotypes.get(i);
        if (result != null && result.getInheritanceEncodings() != this.enc) {
            throw new RuntimeException("Genotypes assumes all genotypes use the same encodings");
        }
        return result;
    }

    public Collection<Individual> genotypedIndividuals() {
        return this.genotypes.keySet();
    }

    public int genomeSize() {
        return this.genomeSize;
    }

    public void putBiAllelicDiploidGenotype(Individual individual, ArrayList<Integer> alleles) {
        boolean hasInfo = false;
        for (int i : alleles) {
            if (i != 0 && i != 1 && i != 2) {
                throw new RuntimeException();
            }
            if (i == 0) continue;
            hasInfo = true;
        }
        int currentSize = alleles.size() / 2;
        if (this.genomeSize == -1) {
            this.genomeSize = currentSize;
        } else if (this.genomeSize != currentSize) {
            throw new RuntimeException();
        }
        if (hasInfo) {
            BiAllelicDiploidGenotype badg = new BiAllelicDiploidGenotype(alleles);
            this.genotypes.put(individual, badg);
            FactorEncodings currentEncs = badg.getInheritanceEncodings();
            if (this.enc == null) {
                this.enc = currentEncs;
            } else if (this.enc != currentEncs) {
                throw new RuntimeException();
            }
        }
    }

    public FactorEncodings getFactorEncodings() {
        return this.enc;
    }

    public void removeEvenMarkers() {
        for (Individual i : this.genotypes.keySet()) {
            ((BiAllelicDiploidGenotype)this.genotypes.get(i)).removeEvenMarkers();
        }
    }

    public void setHiddenMarkersToOne(int exception) {
        for (Individual i : this.genotypes.keySet()) {
            ((BiAllelicDiploidGenotype)this.genotypes.get(i)).setHiddenMarkersToOne(exception);
        }
    }

    public double[] getFrequenciesOfZeroes() {
        double[] sum = new double[this.genomeSize()];
        for (Individual i : this.genotypes.keySet()) {
            BiAllelicDiploidGenotype cGenome = (BiAllelicDiploidGenotype)this.genotypes.get(i);
            for (int index = 0; index < this.genomeSize(); ++index) {
                for (int chr = 0; chr < 2; ++chr) {
                    int n = index;
                    sum[n] = sum[n] + (double)(cGenome.getHeldoutHaplotype(index, chr) == 0 ? 1 : 0);
                }
            }
        }
        for (int index = 0; index < this.genomeSize(); ++index) {
            sum[index] = sum[index] / (2.0 * (double)this.genotypes.keySet().size());
        }
        return sum;
    }
}

