/*
 * Decompiled with CFR 0.152.
 */
package pedi.tests;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import fig.basic.IOUtils;
import fig.basic.UnorderedPair;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import nuts.io.IO;
import nuts.util.CollUtils;
import nuts.util.Counter;
import nuts.util.Indexer;
import pedi.Individual;
import pedi.Pedigree;
import pedi.PedigreeUtils;
import pedi.RegularPedigree;
import pedi.io.PedigreeFileReader;
import pedi.tests.Node;

public class InvestigateQcPedigree
implements Runnable {
    public static CIBD sampleCIBD(Pedigree p, List<Individual> is, Random rand) {
        if (is.size() != 2) {
            throw new RuntimeException();
        }
        List<Node> nodes = InvestigateQcPedigree.nodes(is);
        List<List<Node>> paths = InvestigateQcPedigree.generateBackwardPaths(rand, p, nodes);
        HashSet links = Sets.newHashSet();
        for (int i = 0; i < paths.size(); ++i) {
            for (int j = i + 1; j < paths.size(); ++j) {
                if (!InvestigateQcPedigree.isIBD(paths.get(i), paths.get(j))) continue;
                links.add(new UnorderedPair<Node, Node>(nodes.get(i), nodes.get(j)));
            }
        }
        return InvestigateQcPedigree.condensedFromIBD(links, is);
    }

    private static List<Node> nodes(List<Individual> is) {
        ArrayList result = Lists.newArrayListWithCapacity((int)8);
        for (Individual i : is) {
            for (int chr = 0; chr < 2; ++chr) {
                result.add(new Node(i, chr));
            }
        }
        return result;
    }

    public static CIBD condensedFromIBD(Set<UnorderedPair<Node, Node>> links, List<Individual> is) {
        int[] indivLinks = new int[2];
        int across = 0;
        for (UnorderedPair<Node, Node> edge : links) {
            int i1idx;
            int i0idx = is.indexOf(edge.getFirst().i);
            if (i0idx == (i1idx = is.indexOf(edge.getSecond().i))) {
                int n = i0idx;
                indivLinks[n] = indivLinks[n] + 1;
                continue;
            }
            ++across;
        }
        return new CIBD(indivLinks[0], across, indivLinks[1]);
    }

    public static void main(String[] args) {
        IO.run(args, new InvestigateQcPedigree());
    }

    @Override
    public void run() {
        PedigreeFileReader reader = new PedigreeFileReader();
        reader.read(new File("/Users/bouchard/Documents/data/quebecPedigree/justGenealogy.ped"));
        RegularPedigree p = RegularPedigree.getRegularPedigree(reader.getPedigree());
        List<Pedigree> ccs = PedigreeUtils.connectedSubpedigrees(p);
        Ordering<Pedigree> order = new Ordering<Pedigree>(){

            public int compare(Pedigree arg0, Pedigree arg1) {
                return arg0.individuals().size() - arg1.individuals().size();
            }
        };
        p = RegularPedigree.getRegularPedigree((Pedigree)order.max(ccs));
        List leaves = Ordering.usingToString().sortedCopy(p.leaves());
        Collections.shuffle(leaves);
        Random rand = new Random(1L);
        Indexer<CIBD> indexer = CIBD.cibdIndexer();
        PrintWriter out = IOUtils.openOutHard(Execution.getFile("cibds.txt"));
        for (int c = 0; c < leaves.size(); ++c) {
            for (int c2 = c + 1; c2 < leaves.size(); ++c2) {
                ArrayList sublist = Lists.newArrayList();
                sublist.add(leaves.get(c));
                sublist.add(leaves.get(c2));
                Counter<CIBD> counts = new Counter<CIBD>();
                for (int rep = 0; rep < 1000000; ++rep) {
                    CIBD cur = InvestigateQcPedigree.sampleCIBD(p, sublist, rand);
                    counts.incrementCount(cur, 1.0);
                }
                counts.normalize();
                out.println("CIBD of " + sublist);
                for (CIBD cibd : counts) {
                    out.println(cibd + "\t" + counts.getCount(cibd));
                }
                out.println();
            }
        }
        out.close();
    }

    public static boolean isIBD(List<Node> path1, List<Node> path2) {
        return CollUtils.last(path1).equals(CollUtils.last(path2));
    }

    public static List<List<Node>> generateBackwardPaths(Random rand, Pedigree p, List<Node> individuals) {
        ArrayList result = Lists.newArrayListWithCapacity((int)individuals.size());
        HashMap sampledParentalChr = Maps.newHashMap();
        for (Node i : individuals) {
            ArrayList path = Lists.newArrayList();
            InvestigateQcPedigree.generateBackwardPath(rand, p, i, sampledParentalChr, path);
            result.add(path);
        }
        return result;
    }

    public static void generateBackwardPath(Random rand, Pedigree p, Node n, Map<Node, Integer> sampledParentalChr, List<Node> result) {
        result.add(n);
        Individual parent = p.parent(n.i, n.chr);
        if (parent != null) {
            int parentChr;
            boolean alreadySampled = sampledParentalChr.containsKey(n);
            int n2 = parentChr = alreadySampled ? sampledParentalChr.get(n).intValue() : rand.nextInt(2);
            if (!alreadySampled) {
                sampledParentalChr.put(n, parentChr);
            }
            InvestigateQcPedigree.generateBackwardPath(rand, p, new Node(parent, parentChr), sampledParentalChr, result);
        }
    }

    public static class CIBD {
        public final int firstIndivLink;
        public final int acrossIndivLinks;
        public final int secondIndivLink;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.acrossIndivLinks;
            result = 31 * result + this.firstIndivLink;
            result = 31 * result + this.secondIndivLink;
            return result;
        }

        public static Indexer<CIBD> cibdIndexer() {
            Indexer<CIBD> result = new Indexer<CIBD>();
            result.addToIndex(new CIBD(1, 4, 1));
            result.addToIndex(new CIBD(1, 2, 0));
            result.addToIndex(new CIBD(0, 2, 1));
            result.addToIndex(new CIBD(1, 0, 1));
            result.addToIndex(new CIBD(0, 2, 0));
            result.addToIndex(new CIBD(1, 0, 0));
            result.addToIndex(new CIBD(0, 0, 1));
            result.addToIndex(new CIBD(0, 1, 0));
            result.addToIndex(new CIBD(0, 0, 0));
            return result;
        }

        public CIBD(int firstIndivLink, int acrossIndivLinks, int secondIndivLink) {
            if (firstIndivLink > 1 || secondIndivLink > 1) {
                throw new RuntimeException();
            }
            if (acrossIndivLinks > 4) {
                throw new RuntimeException();
            }
            this.firstIndivLink = firstIndivLink;
            this.acrossIndivLinks = acrossIndivLinks;
            this.secondIndivLink = secondIndivLink;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CIBD other = (CIBD)obj;
            if (this.acrossIndivLinks != other.acrossIndivLinks) {
                return false;
            }
            if (this.firstIndivLink != other.firstIndivLink) {
                return false;
            }
            return this.secondIndivLink == other.secondIndivLink;
        }

        public String toString() {
            return "CIBD[firstIndivLink=" + this.firstIndivLink + ", acrossIndivLinks=" + this.acrossIndivLinks + ", secondIndivLink=" + this.secondIndivLink + "]";
        }
    }
}

