/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel;

import fig.basic.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import nuts.util.Counter;
import nuts.util.EasyFormat;
import pepper.Edit;
import pepper.Encodings;
import pepper.editmodel.EditParam;
import pepper.editmodel.EditSampler;

public class ConstrainedEditMDParametrization
implements EditSampler.EditMultiDirichletParametrization {
    private static final long serialVersionUID = 1L;
    private final Encodings enc;
    private final List<Edit> allowedRules;
    private List<Edit>[][][] organizedRules;
    private double[][][][] parameters;
    private List<Pair<Pair<Integer, Integer>, Integer>> indices = new ArrayList<Pair<Pair<Integer, Integer>, Integer>>();
    private static double PRINT_CUTOFF = 0.01;

    private int NC() {
        return this.enc.getNumberOfEqClasses();
    }

    private int A() {
        return this.enc.getNumberOfPhonemes();
    }

    public ConstrainedEditMDParametrization(Encodings enc, List<Edit> allowedRules) {
        this.enc = enc;
        assert (new HashSet<Edit>(allowedRules).size() == allowedRules.size());
        this.allowedRules = allowedRules;
        this.organizedRules = new ArrayList[this.NC()][this.A()][this.NC()];
        for (Edit edit : allowedRules) {
            if (edit.isSelfSubstitution()) continue;
            if (this.organizedRules[edit.c1][edit.x][edit.c2] == null) {
                this.organizedRules[edit.c1][edit.x][edit.c2] = new ArrayList<Edit>();
                this.addIndices(edit.c1, edit.x, edit.c2);
            }
            this.organizedRules[edit.c1][edit.x][edit.c2].add(edit);
        }
        this.parameters = new double[this.NC()][this.A()][this.NC()][];
        for (Pair pair : this.indices) {
            int numberOfParametersNeeded = this.organizedRules[this.getC1(pair)][this.getX(pair)][this.getC2(pair)].size() + 1;
            double[] currentParam = new double[numberOfParametersNeeded];
            this.parameters[this.getC1((Pair<Pair<Integer, Integer>, Integer>)pair)][this.getX((Pair<Pair<Integer, Integer>, Integer>)pair)][this.getC2((Pair<Pair<Integer, Integer>, Integer>)pair)] = currentParam;
        }
    }

    public ConstrainedEditMDParametrization(Encodings enc, List<Edit> allowedRules, double alpha_id, double alpha_edit, boolean projected) {
        this(enc, allowedRules);
        for (Pair<Pair<Integer, Integer>, Integer> index : this.indices) {
            double[] currentParam = this.parameters[this.getC1(index)][this.getX(index)][this.getC2(index)];
            for (int i = 0; i < currentParam.length - 1; ++i) {
                currentParam[i] = projected ? alpha_edit / ((double)currentParam.length - 1.0) : alpha_edit;
            }
            currentParam[currentParam.length - 1] = alpha_id;
        }
    }

    @Override
    public EditParam getEditParameters() {
        double[][][] deletionCosts = new double[this.NC()][this.A()][this.NC()];
        double[][][][] substitutionCosts = new double[this.NC()][this.A()][this.NC()][this.A()];
        double[][][][][] fissionCosts = new double[this.NC()][this.A()][this.NC()][this.A()][this.A()];
        for (int c1 = 0; c1 < this.NC(); ++c1) {
            for (int x = 0; x < this.A(); ++x) {
                for (int c2 = 0; c2 < this.NC(); ++c2) {
                    if (this.organizedRules[c1][x][c2] == null) {
                        substitutionCosts[c1][x][c2][x] = 1.0;
                        continue;
                    }
                    int I = this.parameters[c1][x][c2].length;
                    substitutionCosts[c1][x][c2][x] = this.parameters[c1][x][c2][I - 1];
                    for (int i = 0; i < this.organizedRules[c1][x][c2].size(); ++i) {
                        Edit currentEdit = this.organizedRules[c1][x][c2].get(i);
                        double currentParam = this.parameters[c1][x][c2][i];
                        if (currentEdit.isDeletion()) {
                            deletionCosts[c1][x][c2] = currentParam;
                            continue;
                        }
                        if (currentEdit.isSubstitution()) {
                            substitutionCosts[c1][x][c2][currentEdit.y] = currentParam;
                            continue;
                        }
                        if (!currentEdit.isFission()) continue;
                        fissionCosts[c1][x][c2][currentEdit.y][currentEdit.z] = currentParam;
                    }
                }
            }
        }
        return new EditParam(this.enc, deletionCosts, substitutionCosts, fissionCosts);
    }

    @Override
    public double[] getParameters(int distributionIndex) {
        return this.parameters[this.getC1(distributionIndex)][this.getX(distributionIndex)][this.getC2(distributionIndex)];
    }

    @Override
    public EditSampler.EditMultiDirichletParametrization newInstance(Counter<Edit> edits) {
        ConstrainedEditMDParametrization result = new ConstrainedEditMDParametrization(this.enc, this.allowedRules);
        for (Edit edit : edits) {
            double count = edits.getCount(edit);
            if (edit.isSelfSubstitution()) {
                if (result.organizedRules[edit.c1][edit.x][edit.c2] == null) continue;
                int I = this.parameters[edit.c1][edit.x][edit.c2].length;
                result.parameters[edit.c1][edit.x][edit.c2][I - 1] = count;
                continue;
            }
            if (!result.allowedRules.contains(edit)) continue;
            List<Edit> editsWithSameContext = result.organizedRules[edit.c1][edit.x][edit.c2];
            int indexInsideDist = editsWithSameContext.indexOf(edit);
            result.parameters[edit.c1][edit.x][edit.c2][indexInsideDist] = count;
        }
        return result;
    }

    @Override
    public int numberOfDistribution() {
        return this.indices.size();
    }

    @Override
    public void setParameters(int distributionIndex, double[] parameters) {
        this.parameters[this.getC1((int)distributionIndex)][this.getX((int)distributionIndex)][this.getC2((int)distributionIndex)] = parameters;
    }

    private int getC1(int distIndex) {
        return this.getC1(this.indices.get(distIndex));
    }

    private int getC1(Pair<Pair<Integer, Integer>, Integer> index) {
        return index.getFirst().getFirst();
    }

    private int getX(int distIndex) {
        return this.getX(this.indices.get(distIndex));
    }

    private int getX(Pair<Pair<Integer, Integer>, Integer> index) {
        return index.getFirst().getSecond();
    }

    private int getC2(Pair<Pair<Integer, Integer>, Integer> index) {
        return index.getSecond();
    }

    private int getC2(int distIndex) {
        return this.getC2(this.indices.get(distIndex));
    }

    private void addIndices(int c1, int x, int c2) {
        this.indices.add(new Pair<Pair<Integer, Integer>, Integer>(new Pair<Integer, Integer>(c1, x), c2));
    }

    public String toString() {
        return this.toString(PRINT_CUTOFF);
    }

    public String toString(double cutoff) {
        StringBuilder result = new StringBuilder();
        Encodings globalEnc = this.enc;
        for (Pair<Pair<Integer, Integer>, Integer> index : this.indices) {
            String env = globalEnc.getEqClassDescription(this.getC1(index)) + " " + globalEnc.phoneId2Char(this.getX(index)) + " " + globalEnc.getEqClassDescription(this.getC2(index));
            result.append("In the env. " + env + "\n");
            double[] currentParam = this.parameters[this.getC1(index)][this.getX(index)][this.getC2(index)];
            Counter<String> weights = new Counter<String>();
            weights.incrementCount(new Edit(this.enc, this.getC1(index), this.getX(index), this.getC2(index), this.getX(index)).toString(), currentParam[currentParam.length - 1]);
            for (int i = 0; i < currentParam.length - 1; ++i) {
                Edit currentEdit = this.organizedRules[this.getC1(index)][this.getX(index)][this.getC2(index)].get(i);
                weights.incrementCount(currentEdit.toString(), currentParam[i]);
            }
            for (String key : weights) {
                double currentWeigth = weights.getCount(key);
                if (!(currentWeigth > PRINT_CUTOFF)) continue;
                result.append("\t" + key + " : " + EasyFormat.std(weights.getCount(key)) + "\n");
            }
        }
        return result.toString();
    }
}

