/*
 * Decompiled with CFR 0.152.
 */
package pty.io;

import goblin.Taxon;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import ma.MSAPoset;
import ma.SequenceType;
import nuts.util.Indexer;
import pty.ObservationDimensions;
import pty.Observations;
import pty.io.GeneratedDataset;
import pty.io.HGDPDataset;
import pty.io.WalsDataset;

public interface Dataset
extends Observations {
    public static final int unknownCode = -1;

    public boolean hasReferenceClusters();

    public Map<Taxon, String> getReferenceClusters();

    public static class DatasetUtils {
        public static Dataset fromAlignment(File alignmentFile, SequenceType sequenceType) {
            MSAPoset align = MSAPoset.parseAlnOrMsfFormats(alignmentFile);
            return DatasetUtils.fromAlignment(align, sequenceType);
        }

        public static Dataset fromAlignment(MSAPoset align, SequenceType sequenceType) {
            Indexer<Character> indexer = sequenceType.getEncodings().nonGapCharactersIndexer();
            HashMap<Taxon, int[]> data = new HashMap<Taxon, int[]>();
            for (Taxon taxon : align.sequences().keySet()) {
                data.put(taxon, new int[align.columns().size()]);
            }
            int i = 0;
            for (MSAPoset.Column c : align.linearizedColumns()) {
                for (Taxon t : align.sequences().keySet()) {
                    if (c.getPoints().keySet().contains(t)) {
                        Character lastChar = null;
                        try {
                            int index;
                            lastChar = Character.valueOf(align.charAt(c, t));
                            ((int[])data.get((Object)t))[i] = index = indexer.o2i(lastChar);
                        }
                        catch (Exception e) {
                            ((int[])data.get((Object)t))[i] = -1;
                        }
                        continue;
                    }
                    ((int[])data.get((Object)t))[i] = -1;
                }
                ++i;
            }
            final int n = align.columns().size();
            final int nChars = indexer.size();
            ObservationDimensions od = new ObservationDimensions(){

                @Override
                public int nSites() {
                    return n;
                }

                @Override
                public int nCharacter(int site) {
                    return nChars;
                }
            };
            final Map<Taxon, double[][]> converted = DatasetUtils.convert(data, od);
            return new Dataset(){

                @Override
                public Map<Taxon, String> getReferenceClusters() {
                    throw new RuntimeException();
                }

                @Override
                public boolean hasReferenceClusters() {
                    return false;
                }

                @Override
                public Map<Taxon, double[][]> observations() {
                    return converted;
                }

                @Override
                public int nCharacter(int site) {
                    return nChars;
                }

                @Override
                public int nSites() {
                    return n;
                }
            };
        }

        private static double[][] aMatrix(Dataset ds) {
            return ds.observations().values().iterator().next();
        }

        public static int nSites(Dataset ds) {
            return DatasetUtils.aMatrix(ds).length;
        }

        public static int nCharacters(Dataset ds, int site) {
            return DatasetUtils.aMatrix(ds)[site].length;
        }

        public static Map<Taxon, double[][]> convert(Map<Taxon, int[]> obs, ObservationDimensions dims) {
            HashMap<Taxon, double[][]> result = new HashMap<Taxon, double[][]>();
            for (Taxon lang : obs.keySet()) {
                result.put(lang, DatasetUtils.convert(obs.get(lang), dims));
            }
            return result;
        }

        private static double[][] convert(int[] model, ObservationDimensions dims) {
            double[][] processed = DatasetUtils.createObsArray(dims);
            for (int s = 0; s < dims.nSites(); ++s) {
                for (int c = 0; c < dims.nCharacter(s); ++c) {
                    if (model[s] != -1 && model[s] != c) continue;
                    processed[s][c] = 1.0;
                }
            }
            return processed;
        }

        public static double[][] createObsArray(ObservationDimensions dims) {
            double[][] result = new double[dims.nSites()][];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new double[dims.nCharacter(i)];
            }
            return result;
        }

        public static double[][] log(double[][] ori) {
            double[][] processed = new double[ori.length][];
            for (int s = 0; s < processed.length; ++s) {
                processed[s] = new double[ori[s].length];
                for (int c = 0; c < processed[s].length; ++c) {
                    processed[s][c] = Math.log(ori[s][c]);
                }
            }
            return processed;
        }
    }

    public static enum DatasetType {
        WALS{

            @Override
            public Dataset loadDataset() {
                return WalsDataset.getPreprocessedCorpus();
            }
        }
        ,
        HGDP{

            @Override
            public Dataset loadDataset() {
                return new HGDPDataset();
            }
        }
        ,
        GEN{

            @Override
            public Dataset loadDataset() {
                return new GeneratedDataset();
            }
        };


        public abstract Dataset loadDataset();
    }
}

