/*
 * Decompiled with CFR 0.152.
 */
package pty.io;

import goblin.Taxon;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import ma.newick.ParseException;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.util.Arbre;
import pty.io.WalsData;

public class WalsAnn {
    private static final Pattern selector = Pattern.compile("[^a-z]([a-z]{3})[^a-z]");

    public static void main(String[] args) throws IOException, ParseException {
        List<String> walsPaths = Arrays.asList("/home/eecs/bouchard/ptychodus/data/wals_data", "/Users/bouchard/w/ptychodus/data/wals_data");
        WalsData data = null;
        for (String path : walsPaths) {
            try {
                data = WalsData.parse(new File(path));
            }
            catch (Exception e) {}
        }
        for (String line : IO.si()) {
            IO.so(WalsAnn.annotate(data, line));
        }
    }

    public static String annotate(final WalsData data, Arbre<Taxon> a, final boolean showFamily) {
        return a.preOrderMap(new Arbre.ArbreMap<Taxon, String>(){

            @Override
            public String map(Arbre<Taxon> currentDomainNode) {
                if (currentDomainNode.getContents() == null) {
                    return "";
                }
                return WalsAnn.processWalsCode(data, currentDomainNode.getContents().toString(), showFamily);
            }
        }).deepToString();
    }

    public static String annotate(WalsData data, String line) {
        for (String match : StringUtils.selectRegex(selector, line)) {
            String sub = data.getFullLanguageName(match);
            if (sub != null) {
                line = line.replaceAll(match, WalsAnn.processWalsCode(data, match, false));
                continue;
            }
            System.err.println("Warning: unknown code: " + match);
        }
        return line;
    }

    private static String processWalsCode(WalsData data, String walscode, boolean showFamily) {
        String sub = data.getFullLanguageName(walscode);
        if (sub != null) {
            return WalsAnn.cleanedLangName(sub, false);
        }
        return walscode;
    }

    public static String cleanForPhylip(String s) {
        return WalsAnn.fillWithSpaces(WalsAnn.cleanedLangName(s, true, 10), 10);
    }

    public static String fillWithSpaces(String s, int n) {
        if (s.length() > n) {
            return s.substring(0, n);
        }
        int delta = n - s.length();
        for (int i = 0; i < delta; ++i) {
            s = s + " ";
        }
        return s;
    }

    public static String cleanedLangName(String s) {
        return WalsAnn.cleanedLangName(s, true);
    }

    public static String cleanedLangName(String s, boolean clip) {
        return WalsAnn.cleanedLangName(s, clip, 10);
    }

    public static String cleanedLangName(String s, boolean clip, int clipL) {
        String result = "";
        for (char c : s.toCharArray()) {
            if (!("" + c).matches("[A-Za-z0-9]")) continue;
            result = result + c;
        }
        if (result.length() == 0) {
            throw new RuntimeException("orig:" + s);
        }
        if (clip) {
            return result.substring(0, Math.min(clipL, result.length()));
        }
        return result;
    }
}

