/*
 * Decompiled with CFR 0.152.
 */
package pty.mcmc;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Parallelizer;
import fig.exec.Execution;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nuts.io.IO;
import nuts.util.CollUtils;
import pty.UnrootedTree;
import pty.eval.SymmetricDiff;
import pty.io.Dataset;
import pty.io.HGDPDataset;
import pty.io.WalsDataset;
import pty.learn.CTMCLoader;
import pty.mcmc.Main;
import pty.mcmc.ParallelTemperingChain;
import pty.mcmc.PhyloSampler;
import pty.mcmc.ProposalDistribution;
import pty.mcmc.UnrootedTreeState;
import pty.smc.MapLeaves;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleFilter;
import pty.smc.models.BrownianModel;
import pty.smc.models.CTMC;

public class FindMap
implements Runnable {
    @Option(required=true)
    public String experimentDir = null;
    @Option
    public int numberOfThreads = 1;
    private static Main main = new Main();
    private MapLeaves ml = null;
    private static ParticleFilter<PartialCoalescentState> pf = new ParticleFilter();
    private static CTMCLoader loader = new CTMCLoader();
    private Dataset wals;
    private Dataset hgdp;
    private double max = Double.NEGATIVE_INFINITY;
    private UnrootedTree bestWalsT = null;
    private UnrootedTree bestHgdpT = null;

    public static void main(String[] args) {
        Execution.monitor = true;
        Execution.makeThunk = false;
        Execution.create = true;
        Execution.useStandardExecPoolDirStrategy = true;
        Execution.run(args, new FindMap(), "main", main, "prior", PhyloSampler._defaultPriorOptions, "prop", ProposalDistribution.Util._defaultProposalDistributionOptions, "sampler", PhyloSampler._defaultPhyloSamplerOptions, "wals", WalsDataset.class, "hddp", HGDPDataset.class, "filter", pf, "langparam", loader, "partemp", ParallelTemperingChain._defaultTemperingOptions);
    }

    private static Set<String> fileNames(List<File> subFiles) {
        HashSet<String> result = CollUtils.set();
        for (File f : subFiles) {
            result.add(f.getName());
        }
        return result;
    }

    @Override
    public void run() {
        List<File> subFiles1 = IO.locate(new File(this.experimentDir, "WALS-chain-0"), IO.suffixFilter("gz", "newick"));
        List<File> subFiles2 = IO.locate(new File(this.experimentDir, "HGDP-chain-0"), IO.suffixFilter("gz", "newick"));
        final Set<String> fileNames = FindMap.fileNames(subFiles1);
        fileNames.retainAll(FindMap.fileNames(subFiles2));
        this.wals = Dataset.DatasetType.WALS.loadDataset();
        this.hgdp = Dataset.DatasetType.HGDP.loadDataset();
        loader.setData(this.wals);
        final CTMC ctmc = loader.load();
        final BrownianModel bm = new BrownianModel(this.hgdp.nSites(), FindMap.main.brownianMotionVariance);
        this.ml = MapLeaves.parse(FindMap.main.mapfile);
        final PhyloSampler.NonClockTreePrior prior = PhyloSampler._defaultPhyloSamplerOptions.prior.prior(PhyloSampler._defaultPriorOptions);
        LogInfo.track("Searching map");
        Parallelizer<String> parallelizer = new Parallelizer<String>(this.numberOfThreads);
        parallelizer.setPrimaryThread();
        parallelizer.process(new ArrayList<String>(fileNames), new Parallelizer.Processor<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void process(String name, int _i, int _n, boolean log) {
                LogInfo.logsForce("Processed file " + (_i + 1) + "/" + fileNames.size());
                File walsFile = new File(FindMap.this.experimentDir + "/WALS-chain-0/" + name);
                File hgdpFile = new File(FindMap.this.experimentDir + "/HGDP-chain-0/" + name);
                try {
                    for (List<String> lines : IO.i(walsFile, hgdpFile)) {
                        String walsLine = lines.get(0);
                        String hgdpLine = lines.get(1);
                        UnrootedTree walsTree = UnrootedTree.fromNewick(walsLine);
                        UnrootedTree hgdpTree = UnrootedTree.fromNewick(hgdpLine);
                        UnrootedTreeState walsState = UnrootedTreeState.fromCTMC(walsTree, FindMap.this.wals, ctmc);
                        UnrootedTreeState hgdpState = UnrootedTreeState.fromBrownianMotion(hgdpTree, FindMap.this.hgdp, bm);
                        double sum = walsState.logLikelihood() + hgdpState.logLikelihood();
                        sum += prior.logPriorDensity(walsTree) + prior.logPriorDensity(hgdpTree);
                        sum += -main.initialAgreementParam * (double)SymmetricDiff.symmetricDifferenceSize(FindMap.this.ml.filterClades(walsTree.clades()), FindMap.this.ml.mapClades(FindMap.this.ml.filterClades(hgdpTree.clades())));
                        Main main = main;
                        synchronized (main) {
                            if (sum > FindMap.this.max) {
                                LogInfo.logs("Higher score found: " + sum);
                                FindMap.this.max = sum;
                                FindMap.this.bestWalsT = walsTree;
                                FindMap.this.bestHgdpT = hgdpTree;
                            }
                        }
                    }
                    return;
                }
                catch (Exception e) {
                    LogInfo.warning("Problem with file " + name + "... skipping");
                }
            }
        });
        LogInfo.logsForce("Best score: " + this.max);
        LogInfo.logsForce("Best wals: " + this.bestWalsT.toNewick());
        LogInfo.logsForce("Best hgdp: " + this.bestHgdpT.toNewick());
    }
}

