/*
 * Decompiled with CFR 0.152.
 */
package pty.smc;

import fig.basic.Option;
import fig.basic.Pair;
import java.util.List;
import java.util.Random;
import nuts.math.Sampling;
import pty.smc.LazyParticleFilter;
import pty.smc.PartialCoalescentState;

public class NCPriorPriorKernel
implements LazyParticleFilter.LazyParticleKernel<PartialCoalescentState> {
    @Option
    public static double deltaProposalRate = -1.0;
    @Option
    public static boolean useOptimal = false;
    private PartialCoalescentState initial;

    public NCPriorPriorKernel(PartialCoalescentState initial) {
        this.setInitial(initial);
    }

    public void setInitial(PartialCoalescentState initial) {
        this.initial = initial;
    }

    @Override
    public PartialCoalescentState getInitial() {
        return this.initial;
    }

    @Override
    public int nIterationsLeft(PartialCoalescentState partialState) {
        return partialState.nIterationsLeft();
    }

    @Override
    public Pair<PartialCoalescentState, Double> next(Random rand, PartialCoalescentState current) {
        return (Pair)this._next(rand, current, false);
    }

    public Object _next(Random rand, PartialCoalescentState current, boolean isPeek) {
        PartialCoalescentState _next;
        double delta0 = Sampling.sampleExponential(rand, 1.0 / deltaProposalRate) / (current.nRoots() == 2 ? 2.0 : 1.0);
        double delta1 = Sampling.sampleExponential(rand, 1.0 / deltaProposalRate) / (current.nRoots() == 2 ? 2.0 : 1.0);
        List<Integer> sampledIndices = Sampling.sampleWithoutReplacement(rand, current.nRoots(), 2);
        if (sampledIndices.size() != 2) {
            throw new RuntimeException();
        }
        int i0 = sampledIndices.get(0);
        int i1 = sampledIndices.get(1);
        if (isPeek) {
            if (useOptimal) {
                throw new RuntimeException();
            }
            return current.peekLogLikelihoodRatio(i0, i1, 0.0, delta0, delta1) - Math.log(current.peekNNonTrivialRoots(i0, i1));
        }
        PartialCoalescentState next = _next = current.coalesce(i0, i1, 0.0, delta0, delta1);
        double logW = useOptimal ? next.nonClockLogWeight() : next.logLikelihoodRatio() - Math.log(next.nNonTrivialRoots());
        return Pair.makePair(_next, logW);
    }

    @Override
    public double peekNext(Random rand, PartialCoalescentState current) {
        return (Double)this._next(rand, current, true);
    }
}

