/*
 * Decompiled with CFR 0.152.
 */
package pty.smc.exp;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import goblin.DataPrepUtils;
import goblin.Taxon;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import nuts.io.IO;
import nuts.util.Arbre;
import nuts.util.Tree;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import pty.RootedTree;
import pty.SumT;
import pty.UnrootedTree;
import pty.eval.SymmetricDiff;
import pty.io.Dataset;
import pty.io.HGDPDataset;
import pty.mcmc.Main;
import pty.mcmc.ParallelTemperingChain;
import pty.mcmc.PhyloSampler;
import pty.mcmc.ProposalDistribution;
import pty.smc.models.BrownianModelCalculator;
import pty.smc.test.GenerateFromTree;
import pty.smc.test.MultiTests;

public class TimingExp
implements Runnable {
    private static GenerateFromTree genFromTree = new GenerateFromTree();
    private static MultiTests pfTest = new MultiTests();
    private static Main mcmcMain = new Main();
    @Option
    public boolean forceVarianceEqualToGenerated = true;
    @Option
    public Random mcmcInitRandom = new Random(1L);
    @Option
    public double ratioOfTimeForMCMC = 1.0;
    @Option
    public boolean runSMC = true;
    @Option
    public double timeIfMCMCOnly = 10000.0;

    public static void main(String[] args) {
        IO.run(args, new TimingExp(), "mt", pfTest, "gft", genFromTree, "bmc", BrownianModelCalculator.class, "mcmcMain", mcmcMain, "prior", PhyloSampler._defaultPriorOptions, "prop", ProposalDistribution.Util._defaultProposalDistributionOptions, "sampler", PhyloSampler._defaultPhyloSamplerOptions, "partemp", ParallelTemperingChain._defaultTemperingOptions);
    }

    public static Tree<Taxon> removeUselessInternalNodes(Tree<Taxon> t) {
        ArrayList newChildren = new ArrayList();
        if (t.getChildren().size() == 1) {
            return TimingExp.removeUselessInternalNodes(t.getChildren().get(0));
        }
        for (Tree<Taxon> child : t.getChildren()) {
            newChildren.add(TimingExp.removeUselessInternalNodes(child));
        }
        return new Tree<Taxon>(t.getLabel(), newChildren);
    }

    @Override
    public void run() {
        try {
            RootedTree goldTree = RootedTree.Util.load(new File(TimingExp.genFromTree.treeFile));
            LogInfo.track("Generating data");
            File data = genFromTree.generate();
            LogInfo.end_track();
            LogInfo.logsForce("Forcing variance of the pf test to be equal to the generated one: " + TimingExp.genFromTree.scale);
            TimingExp.pfTest.scaling = TimingExp.genFromTree.scale;
            TimingExp.pfTest.scalingIters = 1;
            TimingExp.pfTest.dataType = Dataset.DatasetType.HGDP;
            long time = (long)this.timeIfMCMCOnly;
            if (this.runSMC) {
                TimingExp.pfTest.trueTreePath = TimingExp.genFromTree.treeFile;
                HGDPDataset.path = data.getAbsolutePath();
                LogInfo.track("Running pf");
                time = System.currentTimeMillis();
                pfTest.run();
                time = (System.currentTimeMillis() - time) / (long)TimingExp.pfTest.nRepeats;
                LogInfo.logsForce("Mean time for PF: " + time);
                LogInfo.end_track();
            }
            LogInfo.track("Running mcmc");
            SummaryStatistics diffs = new SummaryStatistics();
            SummaryStatistics timeStat = new SummaryStatistics();
            for (int curRep = 0; curRep < TimingExp.pfTest.nRepeats; ++curRep) {
                long mcmcTime = System.currentTimeMillis();
                UnrootedTree mcmcInit = this.randomInit(UnrootedTree.fromNewick(new File(TimingExp.genFromTree.treeFile)).leaves(), this.mcmcInitRandom);
                File mcmcInitFile = new File(Execution.getFile("mcmcInit-" + curRep + ".newick"));
                IO.writeToDisk(mcmcInitFile, mcmcInit.toNewick());
                ParallelTemperingChain._defaultTemperingOptions.timeCutOff = (long)((double)time * this.ratioOfTimeForMCMC);
                TimingExp.mcmcMain.dataTypes = new ArrayList<Dataset.DatasetType>(Arrays.asList(Dataset.DatasetType.HGDP));
                HGDPDataset.path = data.getAbsolutePath();
                TimingExp.mcmcMain.brownianMotionVariance = TimingExp.genFromTree.scale;
                TimingExp.mcmcMain.pathsToInitTree = new ArrayList<String>(Arrays.asList(mcmcInitFile.getAbsolutePath()));
                TimingExp.mcmcMain.conditionOnFamilies = false;
                PhyloSampler._defaultPhyloSamplerOptions.logFrequency = 1;
                LogInfo.track("MCMC run " + curRep + "/" + TimingExp.pfTest.nRepeats);
                File samples = mcmcMain.run("repeat" + curRep).get(0);
                LogInfo.end_track();
                SumT sumT = new SumT();
                sumT.treeFile = samples.getAbsolutePath();
                sumT.evaluatePurity = false;
                UnrootedTree consensus = sumT.consensus();
                diffs.addValue(this.eval(consensus, goldTree));
                timeStat.addValue((double)(System.currentTimeMillis() - mcmcTime));
            }
            LogInfo.logsForce("Mean time for MCMC: " + timeStat.getMean());
            LogInfo.logsForce("SD time for MCMC: " + timeStat.getStandardDeviation());
            LogInfo.logsForce("Mean symm diff for MCMC: " + diffs.getMean());
            LogInfo.logsForce("SD of symm diff for MCMC: " + diffs.getStandardDeviation());
            LogInfo.end_track();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private double eval(UnrootedTree consensus, RootedTree goldTree) {
        Arbre<Taxon> ref = goldTree.topology();
        double min = Double.POSITIVE_INFINITY;
        for (Tree<Taxon> lang : consensus.toTree().getPostOrderTraversal()) {
            Tree<Taxon> rooted = consensus.toTree(lang.getLabel());
            double cur = SymmetricDiff.normalizedSymmetricCladeDiff(Arbre.tree2Arbre(rooted), ref);
            if (!(cur < min)) continue;
            min = cur;
        }
        return min;
    }

    private UnrootedTree randomInit(List<Taxon> leaves, Random rand) {
        LinkedList<Tree<Taxon>> subtrees = new LinkedList<Tree<Taxon>>();
        for (Taxon leaf : leaves) {
            subtrees.add(new Tree<Taxon>(leaf));
        }
        int id = 0;
        while (subtrees.size() > 3) {
            Tree subt1 = (Tree)subtrees.remove(rand.nextInt(subtrees.size()));
            Tree subt2 = (Tree)subtrees.remove(rand.nextInt(subtrees.size()));
            Tree<Taxon> tree = new Tree<Taxon>(new Taxon("intern_" + id++));
            tree.getChildren().add(subt1);
            tree.getChildren().add(subt2);
            subtrees.add(tree);
        }
        if (subtrees.size() != 3) {
            throw new RuntimeException();
        }
        Tree<Taxon> resultTopo = new Tree<Taxon>(new Taxon("intern_" + id++));
        for (Tree tree : subtrees) {
            resultTopo.getChildren().add(tree);
        }
        HashMap<Taxon, Double> bl = new HashMap<Taxon, Double>();
        for (Tree<Taxon> lang : resultTopo.getPostOrderTraversal()) {
            bl.put(lang.getLabel(), rand.nextDouble());
        }
        return UnrootedTree.fromNewick(DataPrepUtils.newick(resultTopo, bl, true));
    }
}

