/*
 * Decompiled with CFR 0.152.
 */
package pty.smc.test;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import goblin.BayesRiskMinimizer;
import goblin.Taxon;
import java.util.Random;
import java.util.Set;
import nuts.util.Arbre;
import nuts.util.Counter;
import pty.Train;
import pty.eval.Purity;
import pty.eval.SymmetricDiff;
import pty.io.Dataset;
import pty.io.HGDPDataset;
import pty.io.WalsDataset;
import pty.learn.CTMCLoader;
import pty.smc.ConditionalPriorPriorKernel;
import pty.smc.MapLeaves;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleFilter;
import pty.smc.PriorPriorKernel;
import pty.smc.models.CTMC;
import pty.smc.test.TestBrownianModel;
import pty.smc.test.TestJointModel;

public class LanguageFromGene
implements Runnable {
    @Option
    public String mapfile = "data/language-gene-map.txt";
    @Option
    public int gibbsIterations = 100;
    @Option
    public int increaseNSamplesPerGibbsIteration = 0;
    private static ParticleFilter<PartialCoalescentState> pf = new ParticleFilter();
    private static CTMCLoader langParamLoader = new CTMCLoader();
    private Dataset langData;
    private MapLeaves ml;
    public static double agreementWeight = 1.0;
    public static final Random rand = new Random(1L);
    PartialCoalescentState genepcs;
    PartialCoalescentState langpcs;

    public static void main(String[] args) {
        Execution.monitor = true;
        Execution.makeThunk = false;
        Execution.create = true;
        Execution.useStandardExecPoolDirStrategy = true;
        Execution.run(args, new TestJointModel(), "wals", WalsDataset.class, "hgdp", HGDPDataset.class, "filter", pf, "langparam", langParamLoader, "cppk", ConditionalPriorPriorKernel.class);
    }

    public static PartialCoalescentState initCTMCGeneState() {
        Dataset data = Dataset.DatasetType.HGDP.loadDataset();
        int nsites = data.nSites();
        double rateScalar = 1.0E-8;
        double[][] rate = new double[][]{{-rateScalar, rateScalar}, {rateScalar, -rateScalar}};
        CTMC.SimpleCTMC ctmc = new CTMC.SimpleCTMC(rate, nsites);
        return PartialCoalescentState.initState(data, ctmc);
    }

    private PartialCoalescentState initLanguageState() {
        this.langData = WalsDataset.getPreprocessedCorpus();
        langParamLoader.setData(this.langData);
        CTMC langParam = langParamLoader.load();
        return PartialCoalescentState.initState(this.langData, langParam);
    }

    public void gibbsSampler(PartialCoalescentState initGeneState, PartialCoalescentState initLangState) {
        PriorPriorKernel ppk = new PriorPriorKernel(initLangState);
        ParticleFilter.ParticleMapperProcessor<PartialCoalescentState, Set<Set<Taxon>>> processor = SymmetricDiff.createCladeProcessor();
        pf.sample(ppk, processor);
        Set<Set<Taxon>> currentGeneState = null;
        Set<Set<Taxon>> currentLangState = processor.map();
        Arbre<Taxon> reconstruction = Train.outputTree(SymmetricDiff.clades2arbre(processor.centroid(SymmetricDiff.CLADE_SYMMETRIC_DIFFERENCE)), "ling-consensusTree-init");
        if (this.langData.hasReferenceClusters()) {
            LogInfo.logs("Purity-init:" + Purity.purity(Arbre.arbre2Tree(reconstruction), this.langData.getReferenceClusters()));
        }
        Counter<Set<Set<Taxon>>> allLinguisticSamples = new Counter<Set<Set<Taxon>>>();
        Counter<Set<Set<Taxon>>> allGeneSamples = new Counter<Set<Set<Taxon>>>();
        for (int i = 0; i < this.gibbsIterations; ++i) {
            currentGeneState = this.sampleBlock(initGeneState, currentLangState, allGeneSamples, false, i);
            currentLangState = this.sampleBlock(initLangState, currentGeneState, allLinguisticSamples, true, i);
            LanguageFromGene.pf.N += this.increaseNSamplesPerGibbsIteration;
        }
    }

    private Set<Set<Taxon>> sampleBlock(PartialCoalescentState initCoalescentState, Set<Set<Taxon>> otherNodeState, Counter<Set<Set<Taxon>>> allSampleForCurrentNode, boolean isLang, int i) {
        ParticleFilter.ParticleMapperProcessor<PartialCoalescentState, Set<Set<Taxon>>> processor = SymmetricDiff.createCladeProcessor();
        ParticleFilter.PCSHash hashProcessor = new ParticleFilter.PCSHash();
        ParticleFilter.ForkedProcessor processors = new ParticleFilter.ForkedProcessor(processor, hashProcessor);
        ConditionalPriorPriorKernel pk = new ConditionalPriorPriorKernel(initCoalescentState, otherNodeState, this.ml, agreementWeight);
        pf.sample(pk, processors);
        allSampleForCurrentNode.incrementAll(processor.getCounter());
        Arbre<Taxon> reconstruction = Train.outputTree(SymmetricDiff.clades2arbre(new BayesRiskMinimizer<Set<Taxon>>(SymmetricDiff.CLADE_SYMMETRIC_DIFFERENCE).findMin(allSampleForCurrentNode)), (isLang ? "ling" : "bio") + "-consensusTree-" + i);
        if (isLang && this.langData.hasReferenceClusters()) {
            LogInfo.logs("Purity-" + i + ":" + Purity.purity(Arbre.arbre2Tree(reconstruction), this.langData.getReferenceClusters()));
        }
        LogInfo.logs("Hash-" + i + (isLang ? "-lang" : "-bio") + "=" + hashProcessor.getHash());
        return processor.sample(rand);
    }

    @Override
    public void run() {
        PartialCoalescentState geneState = TestBrownianModel.initGeneState(1.0);
        PartialCoalescentState languageState = this.initLanguageState();
        this.ml = MapLeaves.parse(this.mapfile);
        this.gibbsSampler(geneState, languageState);
    }
}

