/*
 * Decompiled with CFR 0.152.
 */
package pty.smc.test;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import goblin.Taxon;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import ma.newick.NewickParser;
import nuts.util.Arbre;
import nuts.util.Tree;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import pty.RootedTree;
import pty.Train;
import pty.eval.Purity;
import pty.eval.SymmetricDiff;
import pty.io.Dataset;
import pty.io.HGDPDataset;
import pty.io.LeaveOneOut;
import pty.io.WalsDataset;
import pty.learn.CTMCLoader;
import pty.smc.PartialCoalescentState;
import pty.smc.ParticleFilter;
import pty.smc.ParticleKernel;
import pty.smc.models.BrownianModel;
import pty.smc.models.BrownianModelCalculator;
import pty.smc.models.CTMC;
import pty.smc.test.SymmetryTest;
import pty.smc.test.TestBrownianModel;

public class MultiTests
implements Runnable {
    static int datum = 0;
    @Option
    public TestBrownianModel.KernelType kernelType = TestBrownianModel.KernelType.PRIOR_PRIOR;
    @Option
    public String trueTreePath = "none";
    @Option
    public int nRepeats = 10;
    @Option
    public int nSitesMin = Integer.MAX_VALUE;
    @Option
    public int nSitesMax = Integer.MAX_VALUE;
    @Option
    public int nSitesIncr = 100;
    @Option
    public int nThread = 8;
    @Option
    public double scaling = 1.0;
    @Option
    public int scalingIters = 1;
    @Option
    public double reScaling = 2.0;
    @Option
    public int nParticlesMin = 100;
    @Option
    public int nParticlesMax = 100;
    @Option
    public int nParticlesIncr = 100;
    @Option
    public Dataset.DatasetType dataType = Dataset.DatasetType.HGDP;
    @Option
    public boolean printTrees = false;
    public static CTMCLoader loader = new CTMCLoader();

    public void genTest(int nParticules, int nSites, int nRepeats, TestBrownianModel.KernelType kernelType, Arbre<Taxon> trueTopo, double variance, int nThreads, Dataset.DatasetType dataType, double trueH) {
        Dataset data;
        PartialCoalescentState init = null;
        PartialCoalescentState.disableUnrooted = true;
        Map<Taxon, String> refClusters = null;
        if (dataType == Dataset.DatasetType.HGDP) {
            HGDPDataset.maxNSites = nSites;
            data = new HGDPDataset();
            int actual = ((HGDPDataset)data).nSites();
            if (actual != nSites) {
                LogInfo.warning("Requested " + nSites + " but there are only " + actual + " sites in data");
                nSites = actual;
            }
            BrownianModel model = new BrownianModel(((HGDPDataset)data).nSites(), variance);
            init = null;
        } else if (dataType == Dataset.DatasetType.WALS) {
            if (nSites != Integer.MAX_VALUE) {
                throw new RuntimeException();
            }
            data = dataType.loadDataset();
            MultiTests.loader.rate = variance;
            loader.setData(data);
            CTMC ctmc = loader.load();
            init = PartialCoalescentState.initState(data, ctmc);
            refClusters = data.getReferenceClusters();
        } else {
            throw new RuntimeException();
        }
        ParticleKernel<PartialCoalescentState> ppk = kernelType.load(init, null);
        ParticleFilter<PartialCoalescentState> pc = new ParticleFilter<PartialCoalescentState>();
        pc.N = nParticules;
        pc.nThreads = nThreads;
        pc.resampleLastRound = false;
        SummaryStatistics timeStats = new SummaryStatistics();
        SummaryStatistics perfStats = new SummaryStatistics();
        SummaryStatistics norm = new SummaryStatistics();
        SummaryStatistics hss = new SummaryStatistics();
        SummaryStatistics purity = new SummaryStatistics();
        SummaryStatistics loo = new SummaryStatistics();
        int firstDatum = datum;
        for (int r = 0; r < nRepeats; ++r) {
            ParticleFilter.ParticleMapperProcessor<PartialCoalescentState, Set<Set<Taxon>>> processor = SymmetricDiff.createCladeProcessor();
            ParticleFilter.ParticleMapperProcessor<PartialCoalescentState, Set<Set<Taxon>>> mbr = SymmetricDiff.createCladeProcessor();
            SymmetryTest.MeanHeight hpro = new SymmetryTest.MeanHeight();
            ParticleFilter.MAPDecoder mapDecoder = new ParticleFilter.MAPDecoder();
            ParticleFilter.ForkedProcessor processors = new ParticleFilter.ForkedProcessor(processor, mapDecoder, mbr, hpro);
            long time = System.currentTimeMillis();
            try {
                pc.sample(ppk, processors);
                time = System.currentTimeMillis() - time;
                timeStats.addValue((double)time);
                Arbre<Taxon> recon = SymmetricDiff.clades2arbre(mbr.centroid(SymmetricDiff.CLADE_SYMMETRIC_DIFFERENCE));
                RootedTree map = ((PartialCoalescentState)mapDecoder.map()).getFullCoalescentState();
                if (dataType == Dataset.DatasetType.WALS) {
                    loo.addValue(LeaveOneOut.loo((PartialCoalescentState)mapDecoder.map()));
                }
                if (this.printTrees) {
                    Train.outputTree(recon, "mbr-tree-datum-" + datum);
                    Train.outputTree(map.topology(), "mapTree-" + datum, map.branchLengths());
                }
                if (trueTopo != null) {
                    double perf = SymmetricDiff.normalizedSymmetricCladeDiff(recon, trueTopo);
                    perfStats.addValue(perf);
                    double reconH = hpro.ss.getMean();
                    LogInfo.logs("!!!!!!!!!!!!!Recon=" + reconH);
                    hss.addValue(Math.abs(trueH - reconH));
                }
                if (refClusters != null) {
                    double pur = Purity.purity(Arbre.arbre2Tree(recon), refClusters);
                    purity.addValue(pur);
                }
                norm.addValue(pc.estimateNormalizer());
                ++datum;
                continue;
            }
            catch (Exception e) {
                LogInfo.warning("One part. filter run failed");
                LogInfo.warning("Detail:" + e);
                e.printStackTrace();
                ++nRepeats;
            }
        }
        LogInfo.logsForce((Object)((Object)dataType) + "-datum-" + firstDatum + "-" + (datum - 1) + ": " + "nPart=" + nParticules + " " + "nSites=" + nSites + " " + "nRep=" + nRepeats + " " + "kernel=" + (Object)((Object)kernelType) + " " + "scale=" + variance + " " + "nt=" + nThreads + " " + "timeM=" + timeStats.getMean() + " " + "timeSD=" + timeStats.getStandardDeviation() + " " + "symmM=" + (trueTopo == null ? "N/A" : Double.valueOf(perfStats.getMean())) + " " + "symmSD=" + (trueTopo == null ? "N/A" : Double.valueOf(perfStats.getStandardDeviation())) + " " + "hM=" + (trueTopo == null ? "N/A" : Double.valueOf(hss.getMean())) + " " + "hSD=" + (trueTopo == null ? "N/A" : Double.valueOf(hss.getStandardDeviation())) + " " + "normM=" + norm.getMean() + " " + "normSD=" + norm.getStandardDeviation() + " " + "purM=" + (purity == null ? "N/A" : Double.valueOf(purity.getMean())) + " " + "purSD=" + (purity == null ? "N/A" : Double.valueOf(purity.getStandardDeviation())) + " " + "looM=" + loo.getMean() + " " + "looSD=" + loo.getStandardDeviation());
    }

    @Override
    public void run() {
        if (this.nSitesIncr <= 0 || this.nSitesIncr <= 0) {
            throw new RuntimeException();
        }
        double trueH = Double.NaN;
        Arbre<Taxon> ar = null;
        try {
            NewickParser np = new NewickParser(IOUtils.openIn(this.trueTreePath));
            Tree<String> tree = np.parse();
            ar = Arbre.tree2Arbre(tree).preOrderMap(new Arbre.ArbreMap<String, Taxon>(){

                @Override
                public Taxon map(Arbre<String> t) {
                    return new Taxon(t.getContents());
                }
            });
            trueH = RootedTree.Util.height(RootedTree.Util.load(new File(this.trueTreePath)));
            LogInfo.logs("True height:" + trueH);
        }
        catch (Exception e) {
            LogInfo.warning("Warning:" + this.trueTreePath + " does not seem to be pointing to a " + "valid topo...\nSkipping topo evaluation");
        }
        for (int curScIt = 0; curScIt < this.scalingIters; ++curScIt) {
            for (int curNSites = this.nSitesMin; curNSites <= this.nSitesMax && curNSites >= 0; curNSites += this.nSitesIncr) {
                for (int nParticles = this.nParticlesMin; nParticles <= this.nParticlesMax; nParticles += this.nParticlesIncr) {
                    this.genTest(nParticles, curNSites, this.nRepeats, this.kernelType, ar, this.scaling, this.nThread, this.dataType, trueH);
                }
            }
            this.scaling *= this.reScaling;
        }
    }

    public static void main(String[] args) {
        if (Arrays.asList(args).contains("JARS")) {
            Execution.jarFiles = new ArrayList<String>(Arrays.asList("/home/eecs/bouchard/jars/ptychodus.jar", "/home/eecs/bouchard/jars/nuts.jar", "/home/eecs/bouchard/jars/fig.jar", "/home/eecs/bouchard/jars/pepper.jar"));
        }
        Execution.monitor = true;
        Execution.makeThunk = false;
        Execution.create = true;
        Execution.useStandardExecPoolDirStrategy = true;
        Execution.run(args, new MultiTests(), "hgdp", HGDPDataset.class, "wals", WalsDataset.class, "ctmc", loader, "bmc", BrownianModelCalculator.class);
    }
}

