/*
 * Decompiled with CFR 0.152.
 */
package scratch;

import java.util.Arrays;
import nuts.util.MathUtils;

public class TestCovar {
    double[][] k;
    double[] p;
    double[] f;

    public TestCovar(double[] f, double[][] k, double[] p) {
        this.f = f;
        this.k = k;
        this.p = p;
    }

    public String toString() {
        return "k:" + Arrays.deepToString((Object[])this.k) + "\n" + "p:" + Arrays.toString(this.p) + "\n" + "f:" + Arrays.toString(this.f);
    }

    double ce(int prevState) {
        double denom = this.k[prevState][0] + this.k[prevState][1];
        return (this.f[0] * this.k[prevState][0] + this.f[1] * this.k[prevState][1]) / denom;
    }

    double f(int x) {
        return this.f[x];
    }

    double integrate(Integrand g) {
        double result = 0.0;
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    double cp = this.p[x] * this.k[x][y] * this.k[y][z];
                    result += cp * g.evalAt(x, y, z);
                }
            }
        }
        return result;
    }

    double var(Integrand g) {
        double ex2 = this.integrate(new Square(g));
        double ex = this.integrate(g);
        return ex2 - ex * ex;
    }

    public static void main(String[] args) {
        double[][] k = new double[][]{{0.5, 0.5}, {0.5, 0.5}};
        double[] p = new double[]{0.5, 0.5};
        double[] f = new double[]{2.0, -3.0};
        TestCovar test = new TestCovar(f, k, p);
        double integratedFX1_ = test.integrate(test.new FX1_Times_FX2());
        double integratedEFX1GX0_ = test.integrate(test.new EFX1GX0_Times_EFX2GX1());
        System.out.println("Std:" + integratedFX1_);
        System.out.println("Acc:" + integratedEFX1GX0_);
        System.out.println("===");
        for (double _k0 = 0.01; _k0 <= 0.99; _k0 += 0.01) {
            test.k[0][0] = _k0;
            test.k[0][1] = 1.0 - _k0;
            for (double _k1 = 0.01; _k1 <= 0.99; _k1 += 0.01) {
                test.k[1][0] = _k1;
                test.k[1][1] = 1.0 - _k1;
                test.p = MathUtils.findStatDistn(test.k);
                for (double f0 = -2.0; f0 <= 2.0; f0 += 0.1) {
                    test.f[0] = f0;
                    for (double f1 = -2.0; f1 <= 2.0; f1 += 0.1) {
                        test.f[1] = f1;
                        double std = test.var(test.new FX1_Plus_FX2());
                        double acc = test.var(test.new EFX1GX0_Plus_EFX2GX1());
                        if (!(acc > std + 1.0E-5)) continue;
                        System.out.println(test);
                        System.out.println("Std:" + std);
                        System.out.println("Acc:" + acc);
                        System.out.println("---");
                    }
                }
            }
        }
    }

    class EFX1GX0_Plus_EFX2GX1
    implements Integrand {
        EFX1GX0_Plus_EFX2GX1() {
        }

        @Override
        public double evalAt(int x, int y, int z) {
            return TestCovar.this.ce(x) + TestCovar.this.ce(y);
        }
    }

    class FX1_Plus_FX2
    implements Integrand {
        FX1_Plus_FX2() {
        }

        @Override
        public double evalAt(int x, int y, int z) {
            return TestCovar.this.f(y) + TestCovar.this.f(z);
        }
    }

    class EFX1GX0
    implements Integrand {
        EFX1GX0() {
        }

        @Override
        public double evalAt(int x, int y, int z) {
            return TestCovar.this.ce(x);
        }
    }

    class FX1
    implements Integrand {
        FX1() {
        }

        @Override
        public double evalAt(int x, int y, int z) {
            return TestCovar.this.f(y);
        }
    }

    class EFX1GX0_Times_EFX2GX1
    implements Integrand {
        EFX1GX0_Times_EFX2GX1() {
        }

        @Override
        public double evalAt(int x, int y, int z) {
            return TestCovar.this.ce(x) * TestCovar.this.ce(y);
        }
    }

    class FX1_Times_FX2
    implements Integrand {
        FX1_Times_FX2() {
        }

        @Override
        public double evalAt(int x, int y, int z) {
            return TestCovar.this.f(y) * TestCovar.this.f(z);
        }
    }

    class Square
    implements Integrand {
        final Integrand g;

        Square(Integrand g) {
            this.g = g;
        }

        @Override
        public double evalAt(int x, int y, int z) {
            double e = this.g.evalAt(x, y, z);
            return e * e;
        }
    }

    static interface Integrand {
        public double evalAt(int var1, int var2, int var3);
    }
}

