/*
 * Decompiled with CFR 0.152.
 */
package slice.stickrep;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nuts.util.EasyFormat;
import slice.stickrep.LinkedSticks;
import slice.stickrep.Location;
import slice.stickrep.LocationDistribution;
import slice.stickrep.Sticks;
import slice.util.TruncatedBeta;

public class DPMSample<L extends Location<D>, D> {
    private double alpha0 = 1.0;
    private Sticks sticks = new LinkedSticks();
    private List<L> locationParams = new ArrayList<L>();
    private List<Integer> indicators = new ArrayList<Integer>();
    private List<D> data = new ArrayList<D>();

    public void ensureEnoughSticks(double u, LocationDistribution<L, D> prior, Random rand) {
        while (this.getSticks().remainingStickLength() >= u) {
            this.sampleNewStick(prior, rand);
        }
    }

    private void sampleNewStick(LocationDistribution<L, D> prior, Random rand) {
        TruncatedBeta beta = new TruncatedBeta(this.getAlpha0(), 0.0, 1.0);
        double v = beta.sample(rand);
        this.getSticks().add(v);
        this.getLocationParams().add(prior.sample(rand));
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(List<Double> aux) {
        assert (aux == null || aux.size() == this.locationParams.size());
        StringBuilder builder = new StringBuilder();
        for (int clusterIndex = 0; clusterIndex < this.locationParams.size(); ++clusterIndex) {
            builder.append("Stick " + clusterIndex + ", " + "length: " + EasyFormat.fmt(this.sticks.retreiveW(clusterIndex)) + " (v = " + EasyFormat.fmt(this.sticks.retreiveV(clusterIndex)) + "), " + "loc. dist.: " + ((Location)this.locationParams.get(clusterIndex)).toString());
            if (aux != null) {
                builder.append(", aux: " + EasyFormat.fmt(aux.get(clusterIndex)));
            }
            builder.append("\n");
            for (int dataIndex = 0; dataIndex < this.data.size(); ++dataIndex) {
                if (this.indicators.get(dataIndex) != clusterIndex) continue;
                double ll = ((Location)this.locationParams.get(clusterIndex)).unnormLoglikelihood(this.data.get(dataIndex));
                builder.append("\tPoint " + dataIndex + ", " + "value: " + this.data.get(dataIndex).toString() + ", " + "log p(y|loc) propto " + ll + "\n");
            }
        }
        return builder.toString();
    }

    public void setAlpha0(double alpha0) {
        this.alpha0 = alpha0;
    }

    public void setData(List<D> data) {
        this.data = data;
    }

    public void setIndicators(List<Integer> indicators) {
        this.indicators = indicators;
    }

    public void setLocationParams(List<L> locationParams) {
        this.locationParams = locationParams;
    }

    public void setSticks(Sticks sticks) {
        this.sticks = sticks;
    }

    public double getAlpha0() {
        return this.alpha0;
    }

    public List<D> getData() {
        return this.data;
    }

    public List<Integer> getIndicators() {
        return this.indicators;
    }

    public List<L> getLocationParams() {
        return this.locationParams;
    }

    public Sticks getSticks() {
        return this.sticks;
    }
}

