/*
 * Decompiled with CFR 0.152.
 */
package org.jblas;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jblas.ComplexFloatMatrix;
import org.jblas.ConvertsToFloatMatrix;
import org.jblas.JavaBlas;
import org.jblas.MatrixFunctions;
import org.jblas.NativeBlas;
import org.jblas.SimpleBlas;
import org.jblas.exceptions.SizeException;
import org.jblas.ranges.Range;
import org.jblas.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatMatrix
implements Serializable {
    public int rows;
    public int columns;
    public int length;
    public float[] data = null;
    public static final FloatMatrix EMPTY = new FloatMatrix();
    static final long serialVersionUID = -1249281332731183060L;

    public FloatMatrix(int newRows, int newColumns, float ... newData) {
        this.rows = newRows;
        this.columns = newColumns;
        this.length = this.rows * this.columns;
        if (newData != null && newData.length != newRows * newColumns) {
            throw new IllegalArgumentException("Passed data must match matrix dimensions.");
        }
        this.data = newData;
    }

    public FloatMatrix(int newRows, int newColumns) {
        this(newRows, newColumns, new float[newRows * newColumns]);
    }

    public FloatMatrix() {
        this(0, 0, (float[])null);
    }

    public FloatMatrix(int len) {
        this(len, 1, new float[len]);
    }

    public FloatMatrix(float[] newData) {
        this(newData.length);
        this.data = newData;
    }

    public FloatMatrix(String filename) throws IOException {
        this.load(filename);
    }

    public FloatMatrix(float[][] data) {
        this(data.length, data[0].length);
        int r;
        for (r = 0; r < this.rows; ++r) {
            assert (data[r].length == this.columns);
        }
        for (r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                this.put(r, c, data[r][c]);
            }
        }
    }

    public FloatMatrix(List<Float> data) {
        this(data.size());
        int c = 0;
        for (Float d : data) {
            this.put(c++, d.floatValue());
        }
    }

    public static FloatMatrix valueOf(String text) {
        String[] rowValues = text.split(";");
        String[] columnValues = rowValues[0].trim().split("\\s+");
        FloatMatrix result = null;
        for (int r = 0; r < rowValues.length; ++r) {
            columnValues = rowValues[r].trim().split("\\s+");
            if (r == 0) {
                result = new FloatMatrix(rowValues.length, columnValues.length);
            }
            for (int c = 0; c < columnValues.length; ++c) {
                result.put(r, c, Float.valueOf(columnValues[c]).floatValue());
            }
        }
        return result;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    public static FloatMatrix rand(int rows, int columns) {
        FloatMatrix m = new FloatMatrix(rows, columns);
        for (int i = 0; i < rows * columns; ++i) {
            m.data[i] = Random.nextFloat();
        }
        return m;
    }

    public static FloatMatrix rand(int len) {
        return FloatMatrix.rand(len, 1);
    }

    public static FloatMatrix randn(int rows, int columns) {
        FloatMatrix m = new FloatMatrix(rows, columns);
        for (int i = 0; i < rows * columns; ++i) {
            m.data[i] = (float)Random.nextGaussian();
        }
        return m;
    }

    public static FloatMatrix randn(int len) {
        return FloatMatrix.randn(len, 1);
    }

    public static FloatMatrix zeros(int rows, int columns) {
        return new FloatMatrix(rows, columns);
    }

    public static FloatMatrix zeros(int length) {
        return FloatMatrix.zeros(length, 1);
    }

    public static FloatMatrix ones(int rows, int columns) {
        FloatMatrix m = new FloatMatrix(rows, columns);
        for (int i = 0; i < rows * columns; ++i) {
            m.put(i, 1.0f);
        }
        return m;
    }

    public static FloatMatrix ones(int length) {
        return FloatMatrix.ones(length, 1);
    }

    public static FloatMatrix eye(int n) {
        FloatMatrix m = new FloatMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            m.put(i, i, 1.0f);
        }
        return m;
    }

    public static FloatMatrix diag(FloatMatrix x) {
        FloatMatrix m = new FloatMatrix(x.length, x.length);
        for (int i = 0; i < x.length; ++i) {
            m.put(i, i, x.get(i));
        }
        return m;
    }

    public static FloatMatrix diag(FloatMatrix x, int rows, int columns) {
        FloatMatrix m = new FloatMatrix(rows, columns);
        for (int i = 0; i < x.length; ++i) {
            m.put(i, i, x.get(i));
        }
        return m;
    }

    public static FloatMatrix scalar(float s) {
        FloatMatrix m = new FloatMatrix(1, 1);
        m.put(0, 0, s);
        return m;
    }

    public boolean isScalar() {
        return this.length == 1;
    }

    public float scalar() {
        return this.get(0);
    }

    public static FloatMatrix logspace(float lower, float upper, int size) {
        FloatMatrix result = new FloatMatrix(size);
        for (int i = 0; i < size; ++i) {
            float t = (float)i / (float)(size - 1);
            float e = lower * (1.0f - t) + t * upper;
            result.put(i, (float)Math.pow(10.0, e));
        }
        return result;
    }

    public static FloatMatrix linspace(int lower, int upper, int size) {
        FloatMatrix result = new FloatMatrix(size);
        for (int i = 0; i < size; ++i) {
            float t = (float)i / (float)(size - 1);
            result.put(i, (float)lower * (1.0f - t) + t * (float)upper);
        }
        return result;
    }

    public static FloatMatrix concatHorizontally(FloatMatrix A, FloatMatrix B) {
        if (A.rows != B.rows) {
            throw new SizeException("Matrices don't have same number of rows.");
        }
        FloatMatrix result = new FloatMatrix(A.rows, A.columns + B.columns);
        SimpleBlas.copy(A, result);
        JavaBlas.rcopy(B.length, B.data, 0, 1, result.data, A.length, 1);
        return result;
    }

    public static FloatMatrix concatVertically(FloatMatrix A, FloatMatrix B) {
        if (A.columns != B.columns) {
            throw new SizeException("Matrices don't have same number of columns (" + A.columns + " != " + B.columns + ".");
        }
        FloatMatrix result = new FloatMatrix(A.rows + B.rows, A.columns);
        for (int i = 0; i < A.columns; ++i) {
            JavaBlas.rcopy(A.rows, A.data, A.index(0, i), 1, result.data, result.index(0, i), 1);
            JavaBlas.rcopy(B.rows, B.data, B.index(0, i), 1, result.data, result.index(A.rows, i), 1);
        }
        return result;
    }

    public FloatMatrix get(int[] indices) {
        FloatMatrix result = new FloatMatrix(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            result.put(i, this.get(indices[i]));
        }
        return result;
    }

    public FloatMatrix get(int r, int[] indices) {
        FloatMatrix result = new FloatMatrix(1, indices.length);
        for (int i = 0; i < indices.length; ++i) {
            result.put(i, this.get(r, indices[i]));
        }
        return result;
    }

    public FloatMatrix get(int[] indices, int c) {
        FloatMatrix result = new FloatMatrix(indices.length, 1);
        for (int i = 0; i < indices.length; ++i) {
            result.put(i, this.get(indices[i], c));
        }
        return result;
    }

    public FloatMatrix get(int[] rindices, int[] cindices) {
        FloatMatrix result = new FloatMatrix(rindices.length, cindices.length);
        for (int i = 0; i < rindices.length; ++i) {
            for (int j = 0; j < cindices.length; ++j) {
                result.put(i, j, this.get(rindices[i], cindices[j]));
            }
        }
        return result;
    }

    public FloatMatrix get(Range rs, Range cs) {
        rs.init(0, this.rows);
        cs.init(0, this.columns);
        FloatMatrix result = new FloatMatrix(rs.length(), cs.length());
        while (rs.hasMore()) {
            cs.init(0, this.columns);
            while (cs.hasMore()) {
                result.put(rs.index(), cs.index(), this.get(rs.value(), cs.value()));
                cs.next();
            }
            rs.next();
        }
        return result;
    }

    public FloatMatrix get(Range rs, int c) {
        rs.init(0, this.rows);
        FloatMatrix result = new FloatMatrix(rs.length(), 1);
        while (rs.hasMore()) {
            result.put(rs.index(), 0, this.get(rs.value(), c));
            rs.next();
        }
        return result;
    }

    public FloatMatrix get(int r, Range cs) {
        cs.init(0, this.columns);
        FloatMatrix result = new FloatMatrix(1, cs.length());
        while (cs.hasMore()) {
            result.put(0, cs.index(), this.get(r, cs.value()));
            cs.next();
        }
        return result;
    }

    public FloatMatrix get(FloatMatrix indices) {
        return this.get(indices.findIndices());
    }

    public FloatMatrix get(int r, FloatMatrix indices) {
        return this.get(r, indices.findIndices());
    }

    public FloatMatrix get(FloatMatrix indices, int c) {
        return this.get(indices.findIndices(), c);
    }

    public FloatMatrix get(FloatMatrix rindices, FloatMatrix cindices) {
        return this.get(rindices.findIndices(), cindices.findIndices());
    }

    public FloatMatrix getRange(int a, int b) {
        FloatMatrix result = new FloatMatrix(b - a);
        for (int k = 0; k < b - a; ++k) {
            result.put(k, this.get(a + k));
        }
        return result;
    }

    public FloatMatrix getColumnRange(int r, int a, int b) {
        FloatMatrix result = new FloatMatrix(1, b - a);
        for (int k = 0; k < b - a; ++k) {
            result.put(k, this.get(r, a + k));
        }
        return result;
    }

    public FloatMatrix getRowRange(int a, int b, int c) {
        FloatMatrix result = new FloatMatrix(b - a);
        for (int k = 0; k < b - a; ++k) {
            result.put(k, this.get(a + k, c));
        }
        return result;
    }

    public FloatMatrix getRange(int ra, int rb, int ca, int cb) {
        FloatMatrix result = new FloatMatrix(rb - ra, cb - ca);
        for (int i = 0; i < rb - ra; ++i) {
            for (int j = 0; j < cb - ca; ++j) {
                result.put(i, j, this.get(ra + i, ca + j));
            }
        }
        return result;
    }

    public FloatMatrix getRows(int[] rindices) {
        FloatMatrix result = new FloatMatrix(rindices.length, this.columns);
        for (int i = 0; i < rindices.length; ++i) {
            JavaBlas.rcopy(this.columns, this.data, this.index(rindices[i], 0), this.rows, result.data, result.index(i, 0), result.rows);
        }
        return result;
    }

    public FloatMatrix getRows(FloatMatrix rindices) {
        return this.getRows(rindices.findIndices());
    }

    public FloatMatrix getRows(Range indices, FloatMatrix result) {
        indices.init(0, this.rows);
        if (result.rows < indices.length()) {
            throw new SizeException("Result matrix does not have enough rows (" + result.rows + " < " + indices.length() + ")");
        }
        result.checkColumns(this.columns);
        for (int c = 0; c < this.columns; ++c) {
            indices.init(0, this.rows);
            int r = 0;
            while (indices.hasMore()) {
                result.put(r, c, this.get(indices.index(), c));
                indices.next();
                ++r;
            }
        }
        return result;
    }

    public FloatMatrix getRows(Range indices) {
        indices.init(0, this.rows);
        FloatMatrix result = new FloatMatrix(indices.length(), this.columns);
        return this.getRows(indices, result);
    }

    public FloatMatrix getColumns(int[] cindices) {
        FloatMatrix result = new FloatMatrix(this.rows, cindices.length);
        for (int i = 0; i < cindices.length; ++i) {
            JavaBlas.rcopy(this.rows, this.data, this.index(0, cindices[i]), 1, result.data, result.index(0, i), 1);
        }
        return result;
    }

    public FloatMatrix getColumns(FloatMatrix cindices) {
        return this.getColumns(cindices.findIndices());
    }

    public void checkLength(int l) {
        if (this.length != l) {
            throw new SizeException("Matrix does not have the necessary length (" + this.length + " != " + l + ").");
        }
    }

    public void checkRows(int r) {
        if (this.rows != r) {
            throw new SizeException("Matrix does not have the necessary number of rows (" + this.rows + " != " + r + ").");
        }
    }

    public void checkColumns(int c) {
        if (this.columns != c) {
            throw new SizeException("Matrix does not have the necessary number of columns (" + this.columns + " != " + c + ").");
        }
    }

    public FloatMatrix put(int[] indices, FloatMatrix x) {
        if (x.isScalar()) {
            return this.put(indices, x.scalar());
        }
        x.checkLength(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            this.put(indices[i], x.get(i));
        }
        return this;
    }

    public FloatMatrix put(int r, int[] indices, FloatMatrix x) {
        if (x.isScalar()) {
            return this.put(r, indices, x.scalar());
        }
        x.checkColumns(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            this.put(r, indices[i], x.get(i));
        }
        return this;
    }

    public FloatMatrix put(int[] indices, int c, FloatMatrix x) {
        if (x.isScalar()) {
            return this.put(indices, c, x.scalar());
        }
        x.checkRows(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            this.put(indices[i], c, x.get(i));
        }
        return this;
    }

    public FloatMatrix put(int[] rindices, int[] cindices, FloatMatrix x) {
        if (x.isScalar()) {
            return this.put(rindices, cindices, x.scalar());
        }
        x.checkRows(rindices.length);
        x.checkColumns(cindices.length);
        for (int i = 0; i < rindices.length; ++i) {
            for (int j = 0; j < cindices.length; ++j) {
                this.put(rindices[i], cindices[j], x.get(i, j));
            }
        }
        return this;
    }

    public FloatMatrix put(Range rs, Range cs, FloatMatrix x) {
        rs.init(0, this.rows);
        cs.init(0, this.columns);
        x.checkRows(rs.length());
        x.checkColumns(cs.length());
        while (rs.hasMore()) {
            cs.init(0, this.columns);
            while (cs.hasMore()) {
                this.put(rs.value(), cs.value(), x.get(rs.index(), cs.index()));
                cs.next();
            }
            rs.next();
        }
        return this;
    }

    public FloatMatrix put(int[] indices, float v) {
        for (int i = 0; i < indices.length; ++i) {
            this.put(indices[i], v);
        }
        return this;
    }

    public FloatMatrix put(int r, int[] indices, float v) {
        for (int i = 0; i < indices.length; ++i) {
            this.put(r, indices[i], v);
        }
        return this;
    }

    public FloatMatrix put(int[] indices, int c, float v) {
        for (int i = 0; i < indices.length; ++i) {
            this.put(indices[i], c, v);
        }
        return this;
    }

    public FloatMatrix put(int[] rindices, int[] cindices, float v) {
        for (int i = 0; i < rindices.length; ++i) {
            for (int j = 0; j < cindices.length; ++j) {
                this.put(rindices[i], cindices[j], v);
            }
        }
        return this;
    }

    public FloatMatrix put(FloatMatrix indices, FloatMatrix v) {
        return this.put(indices.findIndices(), v);
    }

    public FloatMatrix put(int r, FloatMatrix indices, FloatMatrix v) {
        return this.put(r, indices.findIndices(), v);
    }

    public FloatMatrix put(FloatMatrix indices, int c, FloatMatrix v) {
        return this.put(indices.findIndices(), c, v);
    }

    public FloatMatrix put(FloatMatrix rindices, FloatMatrix cindices, FloatMatrix v) {
        return this.put(rindices.findIndices(), cindices.findIndices(), v);
    }

    public FloatMatrix put(FloatMatrix indices, float v) {
        return this.put(indices.findIndices(), v);
    }

    public FloatMatrix put(int r, FloatMatrix indices, float v) {
        return this.put(r, indices.findIndices(), v);
    }

    public FloatMatrix put(FloatMatrix indices, int c, float v) {
        return this.put(indices.findIndices(), c, v);
    }

    public FloatMatrix put(FloatMatrix rindices, FloatMatrix cindices, float v) {
        return this.put(rindices.findIndices(), cindices.findIndices(), v);
    }

    public int[] findIndices() {
        int len = 0;
        for (int i = 0; i < this.length; ++i) {
            if (this.get(i) == 0.0f) continue;
            ++len;
        }
        int[] indices = new int[len];
        int c = 0;
        for (int i = 0; i < this.length; ++i) {
            if (this.get(i) == 0.0f) continue;
            indices[c++] = i;
        }
        return indices;
    }

    public FloatMatrix transpose() {
        FloatMatrix result = new FloatMatrix(this.columns, this.rows);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.put(j, i, this.get(i, j));
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FloatMatrix)) {
            return false;
        }
        FloatMatrix other = (FloatMatrix)o;
        if (!this.sameSize(other)) {
            return false;
        }
        FloatMatrix diff = MatrixFunctions.absi(this.sub(other));
        return (double)(diff.max() / (float)(this.rows * this.columns)) < 1.0E-6;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + this.rows;
        hash = 83 * hash + this.columns;
        hash = 83 * hash + Arrays.hashCode(this.data);
        return hash;
    }

    public void resize(int newRows, int newColumns) {
        this.rows = newRows;
        this.columns = newColumns;
        this.length = newRows * newColumns;
        this.data = new float[this.rows * this.columns];
    }

    public FloatMatrix reshape(int newRows, int newColumns) {
        if (this.length != newRows * newColumns) {
            throw new IllegalArgumentException("Number of elements must not change.");
        }
        this.rows = newRows;
        this.columns = newColumns;
        return this;
    }

    public FloatMatrix repmat(int rowMult, int columnMult) {
        FloatMatrix result = new FloatMatrix(this.rows * rowMult, this.columns * columnMult);
        for (int c = 0; c < columnMult; ++c) {
            for (int r = 0; r < rowMult; ++r) {
                for (int i = 0; i < this.rows; ++i) {
                    for (int j = 0; j < this.columns; ++j) {
                        result.put(r * this.rows + i, c * this.columns + j, this.get(i, j));
                    }
                }
            }
        }
        return result;
    }

    public boolean sameSize(FloatMatrix a) {
        return this.rows == a.rows && this.columns == a.columns;
    }

    public void assertSameSize(FloatMatrix a) {
        if (!this.sameSize(a)) {
            throw new SizeException("Matrices must have the same size.");
        }
    }

    public boolean multipliesWith(FloatMatrix a) {
        return this.columns == a.rows;
    }

    public void assertMultipliesWith(FloatMatrix a) {
        if (!this.multipliesWith(a)) {
            throw new SizeException("Number of columns of left matrix must be equal to number of rows of right matrix.");
        }
    }

    public boolean sameLength(FloatMatrix a) {
        return this.length == a.length;
    }

    public void assertSameLength(FloatMatrix a) {
        if (!this.sameLength(a)) {
            throw new SizeException("Matrices must have same length (is: " + this.length + " and " + a.length + ")");
        }
    }

    public FloatMatrix copy(FloatMatrix a) {
        if (!this.sameSize(a)) {
            this.resize(a.rows, a.columns);
        }
        System.arraycopy(a.data, 0, this.data, 0, this.length);
        return a;
    }

    public FloatMatrix dup() {
        FloatMatrix out = new FloatMatrix(this.rows, this.columns);
        JavaBlas.rcopy(this.length, this.data, 0, 1, out.data, 0, 1);
        return out;
    }

    public FloatMatrix swapColumns(int i, int j) {
        NativeBlas.sswap(this.rows, this.data, this.index(0, i), 1, this.data, this.index(0, j), 1);
        return this;
    }

    public FloatMatrix swapRows(int i, int j) {
        NativeBlas.sswap(this.columns, this.data, this.index(i, 0), this.rows, this.data, this.index(j, 0), this.rows);
        return this;
    }

    public FloatMatrix put(int rowIndex, int columnIndex, float value) {
        this.data[this.index((int)rowIndex, (int)columnIndex)] = value;
        return this;
    }

    public float get(int rowIndex, int columnIndex) {
        return this.data[this.index(rowIndex, columnIndex)];
    }

    public int index(int rowIndex, int columnIndex) {
        return rowIndex + this.rows * columnIndex;
    }

    public int indexRows(int i) {
        return i / this.rows;
    }

    public int indexColumns(int i) {
        return i - this.indexRows(i) * this.rows;
    }

    public float get(int i) {
        return this.data[i];
    }

    public FloatMatrix put(int i, float v) {
        this.data[i] = v;
        return this;
    }

    public FloatMatrix fill(float value) {
        for (int i = 0; i < this.length; ++i) {
            this.put(i, value);
        }
        return this;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.columns == 0 || this.rows == 0;
    }

    public boolean isSquare() {
        return this.columns == this.rows;
    }

    public void assertSquare() {
        if (!this.isSquare()) {
            throw new SizeException("Matrix must be square!");
        }
    }

    public boolean isVector() {
        return this.columns == 1 || this.rows == 1;
    }

    public boolean isRowVector() {
        return this.rows == 1;
    }

    public boolean isColumnVector() {
        return this.columns == 1;
    }

    public FloatMatrix diag() {
        this.assertSquare();
        FloatMatrix d = new FloatMatrix(this.rows);
        JavaBlas.rcopy(this.rows, this.data, 0, this.rows + 1, d.data, 0, 1);
        return d;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        return this.toString("%f");
    }

    public String toString(String fmt) {
        return this.toString(fmt, "[", "]", ", ", "; ");
    }

    public String toString(String fmt, String open, String close, String colSep, String rowSep) {
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        p.print(open);
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                p.printf(fmt, Float.valueOf(this.get(r, c)));
                if (c >= this.columns - 1) continue;
                p.print(colSep);
            }
            if (r >= this.rows - 1) continue;
            p.print(rowSep);
        }
        p.print(close);
        return s.toString();
    }

    public float[] toArray() {
        float[] array = new float[this.length];
        System.arraycopy(this.data, 0, array, 0, this.length);
        return array;
    }

    public float[][] toArray2() {
        float[][] array = new float[this.rows][this.columns];
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                array[r][c] = this.get(r, c);
            }
        }
        return array;
    }

    public int[] toIntArray() {
        int[] array = new int[this.length];
        for (int i = 0; i < this.length; ++i) {
            array[i] = (int)Math.rint(this.get(i));
        }
        return array;
    }

    public int[][] toIntArray2() {
        int[][] array = new int[this.rows][this.columns];
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                array[r][c] = (int)Math.rint(this.get(r, c));
            }
        }
        return array;
    }

    public boolean[] toBooleanArray() {
        boolean[] array = new boolean[this.length];
        for (int i = 0; i < this.length; ++i) {
            array[i] = this.get(i) != 0.0f;
        }
        return array;
    }

    public boolean[][] toBooleanArray2() {
        boolean[][] array = new boolean[this.rows][this.columns];
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                array[r][c] = this.get(r, c) != 0.0f;
            }
        }
        return array;
    }

    public FloatMatrix toFloat() {
        FloatMatrix result = new FloatMatrix(this.rows, this.columns);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i));
        }
        return result;
    }

    public List<Float> elementsAsList() {
        return new ElementsAsListView(this);
    }

    public List<FloatMatrix> rowsAsList() {
        return new RowsAsListView(this);
    }

    public List<FloatMatrix> columnsAsList() {
        return new ColumnsAsListView(this);
    }

    private void ensureResultLength(FloatMatrix other, FloatMatrix result) {
        if (!this.sameLength(result)) {
            if (result == this || result == other) {
                throw new SizeException("Cannot resize result matrix because it is used in-place.");
            }
            result.resize(this.rows, this.columns);
        }
    }

    public FloatMatrix addi(FloatMatrix other, FloatMatrix result) {
        if (other.isScalar()) {
            return this.addi(other.scalar(), result);
        }
        if (this.isScalar()) {
            return other.addi(this.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        if (result == this) {
            SimpleBlas.axpy(1.0f, other, result);
        } else if (result == other) {
            SimpleBlas.axpy(1.0f, this, result);
        } else {
            JavaBlas.rzgxpy(this.length, result.data, this.data, other.data);
        }
        return result;
    }

    public FloatMatrix addi(float v, FloatMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) + v);
        }
        return result;
    }

    public FloatMatrix subi(FloatMatrix other, FloatMatrix result) {
        if (other.isScalar()) {
            return this.subi(other.scalar(), result);
        }
        if (this.isScalar()) {
            return other.rsubi(this.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        if (result == this) {
            SimpleBlas.axpy(-1.0f, other, result);
        } else if (result == other) {
            SimpleBlas.scal(-1.0f, result);
            SimpleBlas.axpy(1.0f, this, result);
        } else {
            SimpleBlas.copy(this, result);
            SimpleBlas.axpy(-1.0f, other, result);
        }
        return result;
    }

    public FloatMatrix subi(float v, FloatMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) - v);
        }
        return result;
    }

    public FloatMatrix rsubi(FloatMatrix other, FloatMatrix result) {
        return other.subi(this, result);
    }

    public FloatMatrix rsubi(float a, FloatMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, a - this.get(i));
        }
        return result;
    }

    public FloatMatrix muli(FloatMatrix other, FloatMatrix result) {
        if (other.isScalar()) {
            return this.muli(other.scalar(), result);
        }
        if (this.isScalar()) {
            return other.muli(this.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) * other.get(i));
        }
        return result;
    }

    public FloatMatrix muli(float v, FloatMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) * v);
        }
        return result;
    }

    public FloatMatrix mmuli(FloatMatrix other, FloatMatrix result) {
        if (other.isScalar()) {
            return this.muli(other.scalar(), result);
        }
        if (this.isScalar()) {
            return other.muli(this.scalar(), result);
        }
        this.assertMultipliesWith(other);
        if (result.rows != this.rows || result.columns != other.columns) {
            if (result != this && result != other) {
                result.resize(this.rows, other.columns);
            } else {
                throw new SizeException("Cannot resize result matrix because it is used in-place.");
            }
        }
        if (result == this || result == other) {
            FloatMatrix temp = new FloatMatrix(result.rows, result.columns);
            if (other.columns == 1) {
                SimpleBlas.gemv(1.0f, this, other, 0.0f, temp);
            } else {
                SimpleBlas.gemm(1.0f, this, other, 0.0f, temp);
            }
            SimpleBlas.copy(temp, result);
        } else if (other.columns == 1) {
            SimpleBlas.gemv(1.0f, this, other, 0.0f, result);
        } else {
            SimpleBlas.gemm(1.0f, this, other, 0.0f, result);
        }
        return result;
    }

    public FloatMatrix mmuli(float v, FloatMatrix result) {
        return this.muli(v, result);
    }

    public FloatMatrix divi(FloatMatrix other, FloatMatrix result) {
        if (other.isScalar()) {
            return this.divi(other.scalar(), result);
        }
        if (this.isScalar()) {
            return other.rdivi(this.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) / other.get(i));
        }
        return result;
    }

    public FloatMatrix divi(float a, FloatMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) / a);
        }
        return result;
    }

    public FloatMatrix rdivi(FloatMatrix other, FloatMatrix result) {
        return other.divi(this, result);
    }

    public FloatMatrix rdivi(float a, FloatMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, a / this.get(i));
        }
        return result;
    }

    public FloatMatrix negi() {
        for (int i = 0; i < this.length; ++i) {
            this.put(i, -this.get(i));
        }
        return this;
    }

    public FloatMatrix neg() {
        return this.dup().negi();
    }

    public FloatMatrix noti() {
        for (int i = 0; i < this.length; ++i) {
            this.put(i, this.get(i) == 0.0f ? 1.0f : 0.0f);
        }
        return this;
    }

    public FloatMatrix not() {
        return this.dup().noti();
    }

    public FloatMatrix truthi() {
        for (int i = 0; i < this.length; ++i) {
            this.put(i, this.get(i) == 0.0f ? 0.0f : 1.0f);
        }
        return this;
    }

    public FloatMatrix truth() {
        return this.dup().truthi();
    }

    public FloatMatrix isNaNi() {
        for (int i = 0; i < this.length; ++i) {
            this.put(i, Float.isNaN(this.get(i)) ? 1.0f : 0.0f);
        }
        return this;
    }

    public FloatMatrix isNaN() {
        return this.dup().isNaNi();
    }

    public FloatMatrix isInfinitei() {
        for (int i = 0; i < this.length; ++i) {
            this.put(i, Float.isInfinite(this.get(i)) ? 1.0f : 0.0f);
        }
        return this;
    }

    public FloatMatrix isInfinite() {
        return this.dup().isInfinitei();
    }

    public boolean isLowerTriangular() {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = i + 1; j < this.columns; ++j) {
                if (this.get(i, j) == 0.0f) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUpperTriangular() {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < i && j < this.columns; ++j) {
                if (this.get(i, j) == 0.0f) continue;
                return false;
            }
        }
        return true;
    }

    public FloatMatrix selecti(FloatMatrix where) {
        this.checkLength(where.length);
        for (int i = 0; i < this.length; ++i) {
            if (where.get(i) != 0.0f) continue;
            this.put(i, 0.0f);
        }
        return this;
    }

    public FloatMatrix select(FloatMatrix where) {
        return this.dup().selecti(where);
    }

    public FloatMatrix rankOneUpdate(float alpha, FloatMatrix x, FloatMatrix y) {
        if (this.rows != x.length) {
            throw new SizeException("Vector x has wrong length (" + x.length + " != " + this.rows + ").");
        }
        if (this.columns != y.length) {
            throw new SizeException("Vector y has wrong length (" + x.length + " != " + this.columns + ").");
        }
        SimpleBlas.ger(alpha, x, y, this);
        return this;
    }

    public FloatMatrix rankOneUpdate(float alpha, FloatMatrix x) {
        return this.rankOneUpdate(alpha, x, x);
    }

    public FloatMatrix rankOneUpdate(FloatMatrix x) {
        return this.rankOneUpdate(1.0f, x, x);
    }

    public FloatMatrix rankOneUpdate(FloatMatrix x, FloatMatrix y) {
        return this.rankOneUpdate(1.0f, x, y);
    }

    public float min() {
        if (this.isEmpty()) {
            return Float.POSITIVE_INFINITY;
        }
        float v = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this.length; ++i) {
            if (Float.isNaN(this.get(i)) || !(this.get(i) < v)) continue;
            v = this.get(i);
        }
        return v;
    }

    public int argmin() {
        if (this.isEmpty()) {
            return -1;
        }
        float v = Float.POSITIVE_INFINITY;
        int a = -1;
        for (int i = 0; i < this.length; ++i) {
            if (Float.isNaN(this.get(i)) || !(this.get(i) < v)) continue;
            v = this.get(i);
            a = i;
        }
        return a;
    }

    public FloatMatrix mini(FloatMatrix other, FloatMatrix result) {
        if (result == this) {
            for (int i = 0; i < this.length; ++i) {
                if (!(this.get(i) > other.get(i))) continue;
                this.put(i, other.get(i));
            }
        } else {
            for (int i = 0; i < this.length; ++i) {
                if (this.get(i) > other.get(i)) {
                    result.put(i, other.get(i));
                    continue;
                }
                result.put(i, this.get(i));
            }
        }
        return result;
    }

    public FloatMatrix mini(FloatMatrix other) {
        return this.mini(other, this);
    }

    public FloatMatrix min(FloatMatrix other) {
        return this.mini(other, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix mini(float v, FloatMatrix result) {
        if (result == this) {
            for (int i = 0; i < this.length; ++i) {
                if (!(this.get(i) > v)) continue;
                result.put(i, v);
            }
        } else {
            for (int i = 0; i < this.length; ++i) {
                if (this.get(i) > v) {
                    result.put(i, v);
                    continue;
                }
                result.put(i, this.get(i));
            }
        }
        return result;
    }

    public FloatMatrix mini(float v) {
        return this.mini(v, this);
    }

    public FloatMatrix min(float v) {
        return this.mini(v, new FloatMatrix(this.rows, this.columns));
    }

    public float max() {
        if (this.isEmpty()) {
            return Float.NEGATIVE_INFINITY;
        }
        float v = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < this.length; ++i) {
            if (Float.isNaN(this.get(i)) || !(this.get(i) > v)) continue;
            v = this.get(i);
        }
        return v;
    }

    public int argmax() {
        if (this.isEmpty()) {
            return -1;
        }
        float v = Float.NEGATIVE_INFINITY;
        int a = -1;
        for (int i = 0; i < this.length; ++i) {
            if (Float.isNaN(this.get(i)) || !(this.get(i) > v)) continue;
            v = this.get(i);
            a = i;
        }
        return a;
    }

    public FloatMatrix maxi(FloatMatrix other, FloatMatrix result) {
        if (result == this) {
            for (int i = 0; i < this.length; ++i) {
                if (!(this.get(i) < other.get(i))) continue;
                this.put(i, other.get(i));
            }
        } else {
            for (int i = 0; i < this.length; ++i) {
                if (this.get(i) < other.get(i)) {
                    result.put(i, other.get(i));
                    continue;
                }
                result.put(i, this.get(i));
            }
        }
        return result;
    }

    public FloatMatrix maxi(FloatMatrix other) {
        return this.maxi(other, this);
    }

    public FloatMatrix max(FloatMatrix other) {
        return this.maxi(other, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix maxi(float v, FloatMatrix result) {
        if (result == this) {
            for (int i = 0; i < this.length; ++i) {
                if (!(this.get(i) < v)) continue;
                result.put(i, v);
            }
        } else {
            for (int i = 0; i < this.length; ++i) {
                if (this.get(i) < v) {
                    result.put(i, v);
                    continue;
                }
                result.put(i, this.get(i));
            }
        }
        return result;
    }

    public FloatMatrix maxi(float v) {
        return this.maxi(v, this);
    }

    public FloatMatrix max(float v) {
        return this.maxi(v, new FloatMatrix(this.rows, this.columns));
    }

    public float sum() {
        float s = 0.0f;
        for (int i = 0; i < this.length; ++i) {
            s += this.get(i);
        }
        return s;
    }

    public float prod() {
        float p = 1.0f;
        for (int i = 0; i < this.length; ++i) {
            p *= this.get(i);
        }
        return p;
    }

    public float mean() {
        return this.sum() / (float)this.length;
    }

    public FloatMatrix cumulativeSumi() {
        float s = 0.0f;
        for (int i = 0; i < this.length; ++i) {
            this.put(i, s += this.get(i));
        }
        return this;
    }

    public FloatMatrix cumulativeSum() {
        return this.dup().cumulativeSumi();
    }

    public float dot(FloatMatrix other) {
        return SimpleBlas.dot(this, other);
    }

    public float project(FloatMatrix other) {
        other.checkLength(this.length);
        float norm = 0.0f;
        float dot = 0.0f;
        for (int i = 0; i < this.length; ++i) {
            float x = this.get(i);
            norm += x * x;
            dot += x * other.get(i);
        }
        return dot / norm;
    }

    public float norm2() {
        float norm = 0.0f;
        for (int i = 0; i < this.length; ++i) {
            norm += this.get(i) * this.get(i);
        }
        return (float)Math.sqrt(norm);
    }

    public float normmax() {
        float max = 0.0f;
        for (int i = 0; i < this.length; ++i) {
            float a = Math.abs(this.get(i));
            if (!(a > max)) continue;
            max = a;
        }
        return max;
    }

    public float norm1() {
        float norm = 0.0f;
        for (int i = 0; i < this.length; ++i) {
            norm += Math.abs(this.get(i));
        }
        return norm;
    }

    public float squaredDistance(FloatMatrix other) {
        other.checkLength(this.length);
        float sd = 0.0f;
        for (int i = 0; i < this.length; ++i) {
            float d = this.get(i) - other.get(i);
            sd += d * d;
        }
        return sd;
    }

    public float distance2(FloatMatrix other) {
        return (float)Math.sqrt(this.squaredDistance(other));
    }

    public float distance1(FloatMatrix other) {
        other.checkLength(this.length);
        float d = 0.0f;
        for (int i = 0; i < this.length; ++i) {
            d += Math.abs(this.get(i) - other.get(i));
        }
        return d;
    }

    public FloatMatrix sort() {
        float[] array = this.toArray();
        Arrays.sort(array);
        return new FloatMatrix(this.rows, this.columns, array);
    }

    public FloatMatrix sorti() {
        Arrays.sort(this.data);
        return this;
    }

    public int[] sortingPermutation() {
        Integer[] indices = new Integer[this.length];
        for (int i = 0; i < this.length; ++i) {
            indices[i] = i;
        }
        final float[] array = this.data;
        Arrays.sort(indices, new Comparator(){

            public int compare(Object o1, Object o2) {
                int j;
                int i = (Integer)o1;
                if (array[i] < array[j = ((Integer)o2).intValue()]) {
                    return -1;
                }
                if (array[i] == array[j]) {
                    return 0;
                }
                return 1;
            }
        });
        int[] result = new int[this.length];
        for (int i = 0; i < this.length; ++i) {
            result[i] = indices[i];
        }
        return result;
    }

    public FloatMatrix sortColumnsi() {
        for (int i = 0; i < this.length; i += this.rows) {
            Arrays.sort(this.data, i, i + this.rows);
        }
        return this;
    }

    public FloatMatrix sortColumns() {
        return this.dup().sortColumnsi();
    }

    public int[][] columnSortingPermutations() {
        int[][] result = new int[this.columns][];
        FloatMatrix temp = new FloatMatrix(this.rows);
        for (int c = 0; c < this.columns; ++c) {
            result[c] = this.getColumn(c, temp).sortingPermutation();
        }
        return result;
    }

    public FloatMatrix sortRowsi() {
        FloatMatrix temp = new FloatMatrix(this.columns);
        for (int r = 0; r < this.rows; ++r) {
            this.putRow(r, this.getRow(r, temp).sorti());
        }
        return this;
    }

    public FloatMatrix sortRows() {
        return this.dup().sortRowsi();
    }

    public int[][] rowSortingPermutations() {
        int[][] result = new int[this.rows][];
        FloatMatrix temp = new FloatMatrix(this.columns);
        for (int r = 0; r < this.rows; ++r) {
            result[r] = this.getRow(r, temp).sortingPermutation();
        }
        return result;
    }

    public FloatMatrix columnSums() {
        if (this.rows == 1) {
            return this.dup();
        }
        FloatMatrix v = new FloatMatrix(1, this.columns);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                v.put(c, v.get(c) + this.get(r, c));
            }
        }
        return v;
    }

    public FloatMatrix columnMeans() {
        return this.columnSums().divi(this.rows);
    }

    public FloatMatrix rowSums() {
        if (this.columns == 1) {
            return this.dup();
        }
        FloatMatrix v = new FloatMatrix(this.rows);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                v.put(r, v.get(r) + this.get(r, c));
            }
        }
        return v;
    }

    public FloatMatrix rowMeans() {
        return this.rowSums().divi(this.columns);
    }

    public FloatMatrix getColumn(int c) {
        return this.getColumn(c, new FloatMatrix(this.rows, 1));
    }

    public FloatMatrix getColumn(int c, FloatMatrix result) {
        result.checkLength(this.rows);
        JavaBlas.rcopy(this.rows, this.data, this.index(0, c), 1, result.data, 0, 1);
        return result;
    }

    public void putColumn(int c, FloatMatrix v) {
        JavaBlas.rcopy(this.rows, v.data, 0, 1, this.data, this.index(0, c), 1);
    }

    public FloatMatrix getRow(int r) {
        return this.getRow(r, new FloatMatrix(1, this.columns));
    }

    public FloatMatrix getRow(int r, FloatMatrix result) {
        result.checkLength(this.columns);
        JavaBlas.rcopy(this.columns, this.data, this.index(r, 0), this.rows, result.data, 0, 1);
        return result;
    }

    public void putRow(int r, FloatMatrix v) {
        JavaBlas.rcopy(this.columns, v.data, 0, 1, this.data, this.index(r, 0), this.rows);
    }

    public FloatMatrix columnMins() {
        FloatMatrix mins = new FloatMatrix(1, this.columns);
        for (int c = 0; c < this.columns; ++c) {
            mins.put(c, this.getColumn(c).min());
        }
        return mins;
    }

    public int[] columnArgmins() {
        int[] argmins = new int[this.columns];
        for (int c = 0; c < this.columns; ++c) {
            argmins[c] = this.getColumn(c).argmin();
        }
        return argmins;
    }

    public FloatMatrix columnMaxs() {
        FloatMatrix maxs = new FloatMatrix(1, this.columns);
        for (int c = 0; c < this.columns; ++c) {
            maxs.put(c, this.getColumn(c).max());
        }
        return maxs;
    }

    public int[] columnArgmaxs() {
        int[] argmaxs = new int[this.columns];
        for (int c = 0; c < this.columns; ++c) {
            argmaxs[c] = this.getColumn(c).argmax();
        }
        return argmaxs;
    }

    public FloatMatrix rowMins() {
        FloatMatrix mins = new FloatMatrix(this.rows);
        for (int c = 0; c < this.rows; ++c) {
            mins.put(c, this.getRow(c).min());
        }
        return mins;
    }

    public int[] rowArgmins() {
        int[] argmins = new int[this.rows];
        for (int c = 0; c < this.rows; ++c) {
            argmins[c] = this.getRow(c).argmin();
        }
        return argmins;
    }

    public FloatMatrix rowMaxs() {
        FloatMatrix maxs = new FloatMatrix(this.rows);
        for (int c = 0; c < this.rows; ++c) {
            maxs.put(c, this.getRow(c).max());
        }
        return maxs;
    }

    public int[] rowArgmaxs() {
        int[] argmaxs = new int[this.rows];
        for (int c = 0; c < this.rows; ++c) {
            argmaxs[c] = this.getRow(c).argmax();
        }
        return argmaxs;
    }

    public FloatMatrix addiRowVector(FloatMatrix x) {
        x.checkLength(this.columns);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                this.put(r, c, this.get(r, c) + x.get(c));
            }
        }
        return this;
    }

    public FloatMatrix addRowVector(FloatMatrix x) {
        return this.dup().addiRowVector(x);
    }

    public FloatMatrix addiColumnVector(FloatMatrix x) {
        x.checkLength(this.rows);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                this.put(r, c, this.get(r, c) + x.get(r));
            }
        }
        return this;
    }

    public FloatMatrix addColumnVector(FloatMatrix x) {
        return this.dup().addiColumnVector(x);
    }

    public FloatMatrix subiRowVector(FloatMatrix x) {
        x.checkLength(this.columns);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                this.put(r, c, this.get(r, c) - x.get(c));
            }
        }
        return this;
    }

    public FloatMatrix subRowVector(FloatMatrix x) {
        return this.dup().subiRowVector(x);
    }

    public FloatMatrix subiColumnVector(FloatMatrix x) {
        x.checkLength(this.rows);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                this.put(r, c, this.get(r, c) - x.get(r));
            }
        }
        return this;
    }

    public FloatMatrix subColumnVector(FloatMatrix x) {
        return this.dup().subiColumnVector(x);
    }

    public FloatMatrix mulRow(int r, float scale) {
        NativeBlas.sscal(this.columns, scale, this.data, this.index(r, 0), this.rows);
        return this;
    }

    public FloatMatrix mulColumn(int c, float scale) {
        NativeBlas.sscal(this.rows, scale, this.data, this.index(0, c), 1);
        return this;
    }

    public FloatMatrix muliColumnVector(FloatMatrix x) {
        x.checkLength(this.rows);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                this.put(r, c, this.get(r, c) * x.get(r));
            }
        }
        return this;
    }

    public FloatMatrix mulColumnVector(FloatMatrix x) {
        return this.dup().muliColumnVector(x);
    }

    public FloatMatrix muliRowVector(FloatMatrix x) {
        x.checkLength(this.columns);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                this.put(r, c, this.get(r, c) * x.get(c));
            }
        }
        return this;
    }

    public FloatMatrix mulRowVector(FloatMatrix x) {
        return this.dup().muliRowVector(x);
    }

    public FloatMatrix diviRowVector(FloatMatrix x) {
        x.checkLength(this.columns);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                this.put(r, c, this.get(r, c) / x.get(c));
            }
        }
        return this;
    }

    public FloatMatrix divRowVector(FloatMatrix x) {
        return this.dup().diviRowVector(x);
    }

    public FloatMatrix diviColumnVector(FloatMatrix x) {
        x.checkLength(this.rows);
        for (int c = 0; c < this.columns; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                this.put(r, c, this.get(r, c) / x.get(r));
            }
        }
        return this;
    }

    public FloatMatrix divColumnVector(FloatMatrix x) {
        return this.dup().diviColumnVector(x);
    }

    public void out(DataOutputStream dos) throws IOException {
        dos.writeUTF("float");
        dos.writeInt(this.columns);
        dos.writeInt(this.rows);
        dos.writeInt(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            dos.writeDouble(this.data[i]);
        }
    }

    public void in(DataInputStream dis) throws IOException {
        if (!dis.readUTF().equals("float")) {
            throw new IllegalStateException("The matrix in the specified file is not of the correct type!");
        }
        this.columns = dis.readInt();
        this.rows = dis.readInt();
        int MAX = dis.readInt();
        this.data = new float[MAX];
        for (int i = 0; i < MAX; ++i) {
            this.data[i] = dis.readFloat();
        }
    }

    public void save(String filename) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(filename, false));
        this.out(dos);
        dos.close();
    }

    public void load(String filename) throws IOException {
        DataInputStream dis = new DataInputStream(new FileInputStream(filename));
        this.in(dis);
        dis.close();
    }

    public static FloatMatrix loadAsciiFile(String filename) throws IOException {
        String line;
        BufferedReader is = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
        int rows = 0;
        int columns = -1;
        while ((line = is.readLine()) != null) {
            String[] elements = line.split("\\s+");
            int numElements = elements.length;
            if (elements[0].length() == 0) {
                --numElements;
            }
            if (elements[elements.length - 1].length() == 0) {
                --numElements;
            }
            if (columns == -1) {
                columns = numElements;
            } else if (columns != numElements) {
                throw new IOException("Number of elements changes in line " + line + ".");
            }
            ++rows;
        }
        is.close();
        is = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
        FloatMatrix result = new FloatMatrix(rows, columns);
        int r = 0;
        while ((line = is.readLine()) != null) {
            String[] elements = line.split("\\s+");
            int firstElement = elements[0].length() == 0 ? 1 : 0;
            int c = 0;
            int cc = firstElement;
            while (c < columns) {
                result.put(r, c, Float.valueOf(elements[cc]).floatValue());
                ++c;
                ++cc;
            }
            ++r;
        }
        return result;
    }

    public static FloatMatrix loadCSVFile(String filename) throws IOException {
        String line;
        BufferedReader is = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
        LinkedList<FloatMatrix> rows = new LinkedList<FloatMatrix>();
        int columns = -1;
        while ((line = is.readLine()) != null) {
            String[] elements = line.split(",");
            int numElements = elements.length;
            if (elements[0].length() == 0) {
                --numElements;
            }
            if (elements[elements.length - 1].length() == 0) {
                --numElements;
            }
            if (columns == -1) {
                columns = numElements;
            } else if (columns != numElements) {
                throw new IOException("Number of elements changes in line " + line + ".");
            }
            FloatMatrix row = new FloatMatrix(columns);
            for (int c = 0; c < columns; ++c) {
                row.put(c, Float.valueOf(elements[c]).floatValue());
            }
            rows.add(row);
        }
        is.close();
        System.out.println("Done reading file");
        FloatMatrix result = new FloatMatrix(rows.size(), columns);
        int r = 0;
        Iterator ri = rows.iterator();
        while (ri.hasNext()) {
            result.putRow(r, (FloatMatrix)ri.next());
            ++r;
        }
        return result;
    }

    public FloatMatrix addi(FloatMatrix other) {
        return this.addi(other, this);
    }

    public FloatMatrix add(FloatMatrix other) {
        return this.addi(other, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix addi(float v) {
        return this.addi(v, this);
    }

    public FloatMatrix add(float v) {
        return this.addi(v, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix subi(FloatMatrix other) {
        return this.subi(other, this);
    }

    public FloatMatrix sub(FloatMatrix other) {
        return this.subi(other, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix subi(float v) {
        return this.subi(v, this);
    }

    public FloatMatrix sub(float v) {
        return this.subi(v, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix rsubi(FloatMatrix other) {
        return this.rsubi(other, this);
    }

    public FloatMatrix rsub(FloatMatrix other) {
        return this.rsubi(other, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix rsubi(float v) {
        return this.rsubi(v, this);
    }

    public FloatMatrix rsub(float v) {
        return this.rsubi(v, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix divi(FloatMatrix other) {
        return this.divi(other, this);
    }

    public FloatMatrix div(FloatMatrix other) {
        return this.divi(other, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix divi(float v) {
        return this.divi(v, this);
    }

    public FloatMatrix div(float v) {
        return this.divi(v, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix rdivi(FloatMatrix other) {
        return this.rdivi(other, this);
    }

    public FloatMatrix rdiv(FloatMatrix other) {
        return this.rdivi(other, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix rdivi(float v) {
        return this.rdivi(v, this);
    }

    public FloatMatrix rdiv(float v) {
        return this.rdivi(v, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix muli(FloatMatrix other) {
        return this.muli(other, this);
    }

    public FloatMatrix mul(FloatMatrix other) {
        return this.muli(other, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix muli(float v) {
        return this.muli(v, this);
    }

    public FloatMatrix mul(float v) {
        return this.muli(v, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix mmuli(FloatMatrix other) {
        return this.mmuli(other, this);
    }

    public FloatMatrix mmul(FloatMatrix other) {
        return this.mmuli(other, new FloatMatrix(this.rows, other.columns));
    }

    public FloatMatrix mmuli(float v) {
        return this.mmuli(v, this);
    }

    public FloatMatrix mmul(float v) {
        return this.mmuli(v, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix lti(FloatMatrix other, FloatMatrix result) {
        if (other.isScalar()) {
            return this.lti(other.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) < other.get(i) ? 1.0f : 0.0f);
        }
        return result;
    }

    public FloatMatrix lti(FloatMatrix other) {
        return this.lti(other, this);
    }

    public FloatMatrix lt(FloatMatrix other) {
        return this.lti(other, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix lti(float value, FloatMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) < value ? 1.0f : 0.0f);
        }
        return result;
    }

    public FloatMatrix lti(float value) {
        return this.lti(value, this);
    }

    public FloatMatrix lt(float value) {
        return this.lti(value, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix gti(FloatMatrix other, FloatMatrix result) {
        if (other.isScalar()) {
            return this.gti(other.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) > other.get(i) ? 1.0f : 0.0f);
        }
        return result;
    }

    public FloatMatrix gti(FloatMatrix other) {
        return this.gti(other, this);
    }

    public FloatMatrix gt(FloatMatrix other) {
        return this.gti(other, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix gti(float value, FloatMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) > value ? 1.0f : 0.0f);
        }
        return result;
    }

    public FloatMatrix gti(float value) {
        return this.gti(value, this);
    }

    public FloatMatrix gt(float value) {
        return this.gti(value, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix lei(FloatMatrix other, FloatMatrix result) {
        if (other.isScalar()) {
            return this.lei(other.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) <= other.get(i) ? 1.0f : 0.0f);
        }
        return result;
    }

    public FloatMatrix lei(FloatMatrix other) {
        return this.lei(other, this);
    }

    public FloatMatrix le(FloatMatrix other) {
        return this.lei(other, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix lei(float value, FloatMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) <= value ? 1.0f : 0.0f);
        }
        return result;
    }

    public FloatMatrix lei(float value) {
        return this.lei(value, this);
    }

    public FloatMatrix le(float value) {
        return this.lei(value, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix gei(FloatMatrix other, FloatMatrix result) {
        if (other.isScalar()) {
            return this.gei(other.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) >= other.get(i) ? 1.0f : 0.0f);
        }
        return result;
    }

    public FloatMatrix gei(FloatMatrix other) {
        return this.gei(other, this);
    }

    public FloatMatrix ge(FloatMatrix other) {
        return this.gei(other, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix gei(float value, FloatMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) >= value ? 1.0f : 0.0f);
        }
        return result;
    }

    public FloatMatrix gei(float value) {
        return this.gei(value, this);
    }

    public FloatMatrix ge(float value) {
        return this.gei(value, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix eqi(FloatMatrix other, FloatMatrix result) {
        if (other.isScalar()) {
            return this.eqi(other.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) == other.get(i) ? 1.0f : 0.0f);
        }
        return result;
    }

    public FloatMatrix eqi(FloatMatrix other) {
        return this.eqi(other, this);
    }

    public FloatMatrix eq(FloatMatrix other) {
        return this.eqi(other, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix eqi(float value, FloatMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) == value ? 1.0f : 0.0f);
        }
        return result;
    }

    public FloatMatrix eqi(float value) {
        return this.eqi(value, this);
    }

    public FloatMatrix eq(float value) {
        return this.eqi(value, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix nei(FloatMatrix other, FloatMatrix result) {
        if (other.isScalar()) {
            return this.nei(other.scalar(), result);
        }
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) != other.get(i) ? 1.0f : 0.0f);
        }
        return result;
    }

    public FloatMatrix nei(FloatMatrix other) {
        return this.nei(other, this);
    }

    public FloatMatrix ne(FloatMatrix other) {
        return this.nei(other, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix nei(float value, FloatMatrix result) {
        this.ensureResultLength(null, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) != value ? 1.0f : 0.0f);
        }
        return result;
    }

    public FloatMatrix nei(float value) {
        return this.nei(value, this);
    }

    public FloatMatrix ne(float value) {
        return this.nei(value, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix andi(FloatMatrix other, FloatMatrix result) {
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) != 0.0f & other.get(i) != 0.0f ? 1.0f : 0.0f);
        }
        return result;
    }

    public FloatMatrix andi(FloatMatrix other) {
        return this.andi(other, this);
    }

    public FloatMatrix and(FloatMatrix other) {
        return this.andi(other, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix andi(float value, FloatMatrix result) {
        this.ensureResultLength(null, result);
        boolean val = value != 0.0f;
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) != 0.0f & val ? 1.0f : 0.0f);
        }
        return result;
    }

    public FloatMatrix andi(float value) {
        return this.andi(value, this);
    }

    public FloatMatrix and(float value) {
        return this.andi(value, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix ori(FloatMatrix other, FloatMatrix result) {
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) != 0.0f | other.get(i) != 0.0f ? 1.0f : 0.0f);
        }
        return result;
    }

    public FloatMatrix ori(FloatMatrix other) {
        return this.ori(other, this);
    }

    public FloatMatrix or(FloatMatrix other) {
        return this.ori(other, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix ori(float value, FloatMatrix result) {
        this.ensureResultLength(null, result);
        boolean val = value != 0.0f;
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) != 0.0f | val ? 1.0f : 0.0f);
        }
        return result;
    }

    public FloatMatrix ori(float value) {
        return this.ori(value, this);
    }

    public FloatMatrix or(float value) {
        return this.ori(value, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix xori(FloatMatrix other, FloatMatrix result) {
        this.assertSameLength(other);
        this.ensureResultLength(other, result);
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) != 0.0f ^ other.get(i) != 0.0f ? 1.0f : 0.0f);
        }
        return result;
    }

    public FloatMatrix xori(FloatMatrix other) {
        return this.xori(other, this);
    }

    public FloatMatrix xor(FloatMatrix other) {
        return this.xori(other, new FloatMatrix(this.rows, this.columns));
    }

    public FloatMatrix xori(float value, FloatMatrix result) {
        this.ensureResultLength(null, result);
        boolean val = value != 0.0f;
        for (int i = 0; i < this.length; ++i) {
            result.put(i, this.get(i) != 0.0f ^ val ? 1.0f : 0.0f);
        }
        return result;
    }

    public FloatMatrix xori(float value) {
        return this.xori(value, this);
    }

    public FloatMatrix xor(float value) {
        return this.xori(value, new FloatMatrix(this.rows, this.columns));
    }

    public ComplexFloatMatrix toComplex() {
        return new ComplexFloatMatrix(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ColumnsAsListView
    extends AbstractList<FloatMatrix>
    implements ConvertsToFloatMatrix {
        private FloatMatrix me;

        public ColumnsAsListView(FloatMatrix me) {
            this.me = me;
        }

        @Override
        public FloatMatrix get(int index) {
            return FloatMatrix.this.getColumn(index);
        }

        @Override
        public int size() {
            return FloatMatrix.this.columns;
        }

        @Override
        public FloatMatrix convertToFloatMatrix() {
            return this.me;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RowsAsListView
    extends AbstractList<FloatMatrix>
    implements ConvertsToFloatMatrix {
        private FloatMatrix me;

        public RowsAsListView(FloatMatrix me) {
            this.me = me;
        }

        @Override
        public FloatMatrix get(int index) {
            return FloatMatrix.this.getRow(index);
        }

        @Override
        public int size() {
            return FloatMatrix.this.rows;
        }

        @Override
        public FloatMatrix convertToFloatMatrix() {
            return this.me;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ElementsAsListView
    extends AbstractList<Float>
    implements ConvertsToFloatMatrix {
        private FloatMatrix me;

        public ElementsAsListView(FloatMatrix me) {
            this.me = me;
        }

        @Override
        public Float get(int index) {
            return Float.valueOf(this.me.get(index));
        }

        @Override
        public int size() {
            return this.me.length;
        }

        @Override
        public FloatMatrix convertToFloatMatrix() {
            return this.me;
        }
    }
}

