/*
 * Decompiled with CFR 0.152.
 */
package JSci.swing;

import JSci.swing.JPointer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JArcDial
extends JPanel {
    private double oneTurn;
    private double zero;
    private double startValue;
    private double endValue;
    private double startAngle = -1.0471975511965976;
    private double endAngle = 1.0471975511965976;
    private double ha;
    private double hb;
    private double va;
    private double vb;
    private double minorTic = 5.0;
    private double majorTic = 20.0;
    private boolean setPaintMinorTicks = true;
    private boolean setPaintMajorTicks = true;
    private boolean setPaintLabels = true;
    private double radius = 70.0;
    private ArrayList pointers = new ArrayList();
    private ChangeListener changeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            JArcDial.this.repaint();
        }
    };
    private Line2D[] minorTics = null;
    private Line2D[] majorTics = null;
    private Point2D[] ticLabelPos = null;
    private String[] ticLabelText = null;
    private static NumberFormat formatter = NumberFormat.getNumberInstance();
    private JPointer dragged = null;
    private double dragDelta;

    public JArcDial(double d, double d2) {
        this.startValue = d;
        this.endValue = d2;
        this.oneTurn = (this.endValue - this.startValue) * 2.0 * Math.PI / (this.endAngle - this.startAngle);
        this.zero = this.startAngle - Math.PI * 2 * this.startValue / this.oneTurn;
        this.setArc(-1.0471975511965976, 1.0471975511965976);
        this.setSize((int)(2.0 * this.radius), (int)(2.0 * this.radius));
        this.addMouseListener(new TheMouseListener());
        this.addMouseMotionListener(new TheMouseMotionListener());
    }

    public void setArc(double d, double d2) {
        double d3;
        if (d > d2) {
            throw new IllegalArgumentException("start angle >stop angle");
        }
        this.startAngle = d;
        this.endAngle = d2;
        this.oneTurn = (this.endValue - this.startValue) * 2.0 * Math.PI / (this.endAngle - this.startAngle);
        this.zero = this.startAngle - Math.PI * 2 * this.startValue / this.oneTurn;
        for (d3 = -1.5707963267948966 + Math.PI * 2 * (double)Math.round(d); d3 > d; d3 -= Math.PI * 2) {
        }
        while (d3 < d) {
            d3 += Math.PI * 2;
        }
        this.ha = d3 < d2 ? 1.0 : Math.max(-Math.sin(d) + 0.1, -Math.sin(d2) + 0.1);
        for (d3 = 1.5707963267948966 + Math.PI * 2 * (double)Math.round(d); d3 > d; d3 -= Math.PI * 2) {
        }
        while (d3 < d) {
            d3 += Math.PI * 2;
        }
        this.hb = d3 < d2 ? 1.0 : Math.max(Math.sin(d) + 0.1, Math.sin(d2) + 0.1);
        for (d3 = Math.PI * 2 * (double)Math.round(d); d3 > d; d3 -= Math.PI * 2) {
        }
        while (d3 < d) {
            d3 += Math.PI * 2;
        }
        this.va = d3 < d2 ? 1.0 : Math.max(Math.cos(d) + 0.1, Math.cos(d2) + 0.1);
        for (d3 = Math.PI + Math.PI * 2 * (double)Math.round(d); d3 > d; d3 -= Math.PI * 2) {
        }
        while (d3 < d) {
            d3 += Math.PI * 2;
        }
        this.vb = d3 < d2 ? 1.0 : Math.max(-Math.cos(d) + 0.1, -Math.cos(d2) + 0.1);
        this.setSize((int)((this.ha + this.hb) * this.radius), (int)((this.va + this.vb) * this.radius));
        this.repaint();
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.radius = Math.min((double)n / (this.ha + this.hb), (double)n2 / (this.va + this.vb));
        this.updateMinorTics();
        this.updateMajorTics();
        this.repaint();
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.setSize((int)dimension.getWidth(), (int)dimension.getHeight());
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)((this.ha + this.hb) * this.radius), (int)((this.va + this.vb) * this.radius));
    }

    public void setMinorTickSpacing(double d) {
        this.minorTic = d;
        this.updateMinorTics();
        this.repaint();
    }

    public void setMajorTickSpacing(double d) {
        this.majorTic = d;
        this.updateMajorTics();
        this.repaint();
    }

    public void setPaintMinorTicks(boolean bl) {
        this.setPaintMinorTicks = bl;
        this.repaint();
    }

    public void setPaintMajorTicks(boolean bl) {
        this.setPaintMajorTicks = bl;
        this.repaint();
    }

    public void setPaintLabels(boolean bl) {
        this.setPaintLabels = bl;
        this.repaint();
    }

    private void updateMinorTics() {
        int n = (int)Math.abs((this.endValue - this.startValue) / this.minorTic);
        double d = this.startValue < this.endValue ? this.startValue : this.endValue;
        this.minorTics = new Line2D[n];
        for (int i = 0; i < n; ++i) {
            this.minorTics[i] = new Line2D.Double(this.radius + this.radius * 0.65 * Math.sin(this.zero + Math.PI * 2 * (d + (double)i * this.minorTic) / this.oneTurn), this.radius - this.radius * 0.65 * Math.cos(this.zero + Math.PI * 2 * (d + (double)i * this.minorTic) / this.oneTurn), this.radius + this.radius * 0.75 * Math.sin(this.zero + Math.PI * 2 * (d + (double)i * this.minorTic) / this.oneTurn), this.radius - this.radius * 0.75 * Math.cos(this.zero + Math.PI * 2 * (d + (double)i * this.minorTic) / this.oneTurn));
        }
    }

    private void updateMajorTics() {
        int n = (int)Math.abs((this.endValue - this.startValue) / this.majorTic) + 1;
        double d = this.startValue < this.endValue ? this.startValue : this.endValue;
        this.majorTics = new Line2D[n];
        this.ticLabelPos = new Point2D[n];
        this.ticLabelText = new String[n];
        for (int i = 0; i < n; ++i) {
            this.majorTics[i] = new Line2D.Double(this.radius + this.radius * 0.65 * Math.sin(this.zero + Math.PI * 2 * (d + (double)i * this.majorTic) / this.oneTurn), this.radius - this.radius * 0.65 * Math.cos(this.zero + Math.PI * 2 * (d + (double)i * this.majorTic) / this.oneTurn), this.radius + this.radius * 0.8 * Math.sin(this.zero + Math.PI * 2 * (d + (double)i * this.majorTic) / this.oneTurn), this.radius - this.radius * 0.8 * Math.cos(this.zero + Math.PI * 2 * (d + (double)i * this.majorTic) / this.oneTurn));
            this.ticLabelText[i] = formatter.format(d + (double)i * this.majorTic);
            this.ticLabelPos[i] = new Point2D.Double(this.radius + this.radius * 0.9 * Math.sin(this.zero + Math.PI * 2 * (d + (double)i * this.majorTic) / this.oneTurn) - (double)(this.ticLabelText[i].length() * 3), this.radius - this.radius * 0.9 * Math.cos(this.zero + Math.PI * 2 * (d + (double)i * this.majorTic) / this.oneTurn) + 6.0);
        }
    }

    public void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.setPaintMinorTicks) {
            for (n = 0; n < this.minorTics.length; ++n) {
                graphics2D.draw(this.minorTics[n]);
            }
        }
        if (this.setPaintMajorTicks) {
            for (n = 0; n < this.majorTics.length; ++n) {
                graphics2D.draw(this.majorTics[n]);
            }
        }
        if (this.setPaintLabels) {
            for (n = 0; n < this.majorTics.length; ++n) {
                graphics2D.drawString(this.ticLabelText[n], (int)this.ticLabelPos[n].getX(), (int)this.ticLabelPos[n].getY());
            }
        }
        Color color = graphics2D.getColor();
        for (int i = 0; i < this.pointers.size(); ++i) {
            ((JPointer)this.pointers.get(i)).paintOnDial(graphics2D, this.radius, this.oneTurn, this.zero, this.radius * this.ha, this.radius * this.va);
        }
        graphics2D.setColor(color);
        graphics2D.fill(new Ellipse2D.Double(this.radius - 3.0, this.radius - 3.0, 6.0, 6.0));
    }

    public void addJPointer(JPointer jPointer) {
        for (int i = 0; i < this.pointers.size(); ++i) {
            if (!this.pointers.get(i).equals(jPointer)) continue;
            return;
        }
        this.pointers.add(jPointer);
        jPointer.addChangeListener(this.changeListener);
        this.repaint();
    }

    public void removeJPointer(JPointer jPointer) {
        int n = 0;
        while (n < this.pointers.size()) {
            if (this.pointers.get(n).equals(jPointer)) {
                this.pointers.remove(n);
                continue;
            }
            ++n;
        }
        jPointer.removeChangeListener(this.changeListener);
        this.repaint();
    }

    private double theta(MouseEvent mouseEvent) {
        return Math.atan2((double)mouseEvent.getX() - this.radius, -((double)mouseEvent.getY() - this.radius));
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        JArcDial jArcDial = new JArcDial(90.0, 10.0);
        jArcDial.setArc(-2.0943951023931953, 0.5235987755982988);
        jFrame.getContentPane().add(jArcDial);
        jArcDial.setSize(260, 260);
        jFrame.pack();
        jFrame.show();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        JPointer jPointer = new JPointer(1);
        jPointer.setColor(Color.MAGENTA);
        jPointer.setValue(25.0);
        jArcDial.addJPointer(jPointer);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        JPointer jPointer2 = new JPointer(0);
        jPointer2.setColor(Color.CYAN);
        jPointer2.setValue(75.0);
        jArcDial.addJPointer(jPointer2);
        jPointer2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = ((JPointer)changeEvent.getSource()).getValue();
                System.out.println("State changed: " + d);
            }
        });
    }

    static {
        formatter.setMaximumFractionDigits(2);
        formatter.setMaximumIntegerDigits(3);
    }

    private class TheMouseMotionListener
    extends MouseMotionAdapter {
        private TheMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            boolean bl = false;
            for (int i = 0; i < JArcDial.this.pointers.size(); ++i) {
                if (!((JPointer)JArcDial.this.pointers.get(i)).contains(mouseEvent.getPoint())) continue;
                bl = true;
                break;
            }
            if (bl) {
                JArcDial.this.setCursor(Cursor.getPredefinedCursor(1));
            } else {
                JArcDial.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (JArcDial.this.dragged != null) {
                double d = JArcDial.this.theta(mouseEvent) + JArcDial.this.dragDelta;
                if (JArcDial.this.zero + d > JArcDial.this.endAngle) {
                    d = JArcDial.this.endAngle - JArcDial.this.zero;
                }
                if (JArcDial.this.zero + d < JArcDial.this.startAngle) {
                    d = JArcDial.this.startAngle - JArcDial.this.zero;
                }
                JArcDial.this.dragged.setValue(d *= JArcDial.this.oneTurn / 2.0 / Math.PI);
                JArcDial.this.repaint();
            }
        }
    }

    private class TheMouseListener
    extends MouseAdapter {
        private TheMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            for (int i = JArcDial.this.pointers.size() - 1; i >= 0; --i) {
                if (!((JPointer)JArcDial.this.pointers.get(i)).contains(mouseEvent.getPoint())) continue;
                JArcDial.this.dragged = (JPointer)JArcDial.this.pointers.get(i);
                JArcDial.this.dragDelta = Math.PI * 2 * JArcDial.this.dragged.getValue() / JArcDial.this.oneTurn - JArcDial.this.theta(mouseEvent);
                JArcDial.this.dragged.setAdjusting(true);
                break;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (JArcDial.this.dragged != null) {
                JArcDial.this.dragged.setAdjusting(false);
            }
            JArcDial.this.dragged = null;
            boolean bl = false;
            for (int i = 0; i < JArcDial.this.pointers.size(); ++i) {
                if (!((JPointer)JArcDial.this.pointers.get(i)).contains(mouseEvent.getPoint())) continue;
                bl = true;
                break;
            }
            if (bl) {
                JArcDial.this.setCursor(Cursor.getPredefinedCursor(1));
            } else {
                JArcDial.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

